/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.systemconfiguration;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Array;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

class sockaddr_in
extends Struct<sockaddr_in> {
    private static final byte AF_INET = 2;

    public sockaddr_in() {
        this.sin_len((byte)sockaddr_in.sizeOf());
        this.sin_family((byte)2);
    }

    public sockaddr_in(InetSocketAddress address) {
        this();
        this.sin_port((short)address.getPort());
        InetAddress addr = address.getAddress();
        if (!(addr instanceof Inet4Address)) {
            throw new IllegalArgumentException("address must be a valid IPv4 address!");
        }
        this.sin_addr(addr.getAddress());
    }

    @StructMember(value=0)
    public native byte sin_len();

    @StructMember(value=0)
    public native sockaddr_in sin_len(byte var1);

    @StructMember(value=1)
    public native byte sin_family();

    @StructMember(value=1)
    public native sockaddr_in sin_family(byte var1);

    @StructMember(value=2)
    public native short sin_port();

    @StructMember(value=2)
    public native sockaddr_in sin_port(short var1);

    @StructMember(value=3)
    @Array(value={4})
    public native byte[] sin_addr();

    @StructMember(value=3)
    public native sockaddr_in sin_addr(@Array(value={4}) byte[] var1);

    @StructMember(value=4)
    @Array(value={8})
    public native char[] sin_zero();

    @StructMember(value=4)
    public native sockaddr_in sin_zero(@Array(value={8}) char[] var1);

    public InetSocketAddress toInetSocketAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByAddress(this.sin_addr()), (int)this.sin_port());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class sockaddr_inPtr
    extends Ptr<sockaddr_in, sockaddr_inPtr> {
    }
}

