/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSItemProviderRepresentationVisibility;
import org.robovm.apple.foundation.NSMutableAttributedString;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.uikit.NSLayoutManager;
import org.robovm.apple.uikit.NSTextStorageDelegate;
import org.robovm.apple.uikit.NSTextStorageEditActions;
import org.robovm.apple.uikit.NSTextStorageObserving;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="UIKit")
@NativeClass
public class NSTextStorage
extends NSMutableAttributedString
implements NSSecureCoding {
    public NSTextStorage() {
    }

    protected NSTextStorage(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSTextStorage(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="layoutManagers")
    public native NSArray<NSLayoutManager> getLayoutManagers();

    @Property(selector="editedMask")
    public native NSTextStorageEditActions getEditedMask();

    @Property(selector="editedRange")
    @ByVal
    public native NSRange getEditedRange();

    @Property(selector="changeInLength")
    @MachineSizedSInt
    public native long getChangeInLength();

    @Property(selector="delegate")
    public native NSTextStorageDelegate getDelegate();

    @Property(selector="setDelegate:", strongRef=true)
    public native void setDelegate(NSTextStorageDelegate var1);

    @Property(selector="fixesAttributesLazily")
    public native boolean fixesAttributesLazily();

    @Property(selector="textStorageObserver")
    public native NSTextStorageObserving getTextStorageObserver();

    @Property(selector="setTextStorageObserver:", strongRef=true)
    public native void setTextStorageObserver(NSTextStorageObserving var1);

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    @Property(selector="readableTypeIdentifiersForItemProvider")
    public static native NSArray<NSString> getReadableTypeIdentifiersForItemProvider();

    @Property(selector="writableTypeIdentifiersForItemProvider")
    public static native NSArray<NSString> getWritableTypeIdentifiersForItemProvider0();

    @GlobalValue(symbol="NSTextStorageWillProcessEditingNotification", optional=true)
    public static native NSString WillProcessEditingNotification();

    @GlobalValue(symbol="NSTextStorageDidProcessEditingNotification", optional=true)
    public static native NSString DidProcessEditingNotification();

    @Method(selector="addLayoutManager:")
    public native void addLayoutManager(NSLayoutManager var1);

    @Method(selector="removeLayoutManager:")
    public native void removeLayoutManager(NSLayoutManager var1);

    @Method(selector="edited:range:changeInLength:")
    public native void edited(NSTextStorageEditActions var1, @ByVal NSRange var2, @MachineSizedSInt long var3);

    @Method(selector="processEditing")
    public native void processEditing();

    @Method(selector="invalidateAttributesInRange:")
    public native void invalidateAttributes(@ByVal NSRange var1);

    @Method(selector="ensureAttributesAreFixedInRange:")
    public native void ensureAttributesAreFixed(@ByVal NSRange var1);

    public static NSTextStorage createProviderDataObject(NSData data, String typeIdentifier) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSTextStorage result = NSTextStorage.createProviderDataObject(data, typeIdentifier, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="objectWithItemProviderData:typeIdentifier:error:")
    private static native NSTextStorage createProviderDataObject(NSData var0, String var1, NSError.NSErrorPtr var2);

    @Method(selector="itemProviderVisibilityForRepresentationWithTypeIdentifier:")
    public static native NSItemProviderRepresentationVisibility getItemProviderVisibility0(String var0);

    static {
        ObjCRuntime.bind(NSTextStorage.class);
    }

    public static class NSTextStoragePtr
    extends Ptr<NSTextStorage, NSTextStoragePtr> {
    }

    public static class Notifications {
        public static NSObject observeWillProcessEditing(NSTextStorage object, final VoidBlock1<NSTextStorage> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSTextStorage.WillProcessEditingNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSTextStorage)a.getObject()));
                }
            });
        }

        public static NSObject observeDidProcessEditing(NSTextStorage object, final VoidBlock1<NSTextStorage> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSTextStorage.DidProcessEditingNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSTextStorage)a.getObject()));
                }
            });
        }
    }
}

