/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import org.robovm.apple.audiotoolbox.AudioComponent;
import org.robovm.apple.audiotoolbox.AudioComponentInstance;
import org.robovm.apple.audiotoolbox.MusicDeviceNoteParams;
import org.robovm.apple.audiotoolbox.MusicDeviceSelector;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coremidi.MIDIEventList;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.IntPtr;

@Library(value="AudioToolbox")
public class MusicDevice
extends AudioComponentInstance {
    public static MusicDevice create(AudioComponent component) throws OSStatusException {
        AudioComponentInstance result = AudioComponentInstance.create(component);
        if (result != null) {
            return (MusicDevice)result.as(MusicDevice.class);
        }
        return null;
    }

    public boolean canDo(MusicDeviceSelector inSelectorID) {
        return super.canDo((short)inSelectorID.value());
    }

    public void midiEvent(int status, int data1, int data2, int offsetSampleFrame) throws OSStatusException {
        OSStatus s = MusicDevice.midiEvent0(this, status, data1, data2, offsetSampleFrame);
        OSStatusException.throwIfNecessary(s);
    }

    public void sysEx(byte[] data) throws OSStatusException {
        OSStatus status = MusicDevice.sysEx0(this, VM.getArrayValuesAddress((Object)data), data.length);
        OSStatusException.throwIfNecessary(status);
    }

    public int startNote(int groupID, int offsetSampleFrame, MusicDeviceNoteParams params) throws OSStatusException {
        IntPtr result = new IntPtr();
        OSStatus status = MusicDevice.startNote0(this, -1, groupID, result, offsetSampleFrame, params);
        OSStatusException.throwIfNecessary(status);
        return result.get();
    }

    public void stopNote(int groupID, int noteInstanceID, int offsetSampleFrame) throws OSStatusException {
        OSStatus status = MusicDevice.stopNote0(this, groupID, noteInstanceID, offsetSampleFrame);
        OSStatusException.throwIfNecessary(status);
    }

    @Bridge(symbol="MusicDeviceMIDIEvent", optional=true)
    protected static native OSStatus midiEvent0(AudioComponentInstance var0, int var1, int var2, int var3, int var4);

    @Bridge(symbol="MusicDeviceSysEx", optional=true)
    protected static native OSStatus sysEx0(AudioComponentInstance var0, @Pointer long var1, int var3);

    @Bridge(symbol="MusicDeviceMIDIEventList", optional=true)
    protected static native OSStatus mIDIEventList0(AudioComponentInstance var0, int var1, MIDIEventList var2);

    @Bridge(symbol="MusicDeviceStartNote", optional=true)
    protected static native OSStatus startNote0(AudioComponentInstance var0, int var1, int var2, IntPtr var3, int var4, MusicDeviceNoteParams var5);

    @Bridge(symbol="MusicDeviceStopNote", optional=true)
    protected static native OSStatus stopNote0(AudioComponentInstance var0, int var1, int var2, int var3);

    static {
        Bro.bind(MusicDevice.class);
    }
}

