/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import org.robovm.apple.audiotoolbox.MusicEventType;
import org.robovm.apple.audiotoolbox.MusicTrack;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="AudioToolbox")
public class MusicEventIterator
extends NativeObject {
    private double eventTime;
    private MusicEventType eventType;
    private VoidPtr eventData;
    private int eventDataSize;

    protected MusicEventIterator() {
    }

    public static MusicEventIterator create(MusicTrack track) throws OSStatusException {
        MusicEventIteratorPtr ptr = new MusicEventIteratorPtr();
        OSStatus status = MusicEventIterator.create0(track, ptr);
        OSStatusException.throwIfNecessary(status);
        return (MusicEventIterator)ptr.get();
    }

    public void dispose() throws OSStatusException {
        OSStatus status = this.dispose0();
        OSStatusException.throwIfNecessary(status);
    }

    public void seek(double timeStamp) throws OSStatusException {
        OSStatus status = this.seek0(timeStamp);
        OSStatusException.throwIfNecessary(status);
    }

    public void nextEvent() throws OSStatusException {
        OSStatus status = this.nextEvent0();
        OSStatusException.throwIfNecessary(status);
    }

    public void previousEvent() throws OSStatusException {
        OSStatus status = this.previousEvent0();
        OSStatusException.throwIfNecessary(status);
    }

    public void fetchEventInfo() throws OSStatusException {
        DoublePtr timeStampPtr = new DoublePtr();
        IntPtr eventTypePtr = new IntPtr();
        VoidPtr.VoidPtrPtr eventDataPtr = new VoidPtr.VoidPtrPtr();
        IntPtr eventDataSizePtr = new IntPtr();
        OSStatus status = this.getEventInfo0(timeStampPtr, eventTypePtr, eventDataPtr, eventDataSizePtr);
        OSStatusException.throwIfNecessary(status);
        this.eventTime = timeStampPtr.get();
        this.eventType = MusicEventType.valueOf(eventTypePtr.get());
        this.eventData = (VoidPtr)eventDataPtr.get();
        this.eventDataSize = eventDataSizePtr.get();
    }

    public double getEventTime() {
        return this.eventTime;
    }

    public MusicEventType getEventType() {
        return this.eventType;
    }

    public <T extends Struct<T>> T getEventData(Class<T> type) {
        Struct data = Struct.allocate(type);
        data.update((Struct)this.eventData.as(type));
        return (T)data;
    }

    public int getEventDataSize() {
        return this.eventDataSize;
    }

    public <T extends Struct<T>> void setEventData(MusicEventType type, T data) throws OSStatusException {
        OSStatus status = this.setEventInfo0(type, (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
    }

    public void setEventTime(double timeStamp) throws OSStatusException {
        OSStatus status = this.setEventTime0(timeStamp);
        OSStatusException.throwIfNecessary(status);
    }

    public void deleteEvent() throws OSStatusException {
        OSStatus status = this.deleteEvent0();
        OSStatusException.throwIfNecessary(status);
    }

    public boolean hasPreviousEvent() throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.hasPreviousEvent0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public boolean hasNextEvent() throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.hasNextEvent0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public boolean hasCurrentEvent() throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.hasCurrentEvent0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    @Bridge(symbol="NewMusicEventIterator", optional=true)
    protected static native OSStatus create0(MusicTrack var0, MusicEventIteratorPtr var1);

    @Bridge(symbol="DisposeMusicEventIterator", optional=true)
    protected native OSStatus dispose0();

    @Bridge(symbol="MusicEventIteratorSeek", optional=true)
    protected native OSStatus seek0(double var1);

    @Bridge(symbol="MusicEventIteratorNextEvent", optional=true)
    protected native OSStatus nextEvent0();

    @Bridge(symbol="MusicEventIteratorPreviousEvent", optional=true)
    protected native OSStatus previousEvent0();

    @Bridge(symbol="MusicEventIteratorGetEventInfo", optional=true)
    protected native OSStatus getEventInfo0(DoublePtr var1, IntPtr var2, VoidPtr.VoidPtrPtr var3, IntPtr var4);

    @Bridge(symbol="MusicEventIteratorSetEventInfo", optional=true)
    protected native OSStatus setEventInfo0(MusicEventType var1, VoidPtr var2);

    @Bridge(symbol="MusicEventIteratorSetEventTime", optional=true)
    protected native OSStatus setEventTime0(double var1);

    @Bridge(symbol="MusicEventIteratorDeleteEvent", optional=true)
    protected native OSStatus deleteEvent0();

    @Bridge(symbol="MusicEventIteratorHasPreviousEvent", optional=true)
    protected native OSStatus hasPreviousEvent0(BooleanPtr var1);

    @Bridge(symbol="MusicEventIteratorHasNextEvent", optional=true)
    protected native OSStatus hasNextEvent0(BooleanPtr var1);

    @Bridge(symbol="MusicEventIteratorHasCurrentEvent", optional=true)
    protected native OSStatus hasCurrentEvent0(BooleanPtr var1);

    static {
        Bro.bind(MusicEventIterator.class);
    }

    public static class MusicEventIteratorPtr
    extends Ptr<MusicEventIterator, MusicEventIteratorPtr> {
    }
}

