/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVAudioTimePitchAlgorithm;
import org.robovm.apple.avfoundation.AVTimeRamp;
import org.robovm.apple.coremedia.CMTime;
import org.robovm.apple.coremedia.CMTimeRange;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.mediatoolbox.MTAudioProcessingTap;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVAudioMixInputParameters
extends NSObject {
    public AVAudioMixInputParameters() {
    }

    @Deprecated
    protected AVAudioMixInputParameters(long handle) {
        super(handle);
    }

    protected AVAudioMixInputParameters(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVAudioMixInputParameters(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="trackID")
    public native int getTrackID();

    @Property(selector="audioTimePitchAlgorithm")
    public native AVAudioTimePitchAlgorithm getAudioTimePitchAlgorithm();

    @Property(selector="audioTapProcessor")
    @WeaklyLinked
    public native MTAudioProcessingTap getAudioTapProcessor();

    public AVTimeRamp<Float> getVolumeRamp(CMTime time) {
        FloatPtr start = new FloatPtr();
        FloatPtr end = new FloatPtr();
        CMTimeRange.CMTimeRangePtr timeRange = new CMTimeRange.CMTimeRangePtr();
        boolean valid = this.getVolumeRamp(time, start, end, timeRange);
        if (valid) {
            return new AVTimeRamp<Float>(Float.valueOf(start.get()), Float.valueOf(end.get()), (CMTimeRange)timeRange.get());
        }
        return null;
    }

    @Method(selector="getVolumeRampForTime:startVolume:endVolume:timeRange:")
    protected native boolean getVolumeRamp(@ByVal CMTime var1, FloatPtr var2, FloatPtr var3, CMTimeRange.CMTimeRangePtr var4);

    static {
        ObjCRuntime.bind(AVAudioMixInputParameters.class);
    }

    public static class AVAudioMixInputParametersPtr
    extends Ptr<AVAudioMixInputParameters, AVAudioMixInputParametersPtr> {
    }
}

