/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVCaptureConnection;
import org.robovm.apple.avfoundation.AVCaptureInput;
import org.robovm.apple.avfoundation.AVCaptureOutput;
import org.robovm.apple.avfoundation.AVCaptureSessionInterruptionReason;
import org.robovm.apple.avfoundation.AVCaptureSessionPreset;
import org.robovm.apple.coremedia.CMClock;
import org.robovm.apple.foundation.Foundation;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVCaptureSession
extends NSObject {
    public AVCaptureSession() {
    }

    protected AVCaptureSession(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVCaptureSession(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="sessionPreset")
    public native AVCaptureSessionPreset getSessionPreset();

    @Property(selector="setSessionPreset:")
    public native void setSessionPreset(AVCaptureSessionPreset var1);

    @Property(selector="inputs")
    public native NSArray<AVCaptureInput> getInputs();

    @Property(selector="outputs")
    public native NSArray<AVCaptureOutput> getOutputs();

    @Property(selector="connections")
    public native NSArray<AVCaptureConnection> getConnections();

    @Property(selector="isRunning")
    public native boolean isRunning();

    @Property(selector="isInterrupted")
    public native boolean isInterrupted();

    @Property(selector="isMultitaskingCameraAccessSupported")
    public native boolean isMultitaskingCameraAccessSupported();

    @Property(selector="isMultitaskingCameraAccessEnabled")
    public native boolean isMultitaskingCameraAccessEnabled();

    @Property(selector="setMultitaskingCameraAccessEnabled:")
    public native void setMultitaskingCameraAccessEnabled(boolean var1);

    @Property(selector="usesApplicationAudioSession")
    public native boolean usesApplicationAudioSession();

    @Property(selector="setUsesApplicationAudioSession:")
    public native void setUsesApplicationAudioSession(boolean var1);

    @Property(selector="automaticallyConfiguresApplicationAudioSession")
    public native boolean automaticallyConfiguresApplicationAudioSession();

    @Property(selector="setAutomaticallyConfiguresApplicationAudioSession:")
    public native void setAutomaticallyConfiguresApplicationAudioSession(boolean var1);

    @Property(selector="automaticallyConfiguresCaptureDeviceForWideColor")
    public native boolean automaticallyConfiguresCaptureDeviceForWideColor();

    @Property(selector="setAutomaticallyConfiguresCaptureDeviceForWideColor:")
    public native void setAutomaticallyConfiguresCaptureDeviceForWideColor(boolean var1);

    @Property(selector="synchronizationClock")
    public native CMClock getSynchronizationClock();

    @Deprecated
    @Property(selector="masterClock")
    public native CMClock getMasterClock();

    @Property(selector="hardwareCost")
    public native float getHardwareCost();

    @GlobalValue(symbol="AVCaptureSessionRuntimeErrorNotification", optional=true)
    public static native NSString RuntimeErrorNotification();

    @GlobalValue(symbol="AVCaptureSessionErrorKey", optional=true)
    protected static native NSString NotificationErrorKey();

    @GlobalValue(symbol="AVCaptureSessionDidStartRunningNotification", optional=true)
    public static native NSString DidStartRunningNotification();

    @GlobalValue(symbol="AVCaptureSessionDidStopRunningNotification", optional=true)
    public static native NSString DidStopRunningNotification();

    @GlobalValue(symbol="AVCaptureSessionWasInterruptedNotification", optional=true)
    public static native NSString WasInterruptedNotification();

    @GlobalValue(symbol="AVCaptureSessionInterruptionReasonKey", optional=true)
    protected static native NSString NotificationInterruptionReasonKey();

    @GlobalValue(symbol="AVCaptureSessionInterruptionSystemPressureStateKey", optional=true)
    public static native String InterruptionSystemPressureStateKey();

    @GlobalValue(symbol="AVCaptureSessionInterruptionEndedNotification", optional=true)
    public static native NSString InterruptionEndedNotification();

    @Method(selector="canSetSessionPreset:")
    public native boolean canSetSessionPreset(AVCaptureSessionPreset var1);

    @Method(selector="canAddInput:")
    public native boolean canAddInput(AVCaptureInput var1);

    @Method(selector="addInput:")
    public native void addInput(AVCaptureInput var1);

    @Method(selector="removeInput:")
    public native void removeInput(AVCaptureInput var1);

    @Method(selector="canAddOutput:")
    public native boolean canAddOutput(AVCaptureOutput var1);

    @Method(selector="addOutput:")
    public native void addOutput(AVCaptureOutput var1);

    @Method(selector="removeOutput:")
    public native void removeOutput(AVCaptureOutput var1);

    @Method(selector="addInputWithNoConnections:")
    public native void addInputWithNoConnections(AVCaptureInput var1);

    @Method(selector="addOutputWithNoConnections:")
    public native void addOutputWithNoConnections(AVCaptureOutput var1);

    @Method(selector="canAddConnection:")
    public native boolean canAddConnection(AVCaptureConnection var1);

    @Method(selector="addConnection:")
    public native void addConnection(AVCaptureConnection var1);

    @Method(selector="removeConnection:")
    public native void removeConnection(AVCaptureConnection var1);

    @Method(selector="beginConfiguration")
    public native void beginConfiguration();

    @Method(selector="commitConfiguration")
    public native void commitConfiguration();

    @Method(selector="startRunning")
    public native void startRunning();

    @Method(selector="stopRunning")
    public native void stopRunning();

    static {
        ObjCRuntime.bind(AVCaptureSession.class);
    }

    public static class AVCaptureSessionPtr
    extends Ptr<AVCaptureSession, AVCaptureSessionPtr> {
    }

    public static class Notifications {
        public static NSObject observeRuntimeError(AVCaptureSession object, final VoidBlock2<AVCaptureSession, NSError> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVCaptureSession.RuntimeErrorNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<?, ?> data = a.getUserInfo();
                    NSError error = null;
                    if (data.containsKey(AVCaptureSession.NotificationErrorKey())) {
                        error = (NSError)data.get(AVCaptureSession.NotificationErrorKey());
                    }
                    block.invoke((Object)((AVCaptureSession)a.getObject()), (Object)error);
                }
            });
        }

        public static NSObject observeDidStartRunning(AVCaptureSession object, final VoidBlock1<AVCaptureSession> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVCaptureSession.DidStartRunningNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((AVCaptureSession)a.getObject()));
                }
            });
        }

        public static NSObject observeDidStopRunning(AVCaptureSession object, final VoidBlock1<AVCaptureSession> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVCaptureSession.DidStopRunningNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((AVCaptureSession)a.getObject()));
                }
            });
        }

        public static NSObject observeWasInterrupted(AVCaptureSession object, final VoidBlock2<AVCaptureSession, AVCaptureSessionInterruptionReason> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVCaptureSession.WasInterruptedNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification notification) {
                    NSDictionary<?, ?> data;
                    int value;
                    AVCaptureSessionInterruptionReason reason = AVCaptureSessionInterruptionReason.Unavailable;
                    if (Foundation.getMajorSystemVersion() >= 9 && (value = (data = notification.getUserInfo()).getInt(AVCaptureSession.NotificationInterruptionReasonKey(), 0)) != 0) {
                        reason = AVCaptureSessionInterruptionReason.valueOf(value);
                    }
                    block.invoke((Object)((AVCaptureSession)notification.getObject()), (Object)reason);
                }
            });
        }

        public static NSObject observeInterruptionEnded(AVCaptureSession object, final VoidBlock1<AVCaptureSession> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVCaptureSession.InterruptionEndedNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((AVCaptureSession)a.getObject()));
                }
            });
        }
    }
}

