/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.GlobalValueEnumeration;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="AVFoundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@StronglyLinked
public class AVMediaType
extends GlobalValueEnumeration<NSString> {
    public static final AVMediaType Video;
    public static final AVMediaType Audio;
    public static final AVMediaType Text;
    public static final AVMediaType ClosedCaption;
    public static final AVMediaType Subtitle;
    public static final AVMediaType Timecode;
    public static final AVMediaType Metadata;
    public static final AVMediaType Muxed;
    public static final AVMediaType Haptic;
    public static final AVMediaType MetadataObject;
    public static final AVMediaType DepthData;
    private static AVMediaType[] values;

    AVMediaType(String getterName) {
        super(Values.class, getterName);
    }

    public static AVMediaType valueOf(NSString value) {
        for (AVMediaType v : values) {
            if (!((NSString)v.value()).equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + AVMediaType.class.getName());
    }

    static {
        Bro.bind(AVMediaType.class);
        Video = new AVMediaType("Video");
        Audio = new AVMediaType("Audio");
        Text = new AVMediaType("Text");
        ClosedCaption = new AVMediaType("ClosedCaption");
        Subtitle = new AVMediaType("Subtitle");
        Timecode = new AVMediaType("Timecode");
        Metadata = new AVMediaType("Metadata");
        Muxed = new AVMediaType("Muxed");
        Haptic = new AVMediaType("Haptic");
        MetadataObject = new AVMediaType("MetadataObject");
        DepthData = new AVMediaType("DepthData");
        values = new AVMediaType[]{Video, Audio, Text, ClosedCaption, Subtitle, Timecode, Metadata, Muxed, Haptic, MetadataObject, DepthData};
    }

    @Library(value="AVFoundation")
    @StronglyLinked
    public static class Values {
        @GlobalValue(symbol="AVMediaTypeVideo", optional=true)
        public static native NSString Video();

        @GlobalValue(symbol="AVMediaTypeAudio", optional=true)
        public static native NSString Audio();

        @GlobalValue(symbol="AVMediaTypeText", optional=true)
        public static native NSString Text();

        @GlobalValue(symbol="AVMediaTypeClosedCaption", optional=true)
        public static native NSString ClosedCaption();

        @GlobalValue(symbol="AVMediaTypeSubtitle", optional=true)
        public static native NSString Subtitle();

        @GlobalValue(symbol="AVMediaTypeTimecode", optional=true)
        public static native NSString Timecode();

        @GlobalValue(symbol="AVMediaTypeMetadata", optional=true)
        public static native NSString Metadata();

        @GlobalValue(symbol="AVMediaTypeMuxed", optional=true)
        public static native NSString Muxed();

        @GlobalValue(symbol="AVMediaTypeHaptic", optional=true)
        public static native NSString Haptic();

        @GlobalValue(symbol="AVMediaTypeMetadataObject", optional=true)
        public static native NSString MetadataObject();

        @GlobalValue(symbol="AVMediaTypeDepthData", optional=true)
        public static native NSString DepthData();

        static {
            Bro.bind(Values.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVMediaType> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<AVMediaType> list = new ArrayList<AVMediaType>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(AVMediaType.valueOf((NSString)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<AVMediaType> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSString> array = new NSMutableArray<NSString>();
            for (AVMediaType o : l) {
                array.add((NSString)o.value());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVMediaType toObject(Class<AVMediaType> cls, long handle, long flags) {
            NSString o = (NSString)NSObject.Marshaler.toObject(NSString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return AVMediaType.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(AVMediaType o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative((NSObject)o.value(), flags);
        }
    }
}

