/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.uikit.UIGeometry;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreGraphics")
public class CGPoint
extends Struct<CGPoint> {
    public CGPoint() {
    }

    public CGPoint(@MachineSizedFloat double x, @MachineSizedFloat double y) {
        this.setX(x);
        this.setY(y);
    }

    @StructMember(value=0)
    @MachineSizedFloat
    public native double getX();

    @StructMember(value=0)
    public native CGPoint setX(@MachineSizedFloat double var1);

    @StructMember(value=1)
    @MachineSizedFloat
    public native double getY();

    @StructMember(value=1)
    public native CGPoint setY(@MachineSizedFloat double var1);

    @WeaklyLinked
    public static CGPoint fromString(String string) {
        return UIGeometry.stringToCGPoint(string);
    }

    public static CGPoint fromDictionary(NSDictionary<NSString, NSNumber> dict) {
        CGPoint p = new CGPoint();
        if (!CGPoint.fromDictionary(dict, p)) {
            throw new IllegalArgumentException("Failed to create CGPoint from dictionary " + dict);
        }
        return p;
    }

    public boolean equals(Object obj) {
        return obj instanceof CGPoint && CGPoint.equalsTo(this, (CGPoint)((Object)obj));
    }

    @WeaklyLinked
    public String toString() {
        return UIGeometry.toString(this);
    }

    @GlobalValue(symbol="CGPointZero", optional=true)
    @ByVal
    public static native CGPoint Zero();

    public boolean equalsTo(CGPoint point2) {
        return CGPoint.equalsTo(this, point2);
    }

    @Bridge(symbol="CGPointEqualToPoint", optional=true)
    private static native boolean equalsTo(@ByVal CGPoint var0, @ByVal CGPoint var1);

    public NSDictionary<NSString, NSNumber> toDictionary() {
        return CGPoint.toDictionary(this);
    }

    @Bridge(symbol="CGPointCreateDictionaryRepresentation", optional=true)
    private static native NSDictionary<NSString, NSNumber> toDictionary(@ByVal CGPoint var0);

    @Bridge(symbol="CGPointMakeWithDictionaryRepresentation", optional=true)
    private static native boolean fromDictionary(NSDictionary<NSString, NSNumber> var0, CGPoint var1);

    public CGPoint apply(CGAffineTransform t) {
        return CGPoint.apply(this, t);
    }

    @Bridge(symbol="CGPointApplyAffineTransform", optional=true)
    @ByVal
    private static native CGPoint apply(@ByVal CGPoint var0, @ByVal CGAffineTransform var1);

    static {
        Bro.bind(CGPoint.class);
    }

    public static class CGPointPtr
    extends Ptr<CGPoint, CGPointPtr> {
    }
}

