/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coreimage.CIFormat;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreImage")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CIContextOptions
extends NSDictionaryWrapper {
    CIContextOptions(NSDictionary data) {
        super(data);
    }

    public CIContextOptions() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public CIContextOptions set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public CGColorSpace getOutputColorSpace() {
        if (this.has(Keys.OutputColorSpace())) {
            CGColorSpace val = (CGColorSpace)this.get(Keys.OutputColorSpace()).as(CGColorSpace.class);
            return val;
        }
        return null;
    }

    public CIContextOptions setOutputColorSpace(CGColorSpace outputColorSpace) {
        this.set(Keys.OutputColorSpace(), (NSObject)outputColorSpace.as(NSObject.class));
        return this;
    }

    public CGColorSpace getWorkingColorSpace() {
        if (this.has(Keys.WorkingColorSpace())) {
            CGColorSpace val = (CGColorSpace)this.get(Keys.WorkingColorSpace()).as(CGColorSpace.class);
            return val;
        }
        return null;
    }

    public CIContextOptions setWorkingColorSpace(CGColorSpace workingColorSpace) {
        this.set(Keys.WorkingColorSpace(), (NSObject)workingColorSpace.as(NSObject.class));
        return this;
    }

    public CIFormat getWorkingFormat() {
        if (this.has(Keys.WorkingFormat())) {
            NSNumber val = (NSNumber)this.get(Keys.WorkingFormat());
            return CIFormat.valueOf(val.intValue());
        }
        return null;
    }

    public CIContextOptions setWorkingFormat(CIFormat workingFormat) {
        this.set(Keys.WorkingFormat(), NSNumber.valueOf((Number)workingFormat.value()));
        return this;
    }

    public boolean usesSoftwareRenderer() {
        if (this.has(Keys.UseSoftwareRenderer())) {
            NSNumber val = (NSNumber)this.get(Keys.UseSoftwareRenderer());
            return val.booleanValue();
        }
        return false;
    }

    public CIContextOptions setUsesSoftwareRenderer(boolean usesSoftwareRenderer) {
        this.set(Keys.UseSoftwareRenderer(), NSNumber.valueOf(usesSoftwareRenderer));
        return this;
    }

    public boolean requestsLowPriority() {
        if (this.has(Keys.PriorityRequestLow())) {
            NSNumber val = (NSNumber)this.get(Keys.PriorityRequestLow());
            return val.booleanValue();
        }
        return false;
    }

    public CIContextOptions setRequestsLowPriority(boolean requestsLowPriority) {
        this.set(Keys.PriorityRequestLow(), NSNumber.valueOf(requestsLowPriority));
        return this;
    }

    @Library(value="CoreImage")
    public static class Keys {
        @GlobalValue(symbol="kCIContextOutputColorSpace", optional=true)
        public static native NSString OutputColorSpace();

        @GlobalValue(symbol="kCIContextWorkingColorSpace", optional=true)
        public static native NSString WorkingColorSpace();

        @GlobalValue(symbol="kCIContextWorkingFormat", optional=true)
        public static native NSString WorkingFormat();

        @GlobalValue(symbol="kCIContextHighQualityDownsample", optional=true)
        public static native NSString HighQualityDownsample();

        @GlobalValue(symbol="kCIContextOutputPremultiplied", optional=true)
        public static native NSString OutputPremultiplied();

        @GlobalValue(symbol="kCIContextCacheIntermediates", optional=true)
        public static native NSString CacheIntermediates();

        @GlobalValue(symbol="kCIContextUseSoftwareRenderer", optional=true)
        public static native NSString UseSoftwareRenderer();

        @GlobalValue(symbol="kCIContextPriorityRequestLow", optional=true)
        public static native NSString PriorityRequestLow();

        @GlobalValue(symbol="kCIContextAllowLowPower", optional=true)
        public static native NSString AllowLowPower();

        @GlobalValue(symbol="kCIContextName", optional=true)
        public static native NSString Name();

        @GlobalValue(symbol="kCIContextMemoryLimit", optional=true)
        public static native NSString MemoryLimit();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CIContextOptions> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CIContextOptions> list = new ArrayList<CIContextOptions>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new CIContextOptions((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CIContextOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (CIContextOptions i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CIContextOptions toObject(Class<CIContextOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CIContextOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CIContextOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

