/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreml;

import org.robovm.apple.coreml.MLBatchProvider;
import org.robovm.apple.coreml.MLFeatureProvider;
import org.robovm.apple.coreml.MLModelAsset;
import org.robovm.apple.coreml.MLModelConfiguration;
import org.robovm.apple.coreml.MLModelDescription;
import org.robovm.apple.coreml.MLParameterKey;
import org.robovm.apple.coreml.MLPredictionOptions;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreML")
@NativeClass
public class MLModel
extends NSObject {
    public MLModel() {
    }

    protected MLModel(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MLModel(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public MLModel(NSURL url) throws NSErrorException {
        this(url, new NSError.NSErrorPtr());
    }

    private MLModel(NSURL url, NSError.NSErrorPtr ptr) throws NSErrorException {
        super(null, MLModel.create(url, ptr));
        MLModel.retain(this.getHandle());
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
    }

    public MLModel(NSURL url, MLModelConfiguration configuration) throws NSErrorException {
        this(url, configuration, new NSError.NSErrorPtr());
    }

    private MLModel(NSURL url, MLModelConfiguration configuration, NSError.NSErrorPtr ptr) throws NSErrorException {
        super(null, MLModel.create(url, configuration, ptr));
        MLModel.retain(this.getHandle());
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
    }

    @Property(selector="modelDescription")
    public native MLModelDescription getModelDescription();

    @Property(selector="configuration")
    public native MLModelConfiguration getConfiguration();

    @Property(selector="availableComputeDevices")
    public static native NSArray<?> getAvailableComputeDevices();

    public MLFeatureProvider predictionFromFeatures(MLFeatureProvider input) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MLFeatureProvider result = this.predictionFromFeatures(input, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="predictionFromFeatures:error:")
    private native MLFeatureProvider predictionFromFeatures(MLFeatureProvider var1, NSError.NSErrorPtr var2);

    @Method(selector="predictionFromFeatures:options:error:")
    public native MLFeatureProvider predictionFromFeatures(MLFeatureProvider var1, MLPredictionOptions var2, NSError.NSErrorPtr var3);

    @Method(selector="predictionFromFeatures:completionHandler:")
    public native void getPredictionFromFeatures(MLFeatureProvider var1, @Block VoidBlock2<MLFeatureProvider, NSError> var2);

    @Method(selector="predictionFromFeatures:options:completionHandler:")
    public native void getPredictionFromFeatures(MLFeatureProvider var1, MLPredictionOptions var2, @Block VoidBlock2<MLFeatureProvider, NSError> var3);

    public MLBatchProvider getPredictionsFromBatch(MLBatchProvider inputBatch) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MLBatchProvider result = this.getPredictionsFromBatch(inputBatch, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="predictionsFromBatch:error:")
    private native MLBatchProvider getPredictionsFromBatch(MLBatchProvider var1, NSError.NSErrorPtr var2);

    public MLBatchProvider getPredictionsFromBatch(MLBatchProvider inputBatch, MLPredictionOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MLBatchProvider result = this.getPredictionsFromBatch(inputBatch, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="predictionsFromBatch:options:error:")
    private native MLBatchProvider getPredictionsFromBatch(MLBatchProvider var1, MLPredictionOptions var2, NSError.NSErrorPtr var3);

    public NSObject getParameterValue(MLParameterKey key) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSObject result = this.getParameterValue(key, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="parameterValueForKey:error:")
    private native NSObject getParameterValue(MLParameterKey var1, NSError.NSErrorPtr var2);

    @Method(selector="modelWithContentsOfURL:error:")
    @Pointer
    protected static native long create(NSURL var0, NSError.NSErrorPtr var1);

    @Method(selector="modelWithContentsOfURL:configuration:error:")
    @Pointer
    protected static native long create(NSURL var0, MLModelConfiguration var1, NSError.NSErrorPtr var2);

    @Method(selector="loadContentsOfURL:configuration:completionHandler:")
    public static native void load(NSURL var0, MLModelConfiguration var1, @Block VoidBlock2<MLModel, NSError> var2);

    @Method(selector="loadModelAsset:configuration:completionHandler:")
    public static native void loadModelAsset(MLModelAsset var0, MLModelConfiguration var1, @Block VoidBlock2<MLModel, NSError> var2);

    @Deprecated
    public static NSURL compileModel(NSURL modelURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSURL result = MLModel.compileModel(modelURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Deprecated
    @Method(selector="compileModelAtURL:error:")
    private static native NSURL compileModel(NSURL var0, NSError.NSErrorPtr var1);

    @Method(selector="compileModelAtURL:completionHandler:")
    public static native void compileModelAtURL(NSURL var0, @Block VoidBlock2<NSURL, NSError> var1);

    static {
        ObjCRuntime.bind(MLModel.class);
    }

    public static class MLModelPtr
    extends Ptr<MLModel, MLModelPtr> {
    }
}

