/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreservices;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFRunLoopSource;
import org.robovm.apple.corefoundation.CFStreamClientContext;
import org.robovm.apple.coreservices.CFProxy;
import org.robovm.apple.coreservices.CFSystemProxySettings;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;

@Library(value="CFNetwork")
public class CFProxySupport
extends CocoaUtility {
    private static final AtomicLong refconId = new AtomicLong();
    private long localRefconId;
    private static final LongMap<AutoConfigurationClientCallback> callbacks = new LongMap();
    private static final Method cbInvoke;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbInvoke(@Pointer long refcon, CFArray proxyList0, NSError error) {
        AutoConfigurationClientCallback callback = null;
        LongMap<AutoConfigurationClientCallback> longMap = callbacks;
        synchronized (longMap) {
            callback = (AutoConfigurationClientCallback)callbacks.get(refcon);
        }
        ArrayList<CFProxy> proxyList = new ArrayList<CFProxy>();
        int i = 0;
        while ((long)i < proxyList0.size()) {
            proxyList.add(new CFProxy(proxyList0.get(i, CFDictionary.class)));
            ++i;
        }
        callback.invoke(proxyList, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFRunLoopSource executeProxyAutoConfigurationScript(String proxyAutoConfigurationScript, NSURL targetURL, AutoConfigurationClientCallback callback) {
        long refconId = CFProxySupport.refconId.getAndIncrement();
        CFStreamClientContext context = new CFStreamClientContext();
        context.setInfo(refconId);
        CFRunLoopSource source = CFProxySupport.executeProxyAutoConfigurationScript(proxyAutoConfigurationScript, targetURL, new FunctionPtr(cbInvoke), context);
        if (source != null) {
            LongMap<AutoConfigurationClientCallback> longMap = callbacks;
            synchronized (longMap) {
                callbacks.put(refconId, (Object)callback);
            }
            return source;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFRunLoopSource executeProxyAutoConfigurationURL(NSURL proxyAutoConfigURL, NSURL targetURL, AutoConfigurationClientCallback callback) {
        long refconId = CFProxySupport.refconId.getAndIncrement();
        CFStreamClientContext context = new CFStreamClientContext();
        context.setInfo(refconId);
        CFRunLoopSource source = CFProxySupport.executeProxyAutoConfigurationURL(proxyAutoConfigURL, targetURL, new FunctionPtr(cbInvoke), context);
        if (source != null) {
            LongMap<AutoConfigurationClientCallback> longMap = callbacks;
            synchronized (longMap) {
                callbacks.put(refconId, (Object)callback);
            }
            return source;
        }
        return null;
    }

    @Bridge(symbol="CFNetworkCopySystemProxySettings", optional=true)
    public static native CFSystemProxySettings getSystemProxySettings();

    public static List<CFProxy> getProxies(String proxyAutoConfigurationScript, NSURL targetURL) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        List<CFProxy> result = CFProxySupport.getProxies(proxyAutoConfigurationScript, targetURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFNetworkCopyProxiesForAutoConfigurationScript", optional=true)
    @Marshaler(value=CFProxy.AsListMarshaler.class)
    private static native List<CFProxy> getProxies(String var0, NSURL var1, NSError.NSErrorPtr var2);

    @Bridge(symbol="CFNetworkExecuteProxyAutoConfigurationScript", optional=true)
    private static native CFRunLoopSource executeProxyAutoConfigurationScript(String var0, NSURL var1, FunctionPtr var2, CFStreamClientContext var3);

    @Bridge(symbol="CFNetworkExecuteProxyAutoConfigurationURL", optional=true)
    private static native CFRunLoopSource executeProxyAutoConfigurationURL(NSURL var0, NSURL var1, FunctionPtr var2, CFStreamClientContext var3);

    static {
        try {
            cbInvoke = CFProxySupport.class.getDeclaredMethod("cbInvoke", Long.TYPE, CFArray.class, NSError.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CFProxySupport.class);
    }

    public static interface AutoConfigurationClientCallback {
        public void invoke(List<CFProxy> var1, NSError var2);
    }
}

