/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.io.File;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSFastEnumeration;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSPropertyList;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSDictionary<K extends NSObject, V extends NSObject>
extends NSObject
implements NSPropertyList,
NSFastEnumeration,
Map<K, V> {
    public NSDictionary() {
    }

    protected NSDictionary(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSDictionary(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSDictionary(K k, V v) {
        super(null);
        this.initObject(this.init(new NSArray(new NSObject[]{v}), new NSArray(new NSObject[]{k})));
    }

    public NSDictionary(K k1, V v1, K k2, V v2) {
        super(null);
        this.initObject(this.init(new NSArray(new NSObject[]{v1, v2}), new NSArray(new NSObject[]{k1, k2})));
    }

    public NSDictionary(K k1, V v1, K k2, V v2, K k3, V v3) {
        super(null);
        this.initObject(this.init(new NSArray(new NSObject[]{v1, v2, v3}), new NSArray(new NSObject[]{k1, k2, k3})));
    }

    public NSDictionary(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        super(null);
        this.initObject(this.init(new NSArray(new NSObject[]{v1, v2, v3, v4}), new NSArray(new NSObject[]{k1, k2, k3, k4})));
    }

    public NSDictionary(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        super(null);
        this.initObject(this.init(new NSArray(new NSObject[]{v1, v2, v3, v4, v5}), new NSArray(new NSObject[]{k1, k2, k3, k4, k5})));
    }

    public NSDictionary(Map<K, V> m) {
        super(null);
        if (m instanceof NSDictionary) {
            this.initObject(this.init((NSDictionary)m));
        } else {
            Set<K> keys = m.keySet();
            ArrayList<NSObject> objects = new ArrayList<NSObject>(keys.size());
            for (NSObject key : keys) {
                NSObject value = (NSObject)m.get(key);
                NSDictionary.checkNull(key, value);
                objects.add(value);
            }
            this.initObject(this.init(new NSArray(objects), new NSArray<K>(keys)));
        }
    }

    @Property(selector="count")
    @MachineSizedUInt
    protected native long getCount();

    @Property(selector="allKeys")
    protected native NSArray<K> getAllKeys();

    @Property(selector="allValues")
    protected native NSArray<V> getAllValues();

    @Property(selector="descriptionInStringsFileFormat")
    public native String toFileFormatString();

    protected static void checkNull(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException("null keys or values are not allowed in NSDictionary. Use NSNull instead.");
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (!(value instanceof NSObject)) {
            return false;
        }
        NSArray<V> values = this.getAllValues();
        int count = (int)values.getCount();
        for (int i = 0; i < count; ++i) {
            V o = values.getObjectAt(i);
            if (!((NSObject)o).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(this);
    }

    public V get(String key) {
        return (V)this.getObjectForKey(key);
    }

    @Override
    public V get(Object key) {
        return (V)this.getObjectForKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.getCount() == 0L;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet(this);
    }

    @Override
    public int size() {
        return (int)this.getCount();
    }

    @Override
    public Collection<V> values() {
        return this.getAllValues();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public V put(String key, V value) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NSDictionary && this.equalsTo((NSDictionary)obj);
    }

    public static NSDictionary<?, ?> read(File file) {
        return NSDictionary.read(file.getAbsolutePath());
    }

    public boolean write(File file, boolean useAuxiliaryFile) {
        return this.writeFile(file.getAbsolutePath(), useAuxiliaryFile);
    }

    public Map<String, V> asStringMap() {
        HashMap<String, NSObject> map = new HashMap<String, NSObject>();
        if (this.size() == 0) {
            return map;
        }
        if (!(this.getAllKeys().get(0) instanceof NSString)) {
            throw new UnsupportedOperationException("keys must be of type NSString");
        }
        for (Map.Entry<K, V> e : this.entrySet()) {
            map.put(((NSObject)e.getKey()).toString(), (NSObject)e.getValue());
        }
        return map;
    }

    public static <V extends NSObject> NSDictionary<NSString, V> fromStringMap(Map<String, V> map) {
        HashMap<NSString, NSObject> dictionary = new HashMap<NSString, NSObject>();
        for (Map.Entry<String, V> entry : map.entrySet()) {
            dictionary.put(new NSString(entry.getKey()), (NSObject)entry.getValue());
        }
        return new NSDictionary(dictionary);
    }

    public boolean getBoolean(Object key) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            throw new NullPointerException("Value not found for key: " + key);
        }
        return val.booleanValue();
    }

    public byte getByte(Object key) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            throw new NullPointerException("Value not found for key: " + key);
        }
        return val.byteValue();
    }

    public short getShort(Object key) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            throw new NullPointerException("Value not found for key: " + key);
        }
        return val.shortValue();
    }

    public char getChar(Object key) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            throw new NullPointerException("Value not found for key: " + key);
        }
        return val.charValue();
    }

    public int getInt(Object key) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            throw new NullPointerException("Value not found for key: " + key);
        }
        return val.intValue();
    }

    public long getLong(Object key) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            throw new NullPointerException("Value not found for key: " + key);
        }
        return val.longValue();
    }

    public float getFloat(Object key) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            throw new NullPointerException("Value not found for key: " + key);
        }
        return val.floatValue();
    }

    public double getDouble(Object key) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            throw new NullPointerException("Value not found for key: " + key);
        }
        return val.doubleValue();
    }

    public String getString(Object key) {
        NSString val = (NSString)this.getObjectForKey(key);
        if (val == null) {
            throw new NullPointerException("Value not found for key: " + key);
        }
        return val.toString();
    }

    public boolean getBoolean(Object key, boolean defaultValue) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            return defaultValue;
        }
        return val.booleanValue();
    }

    public byte getByte(Object key, byte defaultValue) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            return defaultValue;
        }
        return val.byteValue();
    }

    public short getShort(Object key, short defaultValue) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            return defaultValue;
        }
        return val.shortValue();
    }

    public char getChar(Object key, char defaultValue) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            return defaultValue;
        }
        return val.charValue();
    }

    public int getInt(Object key, int defaultValue) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            return defaultValue;
        }
        return val.intValue();
    }

    public long getLong(Object key, long defaultValue) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            return defaultValue;
        }
        return val.longValue();
    }

    public float getFloat(Object key, float defaultValue) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            return defaultValue;
        }
        return val.floatValue();
    }

    public double getDouble(Object key, double defaultValue) {
        NSNumber val = (NSNumber)this.getObjectForKey(key);
        if (val == null) {
            return defaultValue;
        }
        return val.doubleValue();
    }

    public String getString(Object key, String defaultValue) {
        NSString val = (NSString)this.getObjectForKey(key);
        if (val == null) {
            return defaultValue;
        }
        return val.toString();
    }

    @Override
    public void put(Object key, boolean value) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public void put(Object key, byte value) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public void put(Object key, short value) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public void put(Object key, char value) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public void put(Object key, int value) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public void put(Object key, long value) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public void put(Object key, float value) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public void put(Object key, double value) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public void put(Object key, Number value) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public void put(Object key, String value) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    @Override
    public void put(Object key, NSObject value) {
        throw new UnsupportedOperationException("NSDictionary is immutable");
    }

    protected NSObject getObjectForKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (key instanceof NSObject) {
            return this.objectForKey$(((NSObject)key).getHandle());
        }
        String strKey = String.valueOf(key);
        return this.objectForKey$(NSString.create(NSString.getChars(strKey), strKey.length()));
    }

    @Method(selector="objectForKey:")
    private native NSObject objectForKey$(@Pointer long var1);

    @Method(selector="objectForKey:")
    protected native V getObject(K var1);

    @Method(selector="isEqualToDictionary:")
    protected native boolean equalsTo(NSDictionary<K, V> var1);

    @Deprecated
    @Method(selector="writeToFile:atomically:")
    protected native boolean writeFile(String var1, boolean var2);

    @Deprecated
    @Method(selector="writeToURL:atomically:")
    public native boolean write(NSURL var1, boolean var2);

    @Deprecated
    @Method(selector="dictionaryWithContentsOfFile:")
    protected static native NSDictionary<?, ?> read(String var0);

    @Deprecated
    @Method(selector="dictionaryWithContentsOfURL:")
    public static native NSDictionary<?, ?> read(NSURL var0);

    @Method(selector="initWithDictionary:")
    @Pointer
    protected native long init(NSDictionary<K, V> var1);

    @Method(selector="initWithObjects:forKeys:")
    @Pointer
    protected native long init(NSArray<V> var1, NSArray<?> var2);

    static {
        ObjCRuntime.bind(NSDictionary.class);
    }

    static class EntrySet<K extends NSObject, V extends NSObject>
    extends AbstractSet<Map.Entry<K, V>> {
        private final NSDictionary<K, V> map;

        EntrySet(NSDictionary<K, V> map) {
            this.map = map;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator<K> keysIt = this.map.keySet().iterator();
            return new Iterator<Map.Entry<K, V>>(){
                private Map.Entry<K, V> entry = null;
                final /* synthetic */ EntrySet this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean hasNext() {
                    return keysIt.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    NSObject key = (NSObject)keysIt.next();
                    Object value = this.this$0.map.get(key);
                    if (value == null) {
                        throw new ConcurrentModificationException();
                    }
                    this.entry = new Entry<NSObject, Object>(this.this$0.map, key, value);
                    return this.entry;
                }

                @Override
                public void remove() {
                    if (this.entry == null) {
                        throw new IllegalStateException();
                    }
                    Object value = this.this$0.map.get(this.entry.getKey());
                    if (this.entry.getValue() != value) {
                        throw new ConcurrentModificationException();
                    }
                    keysIt.remove();
                    this.entry = null;
                }
            };
        }

        @Override
        public int size() {
            return (int)this.map.getCount();
        }
    }

    static class KeySet<K extends NSObject>
    extends AbstractSet<K> {
        private final NSDictionary<K, ? extends NSObject> map;

        KeySet(NSDictionary<K, ? extends NSObject> map) {
            this.map = map;
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator<K> it = this.map.getAllKeys().iterator();
            return new Iterator<K>(){
                private K last = null;
                final /* synthetic */ KeySet this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public K next() {
                    this.last = (NSObject)it.next();
                    return this.last;
                }

                @Override
                public void remove() {
                    if (this.last == null) {
                        throw new IllegalStateException();
                    }
                    if (this.this$0.map.get(this.last) == null) {
                        throw new ConcurrentModificationException();
                    }
                    this.this$0.map.remove(this.last);
                    this.last = null;
                }
            };
        }

        @Override
        public int size() {
            return (int)this.map.getCount();
        }
    }

    static class Entry<K extends NSObject, V extends NSObject>
    implements Map.Entry<K, V> {
        private final NSDictionary<K, V> map;
        private final K key;
        private final V value;

        Entry(NSDictionary<K, V> map, K key, V value) {
            this.map = map;
            this.key = key;
            this.value = value;
        }

        @Override
        public V setValue(V v) {
            if (this.value != this.map.get(this.key)) {
                throw new ConcurrentModificationException();
            }
            return this.map.put(this.key, v);
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return (this.key == null ? entry.getKey() == null : ((NSObject)this.key).equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : ((NSObject)this.value).equals(entry.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((NSObject)this.key).hashCode() ^ ((NSObject)this.value).hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    public static class AsStringNumberMapMarshaler {
        @MarshalsPointer
        public static Map<String, Number> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            HashMap<String, Number> map = new HashMap<String, Number>();
            for (Map.Entry e : o.entrySet()) {
                map.put(((NSString)e.getKey()).toString(), ((NSNumber)e.getValue()).doubleValue());
            }
            return map;
        }

        @MarshalsPointer
        public static long toNative(Map<String, Number> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableDictionary<NSString, NSNumber> o = new NSMutableDictionary<NSString, NSNumber>();
            for (Map.Entry<String, Number> e : l.entrySet()) {
                Number value = e.getValue();
                NSNumber number = null;
                if (value instanceof Byte) {
                    number = NSNumber.valueOf((Byte)value);
                } else if (value instanceof Short) {
                    number = NSNumber.valueOf((Short)value);
                } else if (value instanceof Integer) {
                    number = NSNumber.valueOf((Integer)value);
                } else if (value instanceof Long) {
                    number = NSNumber.valueOf((Long)value);
                } else if (value instanceof Float) {
                    number = NSNumber.valueOf(((Float)value).floatValue());
                } else if (value instanceof Double) {
                    number = NSNumber.valueOf((Double)value);
                } else {
                    throw new UnsupportedOperationException("Only values of type Number (byte, short, int, long, float, double) are allowed!");
                }
                ((NSDictionary)o).put(new NSString(e.getKey()), number);
            }
            return NSObject.Marshaler.toNative(o, flags);
        }
    }

    public static class AsStringStringMapMarshaler {
        @MarshalsPointer
        public static Map<String, String> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry e : o.entrySet()) {
                map.put(e.getKey().toString(), e.getValue().toString());
            }
            return map;
        }

        @MarshalsPointer
        public static long toNative(Map<String, String> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableDictionary<NSString, NSString> o = new NSMutableDictionary<NSString, NSString>();
            for (Map.Entry<String, String> e : l.entrySet()) {
                ((NSDictionary)o).put(new NSString(e.getKey()), new NSString(e.getValue()));
            }
            return NSObject.Marshaler.toNative(o, flags);
        }
    }

    public static class AsStringMapMarshaler {
        @MarshalsPointer
        public static Map<String, ? extends NSObject> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            return o.asStringMap();
        }

        @MarshalsPointer
        public static long toNative(Map<String, ? extends NSObject> l, long flags) {
            if (l == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(NSDictionary.fromStringMap(l), flags);
        }
    }

    public static class NSDictionaryPtr<K extends NSObject, V extends NSObject>
    extends Ptr<NSDictionary<K, V>, NSDictionaryPtr<K, V>> {
    }
}

