/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Collection;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOrderedSet;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSMutableOrderedSet<T extends NSObject>
extends NSOrderedSet<T> {
    public NSMutableOrderedSet() {
    }

    protected NSMutableOrderedSet(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSMutableOrderedSet(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithCapacity:")
    public NSMutableOrderedSet(@MachineSizedUInt long numItems) {
        super((NSObject.SkipInit)null);
        this.initObject(this.init(numItems));
    }

    public NSMutableOrderedSet(Collection<T> c) {
        super(c);
    }

    public NSMutableOrderedSet(T ... objects) {
        super(objects);
    }

    @Override
    protected AbstractSet<T> createSetAdapter() {
        return new SetAdapter(this);
    }

    @Override
    protected AbstractList<T> createListAdapter() {
        return new ListAdapter(this);
    }

    @Method(selector="insertObject:atIndex:")
    protected native void insertObject(T var1, @MachineSizedUInt long var2);

    @Method(selector="removeObjectAtIndex:")
    protected native void removeObject(@MachineSizedUInt long var1);

    @Method(selector="replaceObjectAtIndex:withObject:")
    protected native void replaceObject(@MachineSizedUInt long var1, T var3);

    @Method(selector="initWithCapacity:")
    @Pointer
    protected native long init(@MachineSizedUInt long var1);

    @Method(selector="removeAllObjects")
    protected native void removeAllObjects();

    @Method(selector="removeObject:")
    protected native void removeObject(T var1);

    static {
        ObjCRuntime.bind(NSMutableOrderedSet.class);
    }

    static class SetAdapter<U extends NSObject>
    extends NSOrderedSet.SetAdapter<U> {
        SetAdapter(NSOrderedSet<U> set) {
            super(set);
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                ((NSMutableOrderedSet)this.set).removeObject((NSObject)o);
                return true;
            }
            return false;
        }
    }

    static class ListAdapter<U extends NSObject>
    extends NSOrderedSet.ListAdapter<U> {
        ListAdapter(NSOrderedSet<U> array) {
            super(array);
        }

        @Override
        public void clear() {
            ((NSMutableOrderedSet)this.set).removeAllObjects();
        }

        @Override
        public U set(int index, U element) {
            NSOrderedSet.checkNull(element);
            this.checkIndex(index);
            Object old = this.set.getObjectAt(index);
            ((NSMutableOrderedSet)this.set).replaceObject(index, element);
            return (U)old;
        }

        @Override
        public void add(int index, U element) {
            NSOrderedSet.checkNull(element);
            if ((long)index != this.set.getCount() + 1L) {
                this.checkIndex(index);
            }
            ((NSMutableOrderedSet)this.set).insertObject(element, index);
        }

        @Override
        public U remove(int index) {
            this.checkIndex(index);
            Object old = this.set.getObjectAt(index);
            ((NSMutableOrderedSet)this.set).removeObject(index);
            return (U)old;
        }
    }

    public static class NSMutableOrderedSetPtr<T extends NSObject>
    extends Ptr<NSMutableOrderedSet<T>, NSMutableOrderedSetPtr<T>> {
    }
}

