/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.imageio;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="ImageIO")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CGImageSourceOptions
extends CFDictionaryWrapper {
    CGImageSourceOptions(CFDictionary data) {
        super(data);
    }

    public CGImageSourceOptions() {
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public CGImageSourceOptions set(CFString key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public String getTypeIdentifierHint() {
        if (this.has(Keys.TypeIdentifierHint())) {
            CFString val = this.get(Keys.TypeIdentifierHint(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CGImageSourceOptions setTypeIdentifierHint(String typeIdentifierHint) {
        this.set(Keys.TypeIdentifierHint(), new CFString(typeIdentifierHint));
        return this;
    }

    public boolean shouldCache() {
        if (this.has(Keys.ShouldCache())) {
            CFBoolean val = this.get(Keys.ShouldCache(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageSourceOptions setShouldCache(boolean shouldCache) {
        this.set(Keys.ShouldCache(), CFBoolean.valueOf(shouldCache));
        return this;
    }

    public boolean shouldCacheImmediately() {
        if (this.has(Keys.ShouldCacheImmediately())) {
            CFBoolean val = this.get(Keys.ShouldCacheImmediately(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageSourceOptions setShouldCacheImmediately(boolean shouldCacheImmediately) {
        this.set(Keys.ShouldCacheImmediately(), CFBoolean.valueOf(shouldCacheImmediately));
        return this;
    }

    public boolean shouldAllowFloat() {
        if (this.has(Keys.ShouldAllowFloat())) {
            CFBoolean val = this.get(Keys.ShouldAllowFloat(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageSourceOptions setShouldAllowFloat(boolean shouldAllowFloat) {
        this.set(Keys.ShouldAllowFloat(), CFBoolean.valueOf(shouldAllowFloat));
        return this;
    }

    public boolean shouldCreateThumbnailFromImageIfAbsent() {
        if (this.has(Keys.CreateThumbnailFromImageIfAbsent())) {
            CFBoolean val = this.get(Keys.CreateThumbnailFromImageIfAbsent(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageSourceOptions setShouldCreateThumbnailFromImageIfAbsent(boolean shouldCreateThumbnailFromImageIfAbsent) {
        this.set(Keys.CreateThumbnailFromImageIfAbsent(), CFBoolean.valueOf(shouldCreateThumbnailFromImageIfAbsent));
        return this;
    }

    public long getThumbnailMaxPixelSize() {
        if (this.has(Keys.ThumbnailMaxPixelSize())) {
            CFNumber val = this.get(Keys.ThumbnailMaxPixelSize(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CGImageSourceOptions setThumbnailMaxPixelSize(long thumbnailMaxPixelSize) {
        this.set(Keys.ThumbnailMaxPixelSize(), CFNumber.valueOf(thumbnailMaxPixelSize));
        return this;
    }

    public boolean shouldCreateThumbnailWithTransform() {
        if (this.has(Keys.CreateThumbnailWithTransform())) {
            CFBoolean val = this.get(Keys.CreateThumbnailWithTransform(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CGImageSourceOptions setShouldCreateThumbnailWithTransform(boolean shouldCreateThumbnailWithTransform) {
        this.set(Keys.CreateThumbnailWithTransform(), CFBoolean.valueOf(shouldCreateThumbnailWithTransform));
        return this;
    }

    public int getSubsampleFactor() {
        if (this.has(Keys.SubsampleFactor())) {
            CFNumber val = this.get(Keys.SubsampleFactor(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public CGImageSourceOptions setSubsampleFactor(int subsampleFactor) {
        this.set(Keys.SubsampleFactor(), CFNumber.valueOf(subsampleFactor));
        return this;
    }

    @Library(value="ImageIO")
    public static class Keys {
        @GlobalValue(symbol="kCGImageSourceTypeIdentifierHint", optional=true)
        public static native CFString TypeIdentifierHint();

        @GlobalValue(symbol="kCGImageSourceShouldCache", optional=true)
        public static native CFString ShouldCache();

        @GlobalValue(symbol="kCGImageSourceShouldCacheImmediately", optional=true)
        public static native CFString ShouldCacheImmediately();

        @GlobalValue(symbol="kCGImageSourceShouldAllowFloat", optional=true)
        public static native CFString ShouldAllowFloat();

        @GlobalValue(symbol="kCGImageSourceCreateThumbnailFromImageIfAbsent", optional=true)
        public static native CFString CreateThumbnailFromImageIfAbsent();

        @GlobalValue(symbol="kCGImageSourceCreateThumbnailFromImageAlways", optional=true)
        public static native CFString CreateThumbnailFromImageAlways();

        @GlobalValue(symbol="kCGImageSourceThumbnailMaxPixelSize", optional=true)
        public static native CFString ThumbnailMaxPixelSize();

        @GlobalValue(symbol="kCGImageSourceCreateThumbnailWithTransform", optional=true)
        public static native CFString CreateThumbnailWithTransform();

        @GlobalValue(symbol="kCGImageSourceSubsampleFactor", optional=true)
        public static native CFString SubsampleFactor();

        @GlobalValue(symbol="kCGImageSourceDecodeRequest", optional=true)
        public static native CFString DecodeRequest();

        @GlobalValue(symbol="kCGImageSourceDecodeToHDR", optional=true)
        public static native CFString DecodeToHDR();

        @GlobalValue(symbol="kCGImageSourceDecodeToSDR", optional=true)
        public static native CFString DecodeToSDR();

        @GlobalValue(symbol="kCGImageSourceDecodeRequestOptions", optional=true)
        public static native CFString DecodeRequestOptions();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CGImageSourceOptions> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CGImageSourceOptions> list = new ArrayList<CGImageSourceOptions>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CGImageSourceOptions(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CGImageSourceOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CGImageSourceOptions i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CGImageSourceOptions toObject(Class<CGImageSourceOptions> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CGImageSourceOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CGImageSourceOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

