/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.matter;

import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDateInterval;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.matter.MTRKeypair;
import org.robovm.apple.security.SecKey;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Matter")
@NativeClass
public class MTRCertificates
extends NSObject {
    protected MTRCertificates() {
    }

    protected MTRCertificates(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MTRCertificates(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public static NSData createRootCertificate(MTRKeypair keypair, NSNumber issuerID, NSNumber fabricID, NSDateInterval validityPeriod) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = MTRCertificates.createRootCertificate(keypair, issuerID, fabricID, validityPeriod, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="createRootCertificate:issuerID:fabricID:validityPeriod:error:")
    private static native NSData createRootCertificate(MTRKeypair var0, NSNumber var1, NSNumber var2, NSDateInterval var3, NSError.NSErrorPtr var4);

    public static NSData createRootCertificate(MTRKeypair keypair, NSNumber issuerID, NSNumber fabricID) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = MTRCertificates.createRootCertificate(keypair, issuerID, fabricID, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="createRootCertificate:issuerID:fabricID:error:")
    private static native NSData createRootCertificate(MTRKeypair var0, NSNumber var1, NSNumber var2, NSError.NSErrorPtr var3);

    public static NSData createIntermediateCertificate(MTRKeypair rootKeypair, NSData rootCertificate, SecKey intermediatePublicKey, NSNumber issuerID, NSNumber fabricID, NSDateInterval validityPeriod) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = MTRCertificates.createIntermediateCertificate(rootKeypair, rootCertificate, intermediatePublicKey, issuerID, fabricID, validityPeriod, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="createIntermediateCertificate:rootCertificate:intermediatePublicKey:issuerID:fabricID:validityPeriod:error:")
    private static native NSData createIntermediateCertificate(MTRKeypair var0, NSData var1, SecKey var2, NSNumber var3, NSNumber var4, NSDateInterval var5, NSError.NSErrorPtr var6);

    public static NSData createIntermediateCertificate(MTRKeypair rootKeypair, NSData rootCertificate, SecKey intermediatePublicKey, NSNumber issuerID, NSNumber fabricID) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = MTRCertificates.createIntermediateCertificate(rootKeypair, rootCertificate, intermediatePublicKey, issuerID, fabricID, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="createIntermediateCertificate:rootCertificate:intermediatePublicKey:issuerID:fabricID:error:")
    private static native NSData createIntermediateCertificate(MTRKeypair var0, NSData var1, SecKey var2, NSNumber var3, NSNumber var4, NSError.NSErrorPtr var5);

    public static NSData createOperationalCertificate(MTRKeypair signingKeypair, NSData signingCertificate, SecKey operationalPublicKey, NSNumber fabricID, NSNumber nodeID, NSSet<NSNumber> caseAuthenticatedTags, NSDateInterval validityPeriod) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = MTRCertificates.createOperationalCertificate(signingKeypair, signingCertificate, operationalPublicKey, fabricID, nodeID, caseAuthenticatedTags, validityPeriod, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="createOperationalCertificate:signingCertificate:operationalPublicKey:fabricID:nodeID:caseAuthenticatedTags:validityPeriod:error:")
    private static native NSData createOperationalCertificate(MTRKeypair var0, NSData var1, SecKey var2, NSNumber var3, NSNumber var4, NSSet<NSNumber> var5, NSDateInterval var6, NSError.NSErrorPtr var7);

    public static NSData createOperationalCertificate(MTRKeypair signingKeypair, NSData signingCertificate, SecKey operationalPublicKey, NSNumber fabricID, NSNumber nodeID, NSSet<NSNumber> caseAuthenticatedTags) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = MTRCertificates.createOperationalCertificate(signingKeypair, signingCertificate, operationalPublicKey, fabricID, nodeID, caseAuthenticatedTags, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="createOperationalCertificate:signingCertificate:operationalPublicKey:fabricID:nodeID:caseAuthenticatedTags:error:")
    private static native NSData createOperationalCertificate(MTRKeypair var0, NSData var1, SecKey var2, NSNumber var3, NSNumber var4, NSSet<NSNumber> var5, NSError.NSErrorPtr var6);

    @Method(selector="keypair:matchesCertificate:")
    public static native boolean keypairMatchesCertificate(MTRKeypair var0, NSData var1);

    @Method(selector="isCertificate:equalTo:")
    public static native boolean isCertificateEquals(NSData var0, NSData var1);

    public static NSData createCertificateSigningRequest(MTRKeypair keypair) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = MTRCertificates.createCertificateSigningRequest(keypair, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="createCertificateSigningRequest:error:")
    private static native NSData createCertificateSigningRequest(MTRKeypair var0, NSError.NSErrorPtr var1);

    @Method(selector="convertX509Certificate:")
    public static native NSData convertX509Certificate(NSData var0);

    @Method(selector="convertMatterCertificate:")
    public static native NSData convertMatterCertificate(NSData var0);

    public static NSData publicKeyFromCSR(NSData csr) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = MTRCertificates.publicKeyFromCSR(csr, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="publicKeyFromCSR:error:")
    private static native NSData publicKeyFromCSR(NSData var0, NSError.NSErrorPtr var1);

    static {
        ObjCRuntime.bind(MTRCertificates.class);
    }

    public static class MTRCertificatesPtr
    extends Ptr<MTRCertificates, MTRCertificatesPtr> {
    }
}

