/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.matter;

import org.robovm.apple.dispatch.DispatchQueue;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSXPCConnection;
import org.robovm.apple.foundation.NSXPCInterface;
import org.robovm.apple.matter.MTRBaseDevice;
import org.robovm.apple.matter.MTRCommissionableBrowserDelegate;
import org.robovm.apple.matter.MTRCommissionableBrowserResult;
import org.robovm.apple.matter.MTRCommissioningParameters;
import org.robovm.apple.matter.MTRDeviceControllerDelegate;
import org.robovm.apple.matter.MTRReadParams;
import org.robovm.apple.matter.MTRSetupPayload;
import org.robovm.apple.matter.MTRSubscribeParams;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.Block0;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="Matter")
@NativeClass
public class MTRDeviceController
extends NSObject {
    protected MTRDeviceController() {
    }

    protected MTRDeviceController(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MTRDeviceController(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="isRunning")
    public native boolean isRunning();

    @Property(selector="controllerNodeID")
    public native NSNumber getControllerNodeID();

    public boolean setupCommissioningSession(MTRSetupPayload payload, NSNumber newNodeID) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setupCommissioningSession(payload, newNodeID, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setupCommissioningSessionWithPayload:newNodeID:error:")
    private native boolean setupCommissioningSession(MTRSetupPayload var1, NSNumber var2, NSError.NSErrorPtr var3);

    public boolean setupCommissioningSession(MTRCommissionableBrowserResult discoveredDevice, MTRSetupPayload payload, NSNumber newNodeID) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setupCommissioningSession(discoveredDevice, payload, newNodeID, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setupCommissioningSessionWithDiscoveredDevice:payload:newNodeID:error:")
    private native boolean setupCommissioningSession(MTRCommissionableBrowserResult var1, MTRSetupPayload var2, NSNumber var3, NSError.NSErrorPtr var4);

    public boolean commissionNode(NSNumber nodeID, MTRCommissioningParameters commissioningParams) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.commissionNode(nodeID, commissioningParams, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="commissionNodeWithID:commissioningParams:error:")
    private native boolean commissionNode(NSNumber var1, MTRCommissioningParameters var2, NSError.NSErrorPtr var3);

    public boolean continueCommissioning(VoidPtr opaqueDeviceHandle, boolean ignoreAttestationFailure) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.continueCommissioning(opaqueDeviceHandle, ignoreAttestationFailure, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="continueCommissioningDevice:ignoreAttestationFailure:error:")
    private native boolean continueCommissioning(VoidPtr var1, boolean var2, NSError.NSErrorPtr var3);

    public boolean cancelCommissioning(NSNumber nodeID) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.cancelCommissioning(nodeID, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="cancelCommissioningForNodeID:error:")
    private native boolean cancelCommissioning(NSNumber var1, NSError.NSErrorPtr var2);

    public MTRBaseDevice deviceBeingCommissioned(NSNumber nodeID) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTRBaseDevice result = this.deviceBeingCommissioned(nodeID, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="deviceBeingCommissionedWithNodeID:error:")
    private native MTRBaseDevice deviceBeingCommissioned(NSNumber var1, NSError.NSErrorPtr var2);

    @Method(selector="preWarmCommissioningSession")
    public native void preWarmCommissioningSession();

    @Method(selector="setDeviceControllerDelegate:queue:")
    public native void setDeviceControllerDelegate(MTRDeviceControllerDelegate var1, DispatchQueue var2);

    @Method(selector="startBrowseForCommissionables:queue:")
    public native boolean startBrowse(MTRCommissionableBrowserDelegate var1, DispatchQueue var2);

    @Method(selector="stopBrowseForCommissionables")
    public native boolean stopBrowseForCommissionables();

    @Method(selector="attestationChallengeForDeviceID:")
    public native NSData attestationChallengeForDeviceID(NSNumber var1);

    @Method(selector="shutdown")
    public native void shutdown();

    public static NSData computePASEVerifier(NSNumber setupPasscode, NSNumber iterations, NSData salt) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = MTRDeviceController.computePASEVerifier(setupPasscode, iterations, salt, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="computePASEVerifierForSetupPasscode:iterations:salt:error:")
    private static native NSData computePASEVerifier(NSNumber var0, NSNumber var1, NSData var2, NSError.NSErrorPtr var3);

    @Method(selector="sharedControllerWithID:xpcConnectBlock:")
    public static native MTRDeviceController getSharedController(NSObject var0, @Block Block0<NSXPCConnection> var1);

    @Method(selector="encodeXPCResponseValues:")
    public static native NSArray<?> encodeXPCResponseValues(NSArray<?> var0);

    @Method(selector="decodeXPCResponseValues:")
    public static native NSArray<?> decodeXPCResponseValues(NSArray<?> var0);

    @Method(selector="encodeXPCReadParams:")
    public static native NSDictionary<NSString, ?> encodeXPCReadParams(MTRReadParams var0);

    @Method(selector="decodeXPCReadParams:")
    public static native MTRReadParams decodeXPCReadParams(NSDictionary<NSString, ?> var0);

    @Method(selector="encodeXPCSubscribeParams:")
    public static native NSDictionary<NSString, ?> encodeXPCSubscribeParams(MTRSubscribeParams var0);

    @Method(selector="decodeXPCSubscribeParams:")
    public static native MTRSubscribeParams decodeXPCSubscribeParams(NSDictionary<NSString, ?> var0);

    @Method(selector="xpcInterfaceForServerProtocol")
    public static native NSXPCInterface xpcInterfaceForServerProtocol();

    @Method(selector="xpcInterfaceForClientProtocol")
    public static native NSXPCInterface xpcInterfaceForClientProtocol();

    static {
        ObjCRuntime.bind(MTRDeviceController.class);
    }

    public static class MTRDeviceControllerPtr
    extends Ptr<MTRDeviceController, MTRDeviceControllerPtr> {
    }
}

