/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.matter;

import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.ValuedEnum;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Marshaler(value=ValuedEnum.AsMachineSizedSIntMarshaler.class)
@Library(value="Matter")
public enum MTRErrorCode implements NSErrorCode
{
    GeneralError(1L),
    InvalidStringLength(2L),
    InvalidIntegerValue(3L),
    InvalidArgument(4L),
    InvalidMessageLength(5L),
    InvalidState(6L),
    WrongAddressType(7L),
    IntegrityCheckFailed(8L),
    Timeout(9L),
    BufferTooSmall(10L),
    FabricExists(11L),
    UnknownSchema(12L),
    SchemaMismatch(13L),
    TLVDecodeFailed(14L);

    private final long n;

    @GlobalValue(symbol="MTRErrorDomain", optional=true)
    public static native String getClassDomain();

    private MTRErrorCode(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static MTRErrorCode valueOf(long n) {
        for (MTRErrorCode v : MTRErrorCode.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + MTRErrorCode.class.getName());
    }

    static {
        Bro.bind(MTRErrorCode.class);
        Bro.bind(NSErrorWrap.class);
    }

    @StronglyLinked
    public static class NSErrorWrap
    extends NSError {
        protected NSErrorWrap(NSObject.SkipInit skipInit) {
            super(skipInit);
        }

        @Override
        public NSErrorCode getErrorCode() {
            try {
                return MTRErrorCode.valueOf(this.getCode());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static String getClassDomain() {
            return MTRErrorCode.getClassDomain();
        }
    }
}

