/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metal;

import org.robovm.apple.dispatch.DispatchData;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSBundle;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.iosurface.IOSurface;
import org.robovm.apple.metal.MTLAccelerationStructure;
import org.robovm.apple.metal.MTLAccelerationStructureDescriptor;
import org.robovm.apple.metal.MTLAccelerationStructureSizes;
import org.robovm.apple.metal.MTLArchitecture;
import org.robovm.apple.metal.MTLArgumentBuffersTier;
import org.robovm.apple.metal.MTLArgumentDescriptor;
import org.robovm.apple.metal.MTLArgumentEncoder;
import org.robovm.apple.metal.MTLBinaryArchive;
import org.robovm.apple.metal.MTLBinaryArchiveDescriptor;
import org.robovm.apple.metal.MTLBuffer;
import org.robovm.apple.metal.MTLBufferBinding;
import org.robovm.apple.metal.MTLCommandQueue;
import org.robovm.apple.metal.MTLCompileOptions;
import org.robovm.apple.metal.MTLComputePipelineDescriptor;
import org.robovm.apple.metal.MTLComputePipelineReflection;
import org.robovm.apple.metal.MTLComputePipelineState;
import org.robovm.apple.metal.MTLCounterSampleBuffer;
import org.robovm.apple.metal.MTLCounterSampleBufferDescriptor;
import org.robovm.apple.metal.MTLCounterSamplingPoint;
import org.robovm.apple.metal.MTLDepthStencilDescriptor;
import org.robovm.apple.metal.MTLDepthStencilState;
import org.robovm.apple.metal.MTLDynamicLibrary;
import org.robovm.apple.metal.MTLEvent;
import org.robovm.apple.metal.MTLFeatureSet;
import org.robovm.apple.metal.MTLFence;
import org.robovm.apple.metal.MTLFunction;
import org.robovm.apple.metal.MTLGPUFamily;
import org.robovm.apple.metal.MTLHeap;
import org.robovm.apple.metal.MTLHeapDescriptor;
import org.robovm.apple.metal.MTLIOCommandQueue;
import org.robovm.apple.metal.MTLIOCommandQueueDescriptor;
import org.robovm.apple.metal.MTLIOCompressionMethod;
import org.robovm.apple.metal.MTLIOFileHandle;
import org.robovm.apple.metal.MTLIndirectCommandBuffer;
import org.robovm.apple.metal.MTLIndirectCommandBufferDescriptor;
import org.robovm.apple.metal.MTLLibrary;
import org.robovm.apple.metal.MTLMeshRenderPipelineDescriptor;
import org.robovm.apple.metal.MTLPipelineOption;
import org.robovm.apple.metal.MTLPixelFormat;
import org.robovm.apple.metal.MTLRasterizationRateMap;
import org.robovm.apple.metal.MTLRasterizationRateMapDescriptor;
import org.robovm.apple.metal.MTLReadWriteTextureTier;
import org.robovm.apple.metal.MTLRegion;
import org.robovm.apple.metal.MTLRenderPipelineDescriptor;
import org.robovm.apple.metal.MTLRenderPipelineReflection;
import org.robovm.apple.metal.MTLRenderPipelineState;
import org.robovm.apple.metal.MTLResourceOptions;
import org.robovm.apple.metal.MTLSamplePosition;
import org.robovm.apple.metal.MTLSamplerDescriptor;
import org.robovm.apple.metal.MTLSamplerState;
import org.robovm.apple.metal.MTLSharedEvent;
import org.robovm.apple.metal.MTLSharedEventHandle;
import org.robovm.apple.metal.MTLSharedTextureHandle;
import org.robovm.apple.metal.MTLSize;
import org.robovm.apple.metal.MTLSizeAndAlign;
import org.robovm.apple.metal.MTLSparsePageSize;
import org.robovm.apple.metal.MTLSparseTextureRegionAlignmentMode;
import org.robovm.apple.metal.MTLStitchedLibraryDescriptor;
import org.robovm.apple.metal.MTLTexture;
import org.robovm.apple.metal.MTLTextureDescriptor;
import org.robovm.apple.metal.MTLTextureType;
import org.robovm.apple.metal.MTLTileRenderPipelineDescriptor;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeProtocolProxy;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.objc.block.VoidBlock3;
import org.robovm.rt.VM;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Metal")
@NativeProtocolProxy
public final class MTLDevice
extends NSObject
implements NSObjectProtocol {
    @Property(selector="name")
    public native String getName();

    @Property(selector="registryID")
    public native long getRegistryID();

    @Property(selector="architecture")
    public native MTLArchitecture getArchitecture();

    @Property(selector="maxThreadsPerThreadgroup")
    @ByVal
    public native MTLSize getMaxThreadsPerThreadgroup();

    @Property(selector="hasUnifiedMemory")
    public native boolean hasUnifiedMemory();

    @Property(selector="recommendedMaxWorkingSetSize")
    public native long getRecommendedMaxWorkingSetSize();

    @Property(selector="readWriteTextureSupport")
    public native MTLReadWriteTextureTier getReadWriteTextureSupport();

    @Property(selector="argumentBuffersSupport")
    public native MTLArgumentBuffersTier getArgumentBuffersSupport();

    @Property(selector="areRasterOrderGroupsSupported")
    public native boolean isRasterOrderGroupsSupported();

    @Property(selector="supports32BitFloatFiltering")
    public native boolean supports32BitFloatFiltering();

    @Property(selector="supports32BitMSAA")
    public native boolean supports32BitMSAA();

    @Property(selector="supportsQueryTextureLOD")
    public native boolean supportsQueryTextureLOD();

    @Property(selector="supportsBCTextureCompression")
    public native boolean supportsBCTextureCompression();

    @Property(selector="supportsPullModelInterpolation")
    public native boolean supportsPullModelInterpolation();

    @Deprecated
    @Property(selector="areBarycentricCoordsSupported")
    public native boolean isBarycentricCoordsSupported();

    @Property(selector="supportsShaderBarycentricCoordinates")
    public native boolean supportsShaderBarycentricCoordinates();

    @Property(selector="currentAllocatedSize")
    @MachineSizedUInt
    public native long getCurrentAllocatedSize();

    @Property(selector="maxThreadgroupMemoryLength")
    @MachineSizedUInt
    public native long getMaxThreadgroupMemoryLength();

    @Property(selector="maxArgumentBufferSamplerCount")
    @MachineSizedUInt
    public native long getMaxArgumentBufferSamplerCount();

    @Property(selector="areProgrammableSamplePositionsSupported")
    public native boolean isProgrammableSamplePositionsSupported();

    @Property(selector="sparseTileSizeInBytes")
    @MachineSizedUInt
    public native long getSparseTileSizeInBytes();

    @Property(selector="maxBufferLength")
    @MachineSizedUInt
    public native long getMaxBufferLength();

    @Property(selector="counterSets")
    public native NSArray<?> getCounterSets();

    @Property(selector="supportsDynamicLibraries")
    public native boolean supportsDynamicLibraries();

    @Property(selector="supportsRenderDynamicLibraries")
    public native boolean supportsRenderDynamicLibraries();

    @Property(selector="supportsRaytracing")
    public native boolean supportsRaytracing();

    @Property(selector="supportsFunctionPointers")
    public native boolean supportsFunctionPointers();

    @Property(selector="supportsFunctionPointersFromRender")
    public native boolean supportsFunctionPointersFromRender();

    @Property(selector="supportsRaytracingFromRender")
    public native boolean supportsRaytracingFromRender();

    @Property(selector="supportsPrimitiveMotionBlur")
    public native boolean supportsPrimitiveMotionBlur();

    public MTLBuffer newBuffer(byte[] bytes, MTLResourceOptions options) {
        return this.newBuffer(VM.getArrayValuesAddress((Object)bytes), bytes.length, options);
    }

    public MTLBuffer newBuffer(byte[] bytes, MTLResourceOptions options, final VoidBlock1<byte[]> deallocator) {
        return this.newBuffer(VM.getArrayValuesAddress((Object)bytes), bytes.length, options, new VoidBlock2<Long, Long>(){
            final /* synthetic */ MTLDevice this$0;
            {
                this.this$0 = this$0;
            }

            public void invoke(Long a, Long b) {
                byte[] bytes = VM.newByteArray((long)a, (int)b.intValue());
                deallocator.invoke((Object)bytes);
            }
        });
    }

    public MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor descriptor, MTLPipelineOption options) throws NSErrorException {
        return this.newRenderPipelineState(descriptor, options, (MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr)null);
    }

    public MTLComputePipelineState newComputePipelineState(MTLFunction computeFunction, MTLPipelineOption options) throws NSErrorException {
        return this.newComputePipelineState(computeFunction, options, (MTLComputePipelineReflection.MTLComputePipelineReflectionPtr)null);
    }

    @Bridge(symbol="MTLCreateSystemDefaultDevice", optional=true)
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public static native MTLDevice getSystemDefaultDevice();

    @Method(selector="newCommandQueue")
    public native MTLCommandQueue newCommandQueue();

    @Method(selector="newCommandQueueWithMaxCommandBufferCount:")
    public native MTLCommandQueue newCommandQueue(@MachineSizedUInt long var1);

    @Method(selector="heapTextureSizeAndAlignWithDescriptor:")
    @ByVal
    public native MTLSizeAndAlign heapTextureSizeAndAlign(MTLTextureDescriptor var1);

    @Method(selector="heapBufferSizeAndAlignWithLength:options:")
    @ByVal
    public native MTLSizeAndAlign heapBufferSizeAndAlignWithLength(@MachineSizedUInt long var1, MTLResourceOptions var3);

    @Method(selector="newHeapWithDescriptor:")
    public native MTLHeap newHeap(MTLHeapDescriptor var1);

    @Method(selector="newBufferWithLength:options:")
    public native MTLBuffer newBuffer(@MachineSizedUInt long var1, MTLResourceOptions var3);

    @Method(selector="newBufferWithBytes:length:options:")
    protected native MTLBuffer newBuffer(@Pointer long var1, @MachineSizedUInt long var3, MTLResourceOptions var5);

    @Method(selector="newBufferWithBytesNoCopy:length:options:deallocator:")
    protected native MTLBuffer newBuffer(@Pointer long var1, @MachineSizedUInt long var3, MTLResourceOptions var5, @Block(value="(@Pointer,@MachineSizedUInt)") VoidBlock2<Long, Long> var6);

    @Method(selector="newDepthStencilStateWithDescriptor:")
    public native MTLDepthStencilState newDepthStencilState(MTLDepthStencilDescriptor var1);

    @Method(selector="newTextureWithDescriptor:")
    public native MTLTexture newTexture(MTLTextureDescriptor var1);

    @Method(selector="newTextureWithDescriptor:iosurface:plane:")
    public native MTLTexture newTexture(MTLTextureDescriptor var1, IOSurface var2, @MachineSizedUInt long var3);

    @Method(selector="newSharedTextureWithDescriptor:")
    public native MTLTexture newSharedTexture(MTLTextureDescriptor var1);

    @Method(selector="newSharedTextureWithHandle:")
    public native MTLTexture newSharedTexture(MTLSharedTextureHandle var1);

    @Method(selector="newSamplerStateWithDescriptor:")
    public native MTLSamplerState newSamplerState(MTLSamplerDescriptor var1);

    @Method(selector="newDefaultLibrary")
    public native MTLLibrary newDefaultLibrary();

    public MTLLibrary newDefaultLibrary(NSBundle bundle) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLLibrary result = this.newDefaultLibrary(bundle, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newDefaultLibraryWithBundle:error:")
    public native MTLLibrary newDefaultLibrary(NSBundle var1, NSError.NSErrorPtr var2);

    @Deprecated
    public MTLLibrary newLibraryWithFile(String filepath) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLLibrary result = this.newLibraryWithFile(filepath, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Deprecated
    @Method(selector="newLibraryWithFile:error:")
    public native MTLLibrary newLibraryWithFile(String var1, NSError.NSErrorPtr var2);

    public MTLLibrary newLibrary(NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLLibrary result = this.newLibrary(url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newLibraryWithURL:error:")
    public native MTLLibrary newLibrary(NSURL var1, NSError.NSErrorPtr var2);

    @WeaklyLinked
    public MTLLibrary newLibraryWithData(DispatchData data) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLLibrary result = this.newLibraryWithData(data, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newLibraryWithData:error:")
    @WeaklyLinked
    public native MTLLibrary newLibraryWithData(DispatchData var1, NSError.NSErrorPtr var2);

    public MTLLibrary newLibraryWithSource(String source, MTLCompileOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLLibrary result = this.newLibraryWithSource(source, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newLibraryWithSource:options:error:")
    public native MTLLibrary newLibraryWithSource(String var1, MTLCompileOptions var2, NSError.NSErrorPtr var3);

    @Method(selector="newLibraryWithSource:options:completionHandler:")
    public native void newLibraryWithSource(String var1, MTLCompileOptions var2, @Block VoidBlock2<MTLLibrary, NSError> var3);

    @Method(selector="newLibraryWithStitchedDescriptor:error:")
    public native MTLLibrary newLibrary(MTLStitchedLibraryDescriptor var1, NSError.NSErrorPtr var2);

    @Method(selector="newLibraryWithStitchedDescriptor:completionHandler:")
    public native void newLibrary(MTLStitchedLibraryDescriptor var1, @Block VoidBlock2<MTLLibrary, NSError> var2);

    public MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor descriptor) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLRenderPipelineState result = this.newRenderPipelineState(descriptor, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newRenderPipelineStateWithDescriptor:error:")
    public native MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor var1, NSError.NSErrorPtr var2);

    public MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor descriptor, MTLPipelineOption options, MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr reflection) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLRenderPipelineState result = this.newRenderPipelineState(descriptor, options, reflection, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newRenderPipelineStateWithDescriptor:options:reflection:error:")
    public native MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor var1, MTLPipelineOption var2, MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr var3, NSError.NSErrorPtr var4);

    @Method(selector="newRenderPipelineStateWithDescriptor:completionHandler:")
    public native void newRenderPipelineState(MTLRenderPipelineDescriptor var1, @Block VoidBlock2<MTLRenderPipelineState, NSError> var2);

    @Method(selector="newRenderPipelineStateWithDescriptor:options:completionHandler:")
    public native void newRenderPipelineState(MTLRenderPipelineDescriptor var1, MTLPipelineOption var2, @Block VoidBlock3<MTLRenderPipelineState, MTLRenderPipelineReflection, NSError> var3);

    public MTLComputePipelineState newComputePipelineState(MTLFunction computeFunction) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLComputePipelineState result = this.newComputePipelineState(computeFunction, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newComputePipelineStateWithFunction:error:")
    public native MTLComputePipelineState newComputePipelineState(MTLFunction var1, NSError.NSErrorPtr var2);

    public MTLComputePipelineState newComputePipelineState(MTLFunction computeFunction, MTLPipelineOption options, MTLComputePipelineReflection.MTLComputePipelineReflectionPtr reflection) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLComputePipelineState result = this.newComputePipelineState(computeFunction, options, reflection, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newComputePipelineStateWithFunction:options:reflection:error:")
    public native MTLComputePipelineState newComputePipelineState(MTLFunction var1, MTLPipelineOption var2, MTLComputePipelineReflection.MTLComputePipelineReflectionPtr var3, NSError.NSErrorPtr var4);

    @Method(selector="newComputePipelineStateWithFunction:completionHandler:")
    public native void newComputePipelineState(MTLFunction var1, @Block VoidBlock2<MTLComputePipelineState, NSError> var2);

    @Method(selector="newComputePipelineStateWithFunction:options:completionHandler:")
    public native void newComputePipelineState(MTLFunction var1, MTLPipelineOption var2, @Block VoidBlock3<MTLComputePipelineState, MTLComputePipelineReflection, NSError> var3);

    public MTLComputePipelineState newComputePipelineState(MTLComputePipelineDescriptor descriptor, MTLPipelineOption options, MTLComputePipelineReflection.MTLComputePipelineReflectionPtr reflection) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLComputePipelineState result = this.newComputePipelineState(descriptor, options, reflection, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newComputePipelineStateWithDescriptor:options:reflection:error:")
    public native MTLComputePipelineState newComputePipelineState(MTLComputePipelineDescriptor var1, MTLPipelineOption var2, MTLComputePipelineReflection.MTLComputePipelineReflectionPtr var3, NSError.NSErrorPtr var4);

    @Method(selector="newComputePipelineStateWithDescriptor:options:completionHandler:")
    public native void newComputePipelineState(MTLComputePipelineDescriptor var1, MTLPipelineOption var2, @Block VoidBlock3<MTLComputePipelineState, MTLComputePipelineReflection, NSError> var3);

    @Method(selector="newFence")
    public native MTLFence newFence();

    @Deprecated
    @Method(selector="supportsFeatureSet:")
    public native boolean supportsFeatureSet(MTLFeatureSet var1);

    @Method(selector="supportsFamily:")
    public native boolean supportsFamily(MTLGPUFamily var1);

    @Method(selector="supportsTextureSampleCount:")
    public native boolean supportsTextureSampleCount(@MachineSizedUInt long var1);

    @Method(selector="minimumLinearTextureAlignmentForPixelFormat:")
    @MachineSizedUInt
    public native long minimumLinearTextureAlignmentForPixelFormat(MTLPixelFormat var1);

    @Method(selector="minimumTextureBufferAlignmentForPixelFormat:")
    @MachineSizedUInt
    public native long minimumTextureBufferAlignmentForPixelFormat(MTLPixelFormat var1);

    public MTLRenderPipelineState newRenderPipelineState(MTLTileRenderPipelineDescriptor descriptor, MTLPipelineOption options, MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr reflection) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLRenderPipelineState result = this.newRenderPipelineState(descriptor, options, reflection, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newRenderPipelineStateWithTileDescriptor:options:reflection:error:")
    public native MTLRenderPipelineState newRenderPipelineState(MTLTileRenderPipelineDescriptor var1, MTLPipelineOption var2, MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr var3, NSError.NSErrorPtr var4);

    @Method(selector="newRenderPipelineStateWithTileDescriptor:options:completionHandler:")
    public native void newRenderPipelineState(MTLTileRenderPipelineDescriptor var1, MTLPipelineOption var2, @Block VoidBlock3<MTLRenderPipelineState, MTLRenderPipelineReflection, NSError> var3);

    public MTLRenderPipelineState newRenderPipelineState(MTLMeshRenderPipelineDescriptor descriptor, MTLPipelineOption options, MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr reflection) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLRenderPipelineState result = this.newRenderPipelineState(descriptor, options, reflection, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newRenderPipelineStateWithMeshDescriptor:options:reflection:error:")
    public native MTLRenderPipelineState newRenderPipelineState(MTLMeshRenderPipelineDescriptor var1, MTLPipelineOption var2, MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr var3, NSError.NSErrorPtr var4);

    @Method(selector="newRenderPipelineStateWithMeshDescriptor:options:completionHandler:")
    public native void newRenderPipelineState(MTLMeshRenderPipelineDescriptor var1, MTLPipelineOption var2, @Block VoidBlock3<MTLRenderPipelineState, MTLRenderPipelineReflection, NSError> var3);

    @Method(selector="getDefaultSamplePositions:count:")
    public native void getDefaultSamplePositions(MTLSamplePosition var1, @MachineSizedUInt long var2);

    @Method(selector="newArgumentEncoderWithArguments:")
    public native MTLArgumentEncoder newArgumentEncoder(NSArray<MTLArgumentDescriptor> var1);

    @Method(selector="supportsRasterizationRateMapWithLayerCount:")
    public native boolean supportsRasterizationRateMap(@MachineSizedUInt long var1);

    @Method(selector="newRasterizationRateMapWithDescriptor:")
    public native MTLRasterizationRateMap newRasterizationRateMap(MTLRasterizationRateMapDescriptor var1);

    @Method(selector="newIndirectCommandBufferWithDescriptor:maxCommandCount:options:")
    public native MTLIndirectCommandBuffer newIndirectCommand(MTLIndirectCommandBufferDescriptor var1, @MachineSizedUInt long var2, MTLResourceOptions var4);

    @Method(selector="newEvent")
    public native MTLEvent newEvent();

    @Method(selector="newSharedEvent")
    public native MTLSharedEvent newSharedEvent();

    @Method(selector="newSharedEventWithHandle:")
    public native MTLSharedEvent newSharedEvent(MTLSharedEventHandle var1);

    @Deprecated
    @Method(selector="newIOHandleWithURL:error:")
    public native MTLIOFileHandle newIOHandle(NSURL var1, NSError.NSErrorPtr var2);

    @Method(selector="newIOCommandQueueWithDescriptor:error:")
    public native MTLIOCommandQueue newIOCommandQueue(MTLIOCommandQueueDescriptor var1, NSError.NSErrorPtr var2);

    @Deprecated
    @Method(selector="newIOHandleWithURL:compressionMethod:error:")
    public native MTLIOFileHandle newIOHandle(NSURL var1, MTLIOCompressionMethod var2, NSError.NSErrorPtr var3);

    public MTLIOFileHandle newIOFileHandle(NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLIOFileHandle result = this.newIOFileHandle(url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newIOFileHandleWithURL:error:")
    public native MTLIOFileHandle newIOFileHandle(NSURL var1, NSError.NSErrorPtr var2);

    public MTLIOFileHandle newIOFileHandle(NSURL url, MTLIOCompressionMethod compressionMethod) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLIOFileHandle result = this.newIOFileHandle(url, compressionMethod, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newIOFileHandleWithURL:compressionMethod:error:")
    public native MTLIOFileHandle newIOFileHandle(NSURL var1, MTLIOCompressionMethod var2, NSError.NSErrorPtr var3);

    @Method(selector="sparseTileSizeWithTextureType:pixelFormat:sampleCount:")
    @ByVal
    public native MTLSize sparseTileSizeWithTextureType(MTLTextureType var1, MTLPixelFormat var2, @MachineSizedUInt long var3);

    @Method(selector="convertSparsePixelRegions:toTileRegions:withTileSize:alignmentMode:numRegions:")
    public native void convertSparsePixelRegions(MTLRegion var1, MTLRegion var2, @ByVal MTLSize var3, MTLSparseTextureRegionAlignmentMode var4, @MachineSizedUInt long var5);

    @Method(selector="convertSparseTileRegions:toPixelRegions:withTileSize:numRegions:")
    public native void convertSparseTileRegions(MTLRegion var1, MTLRegion var2, @ByVal MTLSize var3, @MachineSizedUInt long var4);

    @Method(selector="sparseTileSizeInBytesForSparsePageSize:")
    @MachineSizedUInt
    public native long sparseTileSizeInBytesForSparsePageSize(MTLSparsePageSize var1);

    @Method(selector="sparseTileSizeWithTextureType:pixelFormat:sampleCount:sparsePageSize:")
    @ByVal
    public native MTLSize sparseTileSize(MTLTextureType var1, MTLPixelFormat var2, @MachineSizedUInt long var3, MTLSparsePageSize var5);

    @Method(selector="newCounterSampleBufferWithDescriptor:error:")
    public native MTLCounterSampleBuffer newCounterSampleBuffer(MTLCounterSampleBufferDescriptor var1, NSError.NSErrorPtr var2);

    @Method(selector="sampleTimestamps:gpuTimestamp:")
    public native void sampleTimestamps(LongPtr var1, LongPtr var2);

    @Method(selector="newArgumentEncoderWithBufferBinding:")
    public native MTLArgumentEncoder newArgumentEncoder(MTLBufferBinding var1);

    @Method(selector="supportsCounterSampling:")
    public native boolean supportsCounterSampling(MTLCounterSamplingPoint var1);

    @Method(selector="supportsVertexAmplificationCount:")
    public native boolean supportsVertexAmplificationCount(@MachineSizedUInt long var1);

    @Method(selector="newDynamicLibrary:error:")
    public native MTLDynamicLibrary newDynamicLibrary(MTLLibrary var1, NSError.NSErrorPtr var2);

    @Method(selector="newDynamicLibraryWithURL:error:")
    public native MTLDynamicLibrary newDynamicLibrary(NSURL var1, NSError.NSErrorPtr var2);

    @Method(selector="newBinaryArchiveWithDescriptor:error:")
    public native MTLBinaryArchive newBinaryArchive(MTLBinaryArchiveDescriptor var1, NSError.NSErrorPtr var2);

    @Method(selector="accelerationStructureSizesWithDescriptor:")
    @ByVal
    public native MTLAccelerationStructureSizes accelerationStructureSizes(MTLAccelerationStructureDescriptor var1);

    @Method(selector="newAccelerationStructureWithSize:")
    public native MTLAccelerationStructure newAccelerationStructure(@MachineSizedUInt long var1);

    @Method(selector="newAccelerationStructureWithDescriptor:")
    public native MTLAccelerationStructure newAccelerationStructure(MTLAccelerationStructureDescriptor var1);

    @Method(selector="heapAccelerationStructureSizeAndAlignWithSize:")
    @ByVal
    public native MTLSizeAndAlign heapAccelerationStructureSizeAndAlign(@MachineSizedUInt long var1);

    @Method(selector="heapAccelerationStructureSizeAndAlignWithDescriptor:")
    @ByVal
    public native MTLSizeAndAlign heapAccelerationStructureSizeAndAlign(MTLAccelerationStructureDescriptor var1);

    static {
        ObjCRuntime.bind(MTLDevice.class);
    }

    public static class MTLDevicePtr
    extends Ptr<MTLDevice, MTLDevicePtr> {
    }
}

