/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metalps;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.metal.MTLCommandBuffer;
import org.robovm.apple.metal.MTLDevice;
import org.robovm.apple.metal.MTLRegion;
import org.robovm.apple.metalps.MPSImage;
import org.robovm.apple.metalps.MPSImageAllocator;
import org.robovm.apple.metalps.MPSImageDescriptor;
import org.robovm.apple.metalps.MPSImageEdgeMode;
import org.robovm.apple.metalps.MPSKernel;
import org.robovm.apple.metalps.MPSNNPadding;
import org.robovm.apple.metalps.MPSOffset;
import org.robovm.apple.metalps.MPSState;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MetalPerformanceShaders")
@NativeClass
public class MPSCNNKernel
extends MPSKernel {
    public MPSCNNKernel() {
    }

    protected MPSCNNKernel(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MPSCNNKernel(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithDevice:")
    public MPSCNNKernel(MTLDevice device) {
        super((NSObject.SkipInit)null);
        this.initObject(this.init(device));
    }

    @Method(selector="initWithCoder:device:")
    public MPSCNNKernel(NSCoder decoder, MTLDevice device) {
        super((NSObject.SkipInit)null);
        this.initObject(this.init(decoder, device));
    }

    @Method(selector="initWithCoder:")
    public MPSCNNKernel(NSCoder coder) {
        super(coder);
    }

    @Property(selector="offset")
    @ByVal
    public native MPSOffset getOffset();

    @Property(selector="setOffset:")
    public native void setOffset(@ByVal MPSOffset var1);

    @Property(selector="clipRect")
    @ByVal
    public native MTLRegion getClipRect();

    @Property(selector="setClipRect:")
    public native void setClipRect(@ByVal MTLRegion var1);

    @Property(selector="destinationFeatureChannelOffset")
    @MachineSizedUInt
    public native long getDestinationFeatureChannelOffset();

    @Property(selector="setDestinationFeatureChannelOffset:")
    public native void setDestinationFeatureChannelOffset(@MachineSizedUInt long var1);

    @Property(selector="sourceFeatureChannelOffset")
    @MachineSizedUInt
    public native long getSourceFeatureChannelOffset();

    @Property(selector="setSourceFeatureChannelOffset:")
    public native void setSourceFeatureChannelOffset(@MachineSizedUInt long var1);

    @Property(selector="sourceFeatureChannelMaxCount")
    @MachineSizedUInt
    public native long getSourceFeatureChannelMaxCount();

    @Property(selector="setSourceFeatureChannelMaxCount:")
    public native void setSourceFeatureChannelMaxCount(@MachineSizedUInt long var1);

    @Property(selector="edgeMode")
    public native MPSImageEdgeMode getEdgeMode();

    @Property(selector="setEdgeMode:")
    public native void setEdgeMode(MPSImageEdgeMode var1);

    @Property(selector="kernelWidth")
    @MachineSizedUInt
    public native long getKernelWidth();

    @Property(selector="kernelHeight")
    @MachineSizedUInt
    public native long getKernelHeight();

    @Property(selector="strideInPixelsX")
    @MachineSizedUInt
    public native long getStrideInPixelsX();

    @Property(selector="strideInPixelsY")
    @MachineSizedUInt
    public native long getStrideInPixelsY();

    @Property(selector="dilationRateX")
    @MachineSizedUInt
    public native long getDilationRateX();

    @Property(selector="dilationRateY")
    @MachineSizedUInt
    public native long getDilationRateY();

    @Property(selector="isBackwards")
    public native boolean isBackwards();

    @Property(selector="isStateModified")
    public native boolean isStateModified();

    @Property(selector="padding")
    public native MPSNNPadding getPadding();

    @Property(selector="setPadding:")
    public native void setPadding(MPSNNPadding var1);

    @Property(selector="destinationImageAllocator")
    public native MPSImageAllocator getDestinationImageAllocator();

    @Property(selector="setDestinationImageAllocator:")
    public native void setDestinationImageAllocator(MPSImageAllocator var1);

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    @Override
    @Method(selector="initWithDevice:")
    @Pointer
    protected native long init(MTLDevice var1);

    @Override
    @Method(selector="initWithCoder:device:")
    @Pointer
    protected native long init(NSCoder var1, MTLDevice var2);

    @Method(selector="encodeToCommandBuffer:sourceImage:destinationImage:")
    public native void encode(MTLCommandBuffer var1, MPSImage var2, MPSImage var3);

    @Method(selector="encodeToCommandBuffer:sourceImage:destinationState:destinationImage:")
    public native void encode(MTLCommandBuffer var1, MPSImage var2, MPSState var3, MPSImage var4);

    @Method(selector="encodeBatchToCommandBuffer:sourceImages:destinationImages:")
    public native void encodeBatch0(MTLCommandBuffer var1, NSArray<MPSImage> var2, NSArray<MPSImage> var3);

    @Method(selector="encodeBatchToCommandBuffer:sourceImages:destinationStates:destinationImages:")
    public native void encodeBatch0(MTLCommandBuffer var1, NSArray<MPSImage> var2, NSArray<? extends MPSState> var3, NSArray<MPSImage> var4);

    @Method(selector="encodeToCommandBuffer:sourceImage:")
    public native MPSImage encode(MTLCommandBuffer var1, MPSImage var2);

    @Method(selector="encodeToCommandBuffer:sourceImage:destinationState:destinationStateIsTemporary:")
    public native MPSImage encode(MTLCommandBuffer var1, MPSImage var2, MPSState.MPSStatePtr var3, boolean var4);

    @Method(selector="encodeBatchToCommandBuffer:sourceImages:")
    public native NSArray<MPSImage> encodeBatch(MTLCommandBuffer var1, NSArray<MPSImage> var2);

    @Method(selector="encodeBatchToCommandBuffer:sourceImages:destinationStates:destinationStateIsTemporary:")
    public native NSArray<MPSImage> encodeBatch(MTLCommandBuffer var1, NSArray<MPSImage> var2, NSArray.NSArrayPtr<? extends MPSState> var3, boolean var4);

    @Method(selector="resultStateForSourceImage:sourceStates:destinationImage:")
    public native MPSState getResultState(MPSImage var1, NSArray<MPSState> var2, MPSImage var3);

    @Method(selector="resultStateBatchForSourceImage:sourceStates:destinationImage:")
    public native NSArray<? extends MPSState> getResultStateBatch(NSArray<MPSImage> var1, NSArray<NSArray<? extends MPSState>> var2, NSArray<MPSImage> var3);

    @Method(selector="temporaryResultStateForCommandBuffer:sourceImage:sourceStates:destinationImage:")
    public native MPSState getTemporaryResult(MTLCommandBuffer var1, MPSImage var2, NSArray<MPSState> var3, MPSImage var4);

    @Method(selector="temporaryResultStateBatchForCommandBuffer:sourceImage:sourceStates:destinationImage:")
    public native NSArray<? extends MPSState> getTemporaryResultStateBatch(MTLCommandBuffer var1, NSArray<MPSImage> var2, NSArray<NSArray<? extends MPSState>> var3, NSArray<MPSImage> var4);

    @Method(selector="isResultStateReusedAcrossBatch")
    public native boolean isResultStateReusedAcrossBatch();

    @Method(selector="appendBatchBarrier")
    public native boolean appendBatchBarrier();

    @Method(selector="destinationImageDescriptorForSourceImages:sourceStates:")
    public native MPSImageDescriptor getDestinationImageDescriptor(NSArray<MPSImage> var1, NSArray<MPSState> var2);

    @Method(selector="encodingStorageSizeForSourceImage:sourceStates:destinationImage:")
    @MachineSizedUInt
    public native long getEncodingStorageSize(MPSImage var1, NSArray<MPSState> var2, MPSImage var3);

    @Method(selector="batchEncodingStorageSizeForSourceImage:sourceStates:destinationImage:")
    @MachineSizedUInt
    public native long getBatchEncodingStorageSize(NSArray<MPSImage> var1, NSArray<NSArray<? extends MPSState>> var2, NSArray<MPSImage> var3);

    static {
        ObjCRuntime.bind(MPSCNNKernel.class);
    }

    public static class MPSCNNKernelPtr
    extends Ptr<MPSCNNKernel, MPSCNNKernelPtr> {
    }
}

