/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.naturallanguage;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.naturallanguage.NLContextualEmbeddingAssetsResult;
import org.robovm.apple.naturallanguage.NLContextualEmbeddingResult;
import org.robovm.apple.naturallanguage.NLLanguage;
import org.robovm.apple.naturallanguage.NLScript;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="NaturalLanguage")
@NativeClass
public class NLContextualEmbedding
extends NSObject {
    protected NLContextualEmbedding() {
    }

    protected NLContextualEmbedding(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NLContextualEmbedding(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NLContextualEmbedding(String modelIdentifier) {
        super(null, NLContextualEmbedding.create(modelIdentifier));
        NLContextualEmbedding.retain(this.getHandle());
    }

    public NLContextualEmbedding(NLLanguage language) {
        super(null, NLContextualEmbedding.create(language));
        NLContextualEmbedding.retain(this.getHandle());
    }

    public NLContextualEmbedding(NLScript script) {
        super(null, NLContextualEmbedding.create(script));
        NLContextualEmbedding.retain(this.getHandle());
    }

    @Property(selector="modelIdentifier")
    public native String getModelIdentifier();

    @Property(selector="languages")
    public native NSArray<NSString> getLanguages();

    @Property(selector="scripts")
    public native NSArray<NSString> getScripts();

    @Property(selector="revision")
    @MachineSizedUInt
    public native long getRevision();

    @Property(selector="dimension")
    @MachineSizedUInt
    public native long getDimension();

    @Property(selector="maximumSequenceLength")
    @MachineSizedUInt
    public native long getMaximumSequenceLength();

    @Property(selector="hasAvailableAssets")
    public native boolean hasAvailableAssets();

    public boolean load() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.load(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="loadWithError:")
    private native boolean load(NSError.NSErrorPtr var1);

    @Method(selector="unload")
    public native void unload();

    public NLContextualEmbeddingResult embeddingResult(String string, NLLanguage language) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NLContextualEmbeddingResult result = this.embeddingResult(string, language, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="embeddingResultForString:language:error:")
    private native NLContextualEmbeddingResult embeddingResult(String var1, NLLanguage var2, NSError.NSErrorPtr var3);

    @Method(selector="requestEmbeddingAssetsWithCompletionHandler:")
    public native void requestEmbeddingAssets(@Block VoidBlock2<NLContextualEmbeddingAssetsResult, NSError> var1);

    @Method(selector="contextualEmbeddingWithModelIdentifier:")
    @Pointer
    protected static native long create(String var0);

    @Method(selector="contextualEmbeddingsForValues:")
    public static native NSArray<NLContextualEmbedding> contextualEmbeddingsForValues(NSDictionary<NSString, ?> var0);

    @Method(selector="contextualEmbeddingWithLanguage:")
    @Pointer
    protected static native long create(NLLanguage var0);

    @Method(selector="contextualEmbeddingWithScript:")
    @Pointer
    protected static native long create(NLScript var0);

    static {
        ObjCRuntime.bind(NLContextualEmbedding.class);
    }

    public static class NLContextualEmbeddingPtr
    extends Ptr<NLContextualEmbedding, NLContextualEmbeddingPtr> {
    }
}

