/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.network;

import org.robovm.apple.dispatch.DispatchData;
import org.robovm.apple.dispatch.DispatchQueue;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.network.NWConnectionGroup;
import org.robovm.apple.network.NWConnectionGroupState;
import org.robovm.apple.network.NWConnectionState;
import org.robovm.apple.network.NWContentContext;
import org.robovm.apple.network.NWDataTransferReport;
import org.robovm.apple.network.NWEndpoint;
import org.robovm.apple.network.NWError;
import org.robovm.apple.network.NWEstablishmentReport;
import org.robovm.apple.network.NWGroupDescriptor;
import org.robovm.apple.network.NWObject;
import org.robovm.apple.network.NWParameters;
import org.robovm.apple.network.NWPath;
import org.robovm.apple.network.NWProtocolDefinition;
import org.robovm.apple.network.NWProtocolMetadata;
import org.robovm.apple.network.NWProtocolOptions;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.objc.block.VoidBlock3;
import org.robovm.objc.block.VoidBlock4;
import org.robovm.objc.block.VoidBooleanBlock;
import org.robovm.rt.VM;
import org.robovm.rt.bro.StringMarshalers;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Network")
@NativeClass(value="NSObject")
public final class NWConnection
extends NWObject
implements NSObjectProtocol {
    public NWConnection(NWEndpoint endpoint, NWParameters parameters) {
        super(null, NWConnection.create(endpoint, parameters));
    }

    public String copyDescription() {
        long ptr = this.copyDescription0();
        if (ptr != 0L) {
            String res = StringMarshalers.AsAsciiZMarshaler.toObject(String.class, (long)ptr, (long)0L);
            VM.free((long)ptr);
            return res;
        }
        return null;
    }

    @GlobalValue(symbol="_nw_connection_send_idempotent_content", optional=true)
    @Block
    public static native VoidBlock1<NWError> SEND_IDEMPOTENT_CONTENT();

    @Bridge(symbol="nw_connection_create", optional=true)
    @Pointer
    private static native long create(NWEndpoint var0, NWParameters var1);

    @Bridge(symbol="nw_connection_copy_endpoint", optional=true)
    public native NWEndpoint copyEndpoint();

    @Bridge(symbol="nw_connection_copy_parameters", optional=true)
    public native NWParameters copyParameters();

    @Bridge(symbol="nw_connection_set_state_changed_handler", optional=true)
    public native void setStateChangedHandler(@Block VoidBlock2<NWConnectionState, NWError> var1);

    @Bridge(symbol="nw_connection_set_viability_changed_handler", optional=true)
    public native void setViabilityChangedHandler(@Block VoidBooleanBlock var1);

    @Bridge(symbol="nw_connection_set_better_path_available_handler", optional=true)
    public native void setBetterPathAvailableHandler(@Block VoidBooleanBlock var1);

    @Bridge(symbol="nw_connection_set_path_changed_handler", optional=true)
    public native void setPathChangedHandler(@Block VoidBlock1<NWPath> var1);

    @Bridge(symbol="nw_connection_set_queue", optional=true)
    public native void setQueue(DispatchQueue var1);

    @Bridge(symbol="nw_connection_start", optional=true)
    public native void start();

    @Bridge(symbol="nw_connection_restart", optional=true)
    public native void restart();

    @Bridge(symbol="nw_connection_cancel", optional=true)
    public native void cancel();

    @Bridge(symbol="nw_connection_force_cancel", optional=true)
    public native void forceCancel();

    @Bridge(symbol="nw_connection_cancel_current_endpoint", optional=true)
    public native void cancelCurrentEndpoint();

    @Bridge(symbol="nw_connection_receive", optional=true)
    public native void receive(int var1, int var2, @Block VoidBlock4<DispatchData, NWContentContext, Boolean, NWError> var3);

    @Bridge(symbol="nw_connection_receive_message", optional=true)
    public native void receiveMessage(@Block VoidBlock4<DispatchData, NWContentContext, Boolean, NWError> var1);

    @Bridge(symbol="nw_connection_send", optional=true)
    public native void send(DispatchData var1, NWContentContext var2, boolean var3, @Block VoidBlock1<NWError> var4);

    @Bridge(symbol="nw_connection_batch", optional=true)
    public native void batch(@Block Runnable var1);

    @Bridge(symbol="nw_connection_copy_description", optional=true)
    @Pointer
    protected native long copyDescription0();

    @Bridge(symbol="nw_connection_copy_current_path", optional=true)
    public native NWPath copyCurrentPath();

    @Bridge(symbol="nw_connection_copy_protocol_metadata", optional=true)
    public native NWProtocolMetadata copyProtocolMetadata(NWProtocolDefinition var1);

    @Bridge(symbol="nw_connection_get_maximum_datagram_size", optional=true)
    public native int getMaximumDatagramSize();

    @Bridge(symbol="nw_connection_group_create", optional=true)
    public static native NWConnectionGroup groupCreate(NWGroupDescriptor var0, NWParameters var1);

    @Bridge(symbol="nw_connection_group_copy_descriptor", optional=true)
    public static native NWGroupDescriptor groupCopyDescriptor(NWConnectionGroup var0);

    @Bridge(symbol="nw_connection_group_copy_parameters", optional=true)
    public static native NWParameters groupCopyParameters(NWConnectionGroup var0);

    @Bridge(symbol="nw_connection_group_set_queue", optional=true)
    public static native void groupSetQueue(NWConnectionGroup var0, DispatchQueue var1);

    @Bridge(symbol="nw_connection_group_set_state_changed_handler", optional=true)
    public static native void groupSetStateChangedHandler(NWConnectionGroup var0, @Block VoidBlock2<NWConnectionGroupState, NWError> var1);

    @Bridge(symbol="nw_connection_group_set_receive_handler", optional=true)
    public static native void groupSetReceiveHandler(NWConnectionGroup var0, int var1, boolean var2, @Block VoidBlock3<DispatchData, NWContentContext, Boolean> var3);

    @Bridge(symbol="nw_connection_group_start", optional=true)
    public static native void groupStart(NWConnectionGroup var0);

    @Bridge(symbol="nw_connection_group_cancel", optional=true)
    public static native void groupCancel(NWConnectionGroup var0);

    @Bridge(symbol="nw_connection_group_copy_remote_endpoint_for_message", optional=true)
    public static native NWEndpoint groupCopyRemoteEndpointForMessage(NWConnectionGroup var0, NWContentContext var1);

    @Bridge(symbol="nw_connection_group_copy_local_endpoint_for_message", optional=true)
    public static native NWEndpoint groupCopyLocalEndpointForMessage(NWConnectionGroup var0, NWContentContext var1);

    @Bridge(symbol="nw_connection_group_copy_path_for_message", optional=true)
    public static native NWPath groupCopyPathForMessage(NWConnectionGroup var0, NWContentContext var1);

    @Bridge(symbol="nw_connection_group_copy_protocol_metadata_for_message", optional=true)
    public static native NWProtocolMetadata groupCopyProtocolMetadataForMessage(NWConnectionGroup var0, NWContentContext var1, NWProtocolDefinition var2);

    @Bridge(symbol="nw_connection_group_extract_connection_for_message", optional=true)
    public static native NWConnection groupExtractConnectionForMessage(NWConnectionGroup var0, NWContentContext var1);

    @Bridge(symbol="nw_connection_group_reply", optional=true)
    public static native void groupReply(NWConnectionGroup var0, NWContentContext var1, NWContentContext var2, DispatchData var3);

    @Bridge(symbol="nw_connection_group_extract_connection", optional=true)
    public static native NWConnection groupExtractConnection(NWConnectionGroup var0, NWEndpoint var1, NWProtocolOptions var2);

    @Bridge(symbol="nw_connection_group_reinsert_extracted_connection", optional=true)
    public static native boolean groupReinsertExtractedConnection(NWConnectionGroup var0, NWConnection var1);

    @Bridge(symbol="nw_connection_group_send_message", optional=true)
    public static native void groupSendMessage(NWConnectionGroup var0, DispatchData var1, NWEndpoint var2, NWContentContext var3, @Block VoidBlock1<NWError> var4);

    @Bridge(symbol="nw_connection_group_set_new_connection_handler", optional=true)
    public static native void groupSetNewConnectionHandler(NWConnectionGroup var0, @Block VoidBlock1<NWConnection> var1);

    @Bridge(symbol="nw_connection_group_copy_protocol_metadata", optional=true)
    public static native NWProtocolMetadata groupCopyProtocolMetadata(NWConnectionGroup var0, NWProtocolDefinition var1);

    @Bridge(symbol="nw_connection_access_establishment_report", optional=true)
    public native void accessEstablishmentReport(DispatchQueue var1, @Block VoidBlock1<NWEstablishmentReport> var2);

    @Bridge(symbol="nw_connection_create_new_data_transfer_report", optional=true)
    public native NWDataTransferReport createNewDataTransferReport();

    static {
        ObjCRuntime.bind(NWConnection.class);
    }

    public static class NWConnectionPtr
    extends Ptr<NWConnection, NWConnectionPtr> {
    }
}

