/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.shazamkit;

import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.ValuedEnum;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Marshaler(value=ValuedEnum.AsMachineSizedSIntMarshaler.class)
@Library(value="ShazamKit")
public enum SHErrorCode implements NSErrorCode
{
    InvalidAudioFormat(100L),
    AudioDiscontinuity(101L),
    SignatureInvalid(200L),
    SignatureDurationInvalid(201L),
    MatchAttemptFailed(202L),
    CustomCatalogInvalid(300L),
    CustomCatalogInvalidURL(301L),
    MediaLibrarySyncFailed(400L),
    InternalError(500L),
    MediaItemFetchFailed(600L);

    private final long n;

    @GlobalValue(symbol="SHErrorDomain", optional=true)
    public static native String getClassDomain();

    private SHErrorCode(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static SHErrorCode valueOf(long n) {
        for (SHErrorCode v : SHErrorCode.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + SHErrorCode.class.getName());
    }

    static {
        Bro.bind(SHErrorCode.class);
        Bro.bind(NSErrorWrap.class);
    }

    @StronglyLinked
    public static class NSErrorWrap
    extends NSError {
        protected NSErrorWrap(NSObject.SkipInit skipInit) {
            super(skipInit);
        }

        @Override
        public NSErrorCode getErrorCode() {
            try {
                return SHErrorCode.valueOf(this.getCode());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static String getClassDomain() {
            return SHErrorCode.getClassDomain();
        }
    }
}

