/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.LongMap;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.TypeEncoding;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;

@Library(value="UIKit")
@Marshaler(value=NSString.AsStringMarshaler.class)
public class UIVideo
extends CocoaUtility {
    private static AtomicLong id = new AtomicLong();
    private static final Selector didFinishSaving = Selector.register((String)"video:didFinishSavingWithError:contextInfo:");
    private static LongMap<ListenerWrapper> callbacks = new LongMap();

    public static boolean isCompatibleWithSavedPhotosAlbum(File videoPath) {
        return UIVideo.isCompatibleWithSavedPhotosAlbum(videoPath.getAbsolutePath());
    }

    public static void saveToPhotosAlbum(File videoPath, VoidBlock2<String, NSError> callback) {
        if (callback != null) {
            long context = id.getAndIncrement();
            ListenerWrapper l = new ListenerWrapper(callback, context);
            UIVideo.saveToPhotosAlbum(videoPath.getAbsolutePath(), l, didFinishSaving, context);
        } else {
            UIVideo.saveToPhotosAlbum(videoPath.getAbsolutePath(), null, null, 0L);
        }
    }

    @Bridge(symbol="UIVideoAtPathIsCompatibleWithSavedPhotosAlbum", optional=true)
    protected static native boolean isCompatibleWithSavedPhotosAlbum(String var0);

    @Bridge(symbol="UISaveVideoAtPathToSavedPhotosAlbum", optional=true)
    public static native void saveToPhotosAlbum(String var0, NSObject var1, Selector var2, @Pointer long var3);

    static {
        Bro.bind(UIVideo.class);
    }

    private static class ListenerWrapper
    extends NSObject {
        private final VoidBlock2<String, NSError> callback;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ListenerWrapper(VoidBlock2<String, NSError> callback, long contextInfo) {
            this.callback = callback;
            LongMap longMap = callbacks;
            synchronized (longMap) {
                callbacks.put(contextInfo, (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TypeEncoding(value="v@:@:^v")
        @Method(selector="video:didFinishSavingWithError:contextInfo:")
        private void didFinishSaving(String videoPath, NSError error, @Pointer long contextInfo) {
            this.callback.invoke((Object)videoPath, (Object)error);
            LongMap longMap = callbacks;
            synchronized (longMap) {
                callbacks.remove(contextInfo);
            }
        }
    }
}

