/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.arkit;

import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.ValuedEnum;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Marshaler(value=ValuedEnum.AsMachineSizedSIntMarshaler.class)
@Library(value="ARKit")
public enum ARErrorCode implements NSErrorCode
{
    UnsupportedConfiguration(100L),
    SensorUnavailable(101L),
    SensorFailed(102L),
    CameraUnauthorized(103L),
    MicrophoneUnauthorized(104L),
    WorldTrackingFailed(200L),
    InvalidReferenceImage(300L),
    InvalidReferenceObject(301L),
    InvalidWorldMap(302L),
    InvalidConfiguration(303L),
    InsufficientFeatures(400L),
    ObjectMergeFailed(401L),
    FileIOFailed(500L);

    private final long n;

    @GlobalValue(symbol="ARErrorDomain", optional=true)
    public static native String getClassDomain();

    private ARErrorCode(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static ARErrorCode valueOf(long n) {
        for (ARErrorCode v : ARErrorCode.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + ARErrorCode.class.getName());
    }

    static {
        Bro.bind(ARErrorCode.class);
    }

    @StronglyLinked
    public static class NSErrorWrap
    extends NSError {
        protected NSErrorWrap(NSObject.SkipInit skipInit) {
            super(skipInit);
        }

        @Override
        public NSErrorCode getErrorCode() {
            try {
                return ARErrorCode.valueOf(this.getCode());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static String getClassDomain() {
            return ARErrorCode.getClassDomain();
        }
    }
}

