/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.audiotoolbox.AudioQueue;
import org.robovm.apple.audiotoolbox.AudioQueueProcessingTapFlags;
import org.robovm.apple.audiotoolbox.AudioQueueProcessingTapMutableFlags;
import org.robovm.apple.coreaudio.AudioBufferList;
import org.robovm.apple.coreaudio.AudioStreamBasicDescription;
import org.robovm.apple.coreaudio.AudioTimeStamp;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AudioToolbox")
public class AudioQueueProcessingTap
extends NativeObject {
    private static AtomicLong callbackId = new AtomicLong();
    private static final LongMap<ProcessingTapCallback> callbacks = new LongMap();
    private static final Method cbProcess;
    private int maxProcessingFrames;
    private AudioStreamBasicDescription processingFormat;

    protected AudioQueueProcessingTap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbProcess(@Pointer long clientData, AudioQueueProcessingTap aqTap, int numberFrames, AudioTimeStamp timeStamp, AudioQueueProcessingTapMutableFlags flags, IntPtr outNumberFrames, AudioBufferList data) {
        LongMap<ProcessingTapCallback> longMap = callbacks;
        synchronized (longMap) {
            int outFrames = ((ProcessingTapCallback)callbacks.get(clientData)).process(aqTap, numberFrames, timeStamp, flags, data);
            outNumberFrames.set(outFrames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AudioQueueProcessingTap create(AudioQueue audioQueue, ProcessingTapCallback callback, AudioQueueProcessingTapFlags flags) throws OSStatusException {
        AudioQueueProcessingTapPtr ptr = new AudioQueueProcessingTapPtr();
        IntPtr maxFramesPtr = new IntPtr();
        AudioStreamBasicDescription processingFormat = new AudioStreamBasicDescription();
        long cid = callbackId.getAndIncrement();
        OSStatus status = AudioQueueProcessingTap.create0(audioQueue, new FunctionPtr(cbProcess), cid, flags, maxFramesPtr, processingFormat, ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<ProcessingTapCallback> longMap = callbacks;
            synchronized (longMap) {
                callbacks.put(cid, (Object)callback);
            }
            AudioQueueProcessingTap result = (AudioQueueProcessingTap)ptr.get();
            result.maxProcessingFrames = maxFramesPtr.get();
            result.processingFormat = processingFormat;
            return result;
        }
        return null;
    }

    public void dispose() throws OSStatusException {
        OSStatus status = this.dispose0();
        OSStatusException.throwIfNecessary(status);
    }

    public int getSourceAudio(int numberFrames, AudioTimeStamp timeStamp, AudioQueueProcessingTapMutableFlags sourceFlags, AudioBufferList data) throws OSStatusException {
        IntPtr sourceFramesPtr = new IntPtr();
        OSStatus status = this.getSourceAudio0(numberFrames, timeStamp, sourceFlags, sourceFramesPtr, data);
        OSStatusException.throwIfNecessary(status);
        return sourceFramesPtr.get();
    }

    public void getQueueTime(DoublePtr queueSampleTime, IntPtr queueFrameCount) throws OSStatusException {
        OSStatus status = this.getQueueTime0(queueSampleTime, queueFrameCount);
        OSStatusException.throwIfNecessary(status);
    }

    public double getQueueSampleTime() throws OSStatusException {
        DoublePtr ptr = new DoublePtr();
        this.getQueueTime(ptr, null);
        return ptr.get();
    }

    public int getQueueFrameCount() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        this.getQueueTime(null, ptr);
        return ptr.get();
    }

    public int getMaxProcessingFrames() {
        return this.maxProcessingFrames;
    }

    public AudioStreamBasicDescription getProcessingFormat() {
        return this.processingFormat;
    }

    @Bridge(symbol="AudioQueueProcessingTapNew", optional=true)
    protected static native OSStatus create0(AudioQueue var0, FunctionPtr var1, @Pointer long var2, AudioQueueProcessingTapFlags var4, IntPtr var5, AudioStreamBasicDescription var6, AudioQueueProcessingTapPtr var7);

    @Bridge(symbol="AudioQueueProcessingTapDispose", optional=true)
    protected native OSStatus dispose0();

    @Bridge(symbol="AudioQueueProcessingTapGetSourceAudio", optional=true)
    protected native OSStatus getSourceAudio0(int var1, AudioTimeStamp var2, AudioQueueProcessingTapMutableFlags var3, IntPtr var4, AudioBufferList var5);

    @Bridge(symbol="AudioQueueProcessingTapGetQueueTime", optional=true)
    protected native OSStatus getQueueTime0(DoublePtr var1, IntPtr var2);

    static {
        try {
            cbProcess = AudioQueueProcessingTap.class.getDeclaredMethod("cbProcess", Long.TYPE, AudioQueueProcessingTap.class, Integer.TYPE, AudioTimeStamp.class, AudioQueueProcessingTapMutableFlags.class, IntPtr.class, AudioBufferList.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(AudioQueueProcessingTap.class);
    }

    public static class AudioQueueProcessingTapPtr
    extends Ptr<AudioQueueProcessingTap, AudioQueueProcessingTapPtr> {
    }

    public static interface ProcessingTapCallback {
        public int process(AudioQueueProcessingTap var1, int var2, AudioTimeStamp var3, AudioQueueProcessingTapMutableFlags var4, AudioBufferList var5);
    }
}

