/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.avfoundation.AVMediaSelection;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="AVFoundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class AVAssetDownloadTaskOptions
extends NSDictionaryWrapper {
    AVAssetDownloadTaskOptions(NSDictionary data) {
        super(data);
    }

    public AVAssetDownloadTaskOptions() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public AVAssetDownloadTaskOptions set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public long getMinimumRequiredMediaBitrate() {
        if (this.has(Keys.MinimumRequiredMediaBitrate())) {
            NSNumber val = (NSNumber)this.get(Keys.MinimumRequiredMediaBitrate());
            return val.longValue();
        }
        return 0L;
    }

    public AVAssetDownloadTaskOptions setMinimumRequiredMediaBitrate(long minimumRequiredMediaBitrate) {
        this.set(Keys.MinimumRequiredMediaBitrate(), NSNumber.valueOf(minimumRequiredMediaBitrate));
        return this;
    }

    public AVMediaSelection getMediaSelection() {
        if (this.has(Keys.MediaSelection())) {
            AVMediaSelection val = (AVMediaSelection)this.get(Keys.MediaSelection());
            return val;
        }
        return null;
    }

    public AVAssetDownloadTaskOptions setMediaSelection(AVMediaSelection mediaSelection) {
        this.set(Keys.MediaSelection(), mediaSelection);
        return this;
    }

    @Library(value="AVFoundation")
    public static class Keys {
        @GlobalValue(symbol="AVAssetDownloadTaskMinimumRequiredMediaBitrateKey", optional=true)
        public static native NSString MinimumRequiredMediaBitrate();

        @GlobalValue(symbol="AVAssetDownloadTaskMediaSelectionKey", optional=true)
        public static native NSString MediaSelection();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVAssetDownloadTaskOptions> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<AVAssetDownloadTaskOptions> list = new ArrayList<AVAssetDownloadTaskOptions>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new AVAssetDownloadTaskOptions((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<AVAssetDownloadTaskOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (AVAssetDownloadTaskOptions i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVAssetDownloadTaskOptions toObject(Class<AVAssetDownloadTaskOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVAssetDownloadTaskOptions(o);
        }

        @MarshalsPointer
        public static long toNative(AVAssetDownloadTaskOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

