/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFData;
import org.robovm.apple.corefoundation.CFMachPortContext;
import org.robovm.apple.corefoundation.CFRunLoopSource;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreFoundation")
public class CFMachPort
extends CFType {
    private static final AtomicLong refconId = new AtomicLong();
    private static final LongMap<MachPortCallback> portCallbacks = new LongMap();
    private static final Method cbPort;
    private static final Method cbInvalidate;
    private InvalidationCallback invalidationCallback;

    protected CFMachPort() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbPort(CFMachPort port, VoidPtr msg, @MachineSizedSInt long size, @Pointer long refcon) {
        MachPortCallback callback = null;
        LongMap<MachPortCallback> longMap = portCallbacks;
        synchronized (longMap) {
            callback = (MachPortCallback)portCallbacks.get(refcon);
        }
        callback.invoke(port, msg, size);
    }

    @Callback
    private void cbInvalidate(CFMachPort port, @Pointer long refcon) {
        if (this.invalidationCallback != null) {
            this.invalidationCallback.invalidate(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFMachPort create(MachPortCallback callback) {
        long refcon = refconId.getAndIncrement();
        CFMachPortContext context = new CFMachPortContext();
        context.setInfo(refcon);
        BooleanPtr ptr = new BooleanPtr();
        CFMachPort result = CFMachPort.create(null, new FunctionPtr(cbPort), context, ptr);
        if (result != null) {
            LongMap<MachPortCallback> longMap = portCallbacks;
            synchronized (longMap) {
                portCallbacks.put(refcon, (Object)callback);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFMachPort create(int portNum, MachPortCallback callback) {
        long refcon = refconId.getAndIncrement();
        CFMachPortContext context = new CFMachPortContext();
        context.setInfo(refcon);
        BooleanPtr ptr = new BooleanPtr();
        CFMachPort result = CFMachPort.create(null, portNum, new FunctionPtr(cbPort), context, ptr);
        if (result != null) {
            LongMap<MachPortCallback> longMap = portCallbacks;
            synchronized (longMap) {
                portCallbacks.put(refcon, (Object)callback);
            }
        }
        return result;
    }

    public InvalidationCallback getInvalidationCallBack() {
        return this.invalidationCallback;
    }

    public void setInvalidationCallBack(InvalidationCallback callback) {
        this.invalidationCallback = callback;
        if (callback == null) {
            this.setInvalidationCallBack0(null);
        } else {
            this.setInvalidationCallBack0(new FunctionPtr(cbInvalidate));
        }
    }

    public static CFRunLoopSource createRunLoopSource(CFMachPort port, @MachineSizedSInt long order) {
        return CFMachPort.createRunLoopSource(null, port, order);
    }

    @Bridge(symbol="CFMachPortGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFMachPortCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFMachPort create(CFAllocator var0, FunctionPtr var1, CFMachPortContext var2, BooleanPtr var3);

    @Bridge(symbol="CFMachPortCreateWithPort", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFMachPort create(CFAllocator var0, int var1, FunctionPtr var2, CFMachPortContext var3, BooleanPtr var4);

    @Bridge(symbol="CFMachPortGetPort", optional=true)
    public native int getPort();

    @Bridge(symbol="CFMachPortInvalidate", optional=true)
    public native void invalidate();

    @Bridge(symbol="CFMachPortIsValid", optional=true)
    public native boolean isValid();

    @Bridge(symbol="CFMachPortGetInvalidationCallBack", optional=true)
    private native FunctionPtr getInvalidationCallBack0();

    @Bridge(symbol="CFMachPortSetInvalidationCallBack", optional=true)
    private native void setInvalidationCallBack0(FunctionPtr var1);

    @Bridge(symbol="CFMachPortCreateRunLoopSource", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFRunLoopSource createRunLoopSource(CFAllocator var0, CFMachPort var1, @MachineSizedSInt long var2);

    static {
        try {
            cbPort = CFMachPort.class.getDeclaredMethod("cbPort", CFMachPort.class, VoidPtr.class, Long.TYPE, Long.TYPE);
            cbInvalidate = CFMachPort.class.getDeclaredMethod("cbInvalidate", CFMachPort.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CFMachPort.class);
    }

    public static class CFMachPortPtr
    extends Ptr<CFMachPort, CFMachPortPtr> {
    }

    public static interface InvalidationCallback {
        public void invalidate(CFMachPort var1);
    }

    public static interface MachPortCallback {
        public CFData invoke(CFMachPort var1, VoidPtr var2, long var3);
    }
}

