/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFData;
import org.robovm.apple.corefoundation.CFMessagePortContext;
import org.robovm.apple.corefoundation.CFMessagePortError;
import org.robovm.apple.corefoundation.CFMessagePortErrorCode;
import org.robovm.apple.corefoundation.CFRunLoopSource;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.dispatch.DispatchQueue;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.objc.LongMap;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
public class CFMessagePort
extends CFType {
    private static final AtomicLong refconId = new AtomicLong();
    private static final LongMap<MessagePortCallback> portCallbacks = new LongMap();
    private static final Method cbPort;
    private static final Method cbInvalidate;
    private InvalidationCallback invalidationCallback;

    protected CFMessagePort() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbPort(CFMessagePort port, @MachineSizedSInt long msgid, CFData data, @Pointer long refcon) {
        MessagePortCallback callback = null;
        LongMap<MessagePortCallback> longMap = portCallbacks;
        synchronized (longMap) {
            callback = (MessagePortCallback)portCallbacks.get(refcon);
        }
        callback.invoke(port, msgid, data);
    }

    @Callback
    private void cbInvalidate(CFMessagePort port, @Pointer long refcon) {
        if (this.invalidationCallback != null) {
            this.invalidationCallback.invalidate(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFMessagePort createLocal(String name, MessagePortCallback callback) {
        long refcon = refconId.getAndIncrement();
        CFMessagePortContext context = new CFMessagePortContext();
        context.setInfo(refcon);
        BooleanPtr ptr = new BooleanPtr();
        CFMessagePort result = CFMessagePort.createLocal(null, name, new FunctionPtr(cbPort), context, ptr);
        if (result != null) {
            LongMap<MessagePortCallback> longMap = portCallbacks;
            synchronized (longMap) {
                portCallbacks.put(refcon, (Object)callback);
            }
        }
        return result;
    }

    public static CFMessagePort createRemote(String name) {
        return CFMessagePort.createRemote(null, name);
    }

    public InvalidationCallback getInvalidationCallBack() {
        return this.invalidationCallback;
    }

    public void setInvalidationCallBack(InvalidationCallback callback) {
        this.invalidationCallback = callback;
        if (callback == null) {
            this.setInvalidationCallBack0(null);
        } else {
            this.setInvalidationCallBack0(new FunctionPtr(cbInvalidate));
        }
    }

    public static CFRunLoopSource createRunLoopSource(CFMessagePort local, @MachineSizedSInt long order) {
        return CFMessagePort.createRunLoopSource(null, local, order);
    }

    public CFData sendRequest(int msgid, CFData data, double sendTimeout, double rcvTimeout, String replyMode) throws NSErrorException {
        CFData.CFDataPtr ptr = new CFData.CFDataPtr();
        CFMessagePortErrorCode err = this.sendRequest(msgid, data, sendTimeout, rcvTimeout, replyMode, ptr);
        if (err != CFMessagePortErrorCode.Success) {
            CFMessagePortError error = new CFMessagePortError(err);
            throw new NSErrorException(error);
        }
        return (CFData)ptr.get();
    }

    @Bridge(symbol="CFMessagePortGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFMessagePortCreateLocal", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFMessagePort createLocal(CFAllocator var0, String var1, FunctionPtr var2, CFMessagePortContext var3, BooleanPtr var4);

    @Bridge(symbol="CFMessagePortCreateRemote", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFMessagePort createRemote(CFAllocator var0, String var1);

    @Bridge(symbol="CFMessagePortIsRemote", optional=true)
    public native boolean isRemote();

    @Bridge(symbol="CFMessagePortGetName", optional=true)
    public native String getName();

    @Bridge(symbol="CFMessagePortSetName", optional=true)
    public native boolean setName(String var1);

    @Bridge(symbol="CFMessagePortInvalidate", optional=true)
    public native void invalidate();

    @Bridge(symbol="CFMessagePortIsValid", optional=true)
    public native boolean isValid();

    @Bridge(symbol="CFMessagePortGetInvalidationCallBack", optional=true)
    private native FunctionPtr getInvalidationCallBack0();

    @Bridge(symbol="CFMessagePortSetInvalidationCallBack", optional=true)
    private native void setInvalidationCallBack0(FunctionPtr var1);

    @Bridge(symbol="CFMessagePortSendRequest", optional=true)
    protected native CFMessagePortErrorCode sendRequest(int var1, CFData var2, double var3, double var5, String var7, CFData.CFDataPtr var8);

    @Bridge(symbol="CFMessagePortCreateRunLoopSource", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFRunLoopSource createRunLoopSource(CFAllocator var0, CFMessagePort var1, @MachineSizedSInt long var2);

    @Bridge(symbol="CFMessagePortSetDispatchQueue", optional=true)
    @WeaklyLinked
    public native void setDispatchQueue(DispatchQueue var1);

    static {
        try {
            cbPort = CFMessagePort.class.getDeclaredMethod("cbPort", CFMessagePort.class, Long.TYPE, CFData.class, Long.TYPE);
            cbInvalidate = CFMessagePort.class.getDeclaredMethod("cbInvalidate", CFMessagePort.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CFMessagePort.class);
    }

    public static class CFMessagePortPtr
    extends Ptr<CFMessagePort, CFMessagePortPtr> {
    }

    public static interface InvalidationCallback {
        public void invalidate(CFMessagePort var1);
    }

    public static interface MessagePortCallback {
        public CFData invoke(CFMessagePort var1, @MachineSizedSInt long var2, CFData var4);
    }
}

