/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coregraphics.CGContext;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coreimage.CIContextOptions;
import org.robovm.apple.coreimage.CIFilter;
import org.robovm.apple.coreimage.CIImage;
import org.robovm.apple.coreimage.CIImageRepresentationOptions;
import org.robovm.apple.coreimage.CIRenderDestination;
import org.robovm.apple.coreimage.CIRenderTask;
import org.robovm.apple.corevideo.CVPixelBuffer;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.imageio.CGImagePropertyOrientation;
import org.robovm.apple.iosurface.IOSurface;
import org.robovm.apple.metal.MTLCommandBuffer;
import org.robovm.apple.metal.MTLDevice;
import org.robovm.apple.metal.MTLTexture;
import org.robovm.apple.opengles.EAGLContext;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreImage")
@NativeClass
public class CIContext
extends NSObject {
    protected CIContext(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected CIContext(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public CIContext(CGContext cgctx, CIContextOptions options) {
        super(null, CIContext.create(cgctx, options));
        CIContext.retain(this.getHandle());
    }

    public CIContext(CIContextOptions options) {
        super(null, CIContext.create(options));
        CIContext.retain(this.getHandle());
    }

    public CIContext() {
        super(null, CIContext.create());
        CIContext.retain(this.getHandle());
    }

    @Deprecated
    public CIContext(EAGLContext eaglContext) {
        super(null, CIContext.create(eaglContext));
        CIContext.retain(this.getHandle());
    }

    @Deprecated
    public CIContext(EAGLContext eaglContext, CIContextOptions options) {
        super(null, CIContext.create(eaglContext, options));
        CIContext.retain(this.getHandle());
    }

    public CIContext(MTLDevice device) {
        super(null, CIContext.create(device));
        CIContext.retain(this.getHandle());
    }

    public CIContext(MTLDevice device, CIContextOptions options) {
        super(null, CIContext.create(device, options));
        CIContext.retain(this.getHandle());
    }

    @Property(selector="workingColorSpace")
    public native CGColorSpace getWorkingColorSpace();

    @Property(selector="workingFormat")
    public native int getWorkingFormat();

    @Method(selector="drawImage:inRect:fromRect:")
    public native void drawImage(CIImage var1, @ByVal CGRect var2, @ByVal CGRect var3);

    @Method(selector="createCGImage:fromRect:")
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    @WeaklyLinked
    public native CGImage createCGImage(CIImage var1, @ByVal CGRect var2);

    @Method(selector="createCGImage:fromRect:format:colorSpace:")
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    @WeaklyLinked
    public native CGImage createCGImage(CIImage var1, @ByVal CGRect var2, int var3, CGColorSpace var4);

    @Method(selector="createCGImage:fromRect:format:colorSpace:deferred:")
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    @WeaklyLinked
    public native CGImage createCGImage(CIImage var1, @ByVal CGRect var2, int var3, CGColorSpace var4, boolean var5);

    @Method(selector="render:toBitmap:rowBytes:bounds:format:colorSpace:")
    @WeaklyLinked
    public native void render(CIImage var1, VoidPtr var2, @MachineSizedSInt long var3, @ByVal CGRect var5, int var6, CGColorSpace var7);

    @Method(selector="render:toIOSurface:bounds:colorSpace:")
    @WeaklyLinked
    public native void render(CIImage var1, IOSurface var2, @ByVal CGRect var3, CGColorSpace var4);

    @Method(selector="render:toCVPixelBuffer:")
    @WeaklyLinked
    public native void render(CIImage var1, CVPixelBuffer var2);

    @Method(selector="render:toCVPixelBuffer:bounds:colorSpace:")
    @WeaklyLinked
    public native void render(CIImage var1, CVPixelBuffer var2, @ByVal CGRect var3, CGColorSpace var4);

    @Method(selector="render:toMTLTexture:commandBuffer:bounds:colorSpace:")
    @WeaklyLinked
    public native void render(CIImage var1, MTLTexture var2, MTLCommandBuffer var3, @ByVal CGRect var4, CGColorSpace var5);

    @Method(selector="clearCaches")
    public native void clearCaches();

    @Method(selector="inputImageMaximumSize")
    @ByVal
    public native CGSize getInputImageMaximumSize();

    @Method(selector="outputImageMaximumSize")
    @ByVal
    public native CGSize getOutputImageMaximumSize();

    @Method(selector="contextWithCGContext:options:")
    @Pointer
    protected static native long create(CGContext var0, CIContextOptions var1);

    @Method(selector="contextWithOptions:")
    @Pointer
    protected static native long create(CIContextOptions var0);

    @Method(selector="context")
    @Pointer
    protected static native long create();

    @Deprecated
    @Method(selector="contextWithEAGLContext:")
    @Pointer
    protected static native long create(EAGLContext var0);

    @Deprecated
    @Method(selector="contextWithEAGLContext:options:")
    @Pointer
    protected static native long create(EAGLContext var0, CIContextOptions var1);

    @Method(selector="contextWithMTLDevice:")
    @Pointer
    protected static native long create(MTLDevice var0);

    @Method(selector="contextWithMTLDevice:options:")
    @Pointer
    protected static native long create(MTLDevice var0, CIContextOptions var1);

    @Method(selector="TIFFRepresentationOfImage:format:colorSpace:options:")
    public native NSData tiffRepresentationOfImage(CIImage var1, int var2, CGColorSpace var3, CIImageRepresentationOptions var4);

    @Method(selector="JPEGRepresentationOfImage:colorSpace:options:")
    public native NSData jpegRepresentationOfImage(CIImage var1, CGColorSpace var2, CIImageRepresentationOptions var3);

    @Method(selector="HEIFRepresentationOfImage:format:colorSpace:options:")
    public native NSData HEIFRepresentationOfImage(CIImage var1, int var2, CGColorSpace var3, CIImageRepresentationOptions var4);

    @Method(selector="PNGRepresentationOfImage:format:colorSpace:options:")
    public native NSData PNGRepresentationOfImage(CIImage var1, int var2, CGColorSpace var3, CIImageRepresentationOptions var4);

    @Method(selector="writeTIFFRepresentationOfImage:toURL:format:colorSpace:options:error:")
    public native boolean writeTIFFRepresentationOfImage(CIImage var1, NSURL var2, int var3, CGColorSpace var4, CIImageRepresentationOptions var5, NSError.NSErrorPtr var6);

    @Method(selector="writePNGRepresentationOfImage:toURL:format:colorSpace:options:error:")
    public native boolean writePNGRepresentationOfImage(CIImage var1, NSURL var2, int var3, CGColorSpace var4, CIImageRepresentationOptions var5, NSError.NSErrorPtr var6);

    @Method(selector="writeJPEGRepresentationOfImage:toURL:colorSpace:options:error:")
    public native boolean writeJPEGRepresentationOfImage(CIImage var1, NSURL var2, CGColorSpace var3, CIImageRepresentationOptions var4, NSError.NSErrorPtr var5);

    @Method(selector="writeHEIFRepresentationOfImage:toURL:format:colorSpace:options:error:")
    public native boolean writeHEIFRepresentationOfImage(CIImage var1, NSURL var2, int var3, CGColorSpace var4, CIImageRepresentationOptions var5, NSError.NSErrorPtr var6);

    @Method(selector="depthBlurEffectFilterForImageURL:options:")
    public native CIFilter depthBlurEffectFilter(NSURL var1, NSDictionary<?, ?> var2);

    @Method(selector="depthBlurEffectFilterForImageData:options:")
    public native CIFilter depthBlurEffectFilter(NSData var1, NSDictionary<?, ?> var2);

    @Method(selector="depthBlurEffectFilterForImage:disparityImage:portraitEffectsMatte:orientation:options:")
    public native CIFilter depthBlurEffectFilter(CIImage var1, CIImage var2, CIImage var3, CGImagePropertyOrientation var4, NSDictionary<?, ?> var5);

    @Method(selector="startTaskToRender:fromRect:toDestination:atPoint:error:")
    public native CIRenderTask startTaskToRender(CIImage var1, @ByVal CGRect var2, CIRenderDestination var3, @ByVal CGPoint var4, NSError.NSErrorPtr var5);

    @Method(selector="startTaskToRender:toDestination:error:")
    public native CIRenderTask startTaskToRender(CIImage var1, CIRenderDestination var2, NSError.NSErrorPtr var3);

    @Method(selector="prepareRender:fromRect:toDestination:atPoint:error:")
    public native boolean prepareRender(CIImage var1, @ByVal CGRect var2, CIRenderDestination var3, @ByVal CGPoint var4, NSError.NSErrorPtr var5);

    @Method(selector="startTaskToClear:error:")
    public native CIRenderTask startTaskToClear(CIRenderDestination var1, NSError.NSErrorPtr var2);

    static {
        ObjCRuntime.bind(CIContext.class);
    }

    public static class CIContextPtr
    extends Ptr<CIContext, CIContextPtr> {
    }
}

