/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremedia;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coremedia.CMMetadataKeySpace;
import org.robovm.apple.foundation.GlobalValueEnumeration;
import org.robovm.apple.foundation.NSData;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreMedia")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@StronglyLinked
public class CMMetadataIdentifier
extends GlobalValueEnumeration<CFString> {
    public static final CMMetadataIdentifier QuickTimeMetadataLocation_ISO6709;
    public static final CMMetadataIdentifier QuickTimeMetadataDirection_Facing;
    public static final CMMetadataIdentifier QuickTimeMetadataPreferredAffineTransform;
    public static final CMMetadataIdentifier QuickTimeMetadataVideoOrientation;
    private static CMMetadataIdentifier[] values;

    CMMetadataIdentifier(String getterName) {
        super(Values.class, getterName);
    }

    public static CMMetadataIdentifier valueOf(CFString value) {
        for (CMMetadataIdentifier v : values) {
            if (!((CFString)v.value()).equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + CMMetadataIdentifier.class.getName());
    }

    public static String createIdentifier(CFType key, CMMetadataKeySpace keySpace) throws OSStatusException {
        if (keySpace == null) {
            throw new NullPointerException("keySpace");
        }
        return CMMetadataIdentifier.createIdentifier(key, ((CFString)keySpace.value()).toString());
    }

    public static String createIdentifier(CFType key, String keySpace) throws OSStatusException {
        CFString.CFStringPtr ptr = new CFString.CFStringPtr();
        OSStatus status = CMMetadataIdentifier.createIdentifier0(null, key, keySpace, ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            return ((CFString)ptr.get()).toString();
        }
        return null;
    }

    public static CFType createKey(CMMetadataIdentifier identifier) throws OSStatusException {
        if (identifier == null) {
            throw new NullPointerException("identifier");
        }
        return CMMetadataIdentifier.createKey(((CFString)identifier.value()).toString());
    }

    public static CFType createKey(String identifier) throws OSStatusException {
        CFType.CFTypePtr ptr = new CFType.CFTypePtr();
        OSStatus status = CMMetadataIdentifier.createKey0(null, identifier, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CFType)ptr.get();
    }

    public static NSData createKeyAsData(CMMetadataIdentifier identifier) throws OSStatusException {
        if (identifier == null) {
            throw new NullPointerException("identifier");
        }
        return CMMetadataIdentifier.createKeyAsData(((CFString)identifier.value()).toString());
    }

    public static NSData createKeyAsData(String identifier) throws OSStatusException {
        NSData.NSDataPtr ptr = new NSData.NSDataPtr();
        OSStatus status = CMMetadataIdentifier.createKeyAsData0(null, identifier, ptr);
        OSStatusException.throwIfNecessary(status);
        return (NSData)ptr.get();
    }

    public String createKeySpace(CMMetadataIdentifier identifier) throws OSStatusException {
        if (identifier == null) {
            throw new NullPointerException("identifier");
        }
        return this.createKeySpace(((CFString)identifier.value()).toString());
    }

    public String createKeySpace(String identifier) throws OSStatusException {
        CFString.CFStringPtr ptr = new CFString.CFStringPtr();
        OSStatus status = CMMetadataIdentifier.createKeySpace0(null, identifier, ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            return ((CFString)ptr.get()).toString();
        }
        return null;
    }

    @Bridge(symbol="CMMetadataCreateIdentifierForKeyAndKeySpace", optional=true)
    protected static native OSStatus createIdentifier0(CFAllocator var0, CFType var1, String var2, CFString.CFStringPtr var3);

    @Bridge(symbol="CMMetadataCreateKeyFromIdentifier", optional=true)
    protected static native OSStatus createKey0(CFAllocator var0, String var1, CFType.CFTypePtr var2);

    @Bridge(symbol="CMMetadataCreateKeyFromIdentifierAsCFData", optional=true)
    protected static native OSStatus createKeyAsData0(CFAllocator var0, String var1, NSData.NSDataPtr var2);

    @Bridge(symbol="CMMetadataCreateKeySpaceFromIdentifier", optional=true)
    protected static native OSStatus createKeySpace0(CFAllocator var0, String var1, CFString.CFStringPtr var2);

    static {
        Bro.bind(CMMetadataIdentifier.class);
        QuickTimeMetadataLocation_ISO6709 = new CMMetadataIdentifier("QuickTimeMetadataLocation_ISO6709");
        QuickTimeMetadataDirection_Facing = new CMMetadataIdentifier("QuickTimeMetadataDirection_Facing");
        QuickTimeMetadataPreferredAffineTransform = new CMMetadataIdentifier("QuickTimeMetadataPreferredAffineTransform");
        QuickTimeMetadataVideoOrientation = new CMMetadataIdentifier("QuickTimeMetadataVideoOrientation");
        values = new CMMetadataIdentifier[]{QuickTimeMetadataLocation_ISO6709, QuickTimeMetadataDirection_Facing, QuickTimeMetadataPreferredAffineTransform, QuickTimeMetadataVideoOrientation};
    }

    @Library(value="CoreMedia")
    @StronglyLinked
    public static class Values {
        @GlobalValue(symbol="kCMMetadataIdentifier_QuickTimeMetadataLocation_ISO6709", optional=true)
        public static native CFString QuickTimeMetadataLocation_ISO6709();

        @GlobalValue(symbol="kCMMetadataIdentifier_QuickTimeMetadataDirection_Facing", optional=true)
        public static native CFString QuickTimeMetadataDirection_Facing();

        @GlobalValue(symbol="kCMMetadataIdentifier_QuickTimeMetadataPreferredAffineTransform", optional=true)
        public static native CFString QuickTimeMetadataPreferredAffineTransform();

        @GlobalValue(symbol="kCMMetadataIdentifier_QuickTimeMetadataVideoOrientation", optional=true)
        public static native CFString QuickTimeMetadataVideoOrientation();

        static {
            Bro.bind(Values.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CMMetadataIdentifier> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CMMetadataIdentifier> list = new ArrayList<CMMetadataIdentifier>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(CMMetadataIdentifier.valueOf(o.get(i, CFString.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CMMetadataIdentifier> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CMMetadataIdentifier o : l) {
                ((CFArray)array).add((NativeObject)o.value());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CMMetadataIdentifier toObject(Class<CMMetadataIdentifier> cls, long handle, long flags) {
            CFString o = (CFString)CFType.Marshaler.toObject(CFString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return CMMetadataIdentifier.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(CMMetadataIdentifier o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative((CFType)o.value(), flags);
        }
    }
}

