/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremedia;

import java.util.List;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coremedia.CMBlockBuffer;
import org.robovm.apple.coremedia.CMFormatDescription;
import org.robovm.apple.coremedia.CMVideoCodecType;
import org.robovm.apple.coremedia.CMVideoDimensions;
import org.robovm.apple.coremedia.CMVideoFormatDescriptionExtension;
import org.robovm.apple.corevideo.CVImageBuffer;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.MachineSizedUIntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreMedia")
@WeaklyLinked
public class CMVideoFormatDescription
extends CMFormatDescription {
    public static CMVideoFormatDescription create(CMVideoCodecType codecType, int width, int height, CMVideoFormatDescriptionExtension extensions) throws OSStatusException {
        CMVideoFormatDescriptionPtr ptr = new CMVideoFormatDescriptionPtr();
        OSStatus status = CMVideoFormatDescription.create0(null, codecType, width, height, extensions, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMVideoFormatDescription)ptr.get();
    }

    @WeaklyLinked
    public static CMVideoFormatDescription create(CVImageBuffer imageBuffer) throws OSStatusException {
        CMVideoFormatDescriptionPtr ptr = new CMVideoFormatDescriptionPtr();
        OSStatus status = CMVideoFormatDescription.create0(null, imageBuffer, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMVideoFormatDescription)ptr.get();
    }

    public static CMVideoFormatDescription createFromBigEndianImageDescriptionData(BytePtr imageDescriptionData, @MachineSizedUInt long imageDescriptionSize, int imageDescriptionStringEncoding, String imageDescriptionFlavor) throws OSStatusException {
        CMVideoFormatDescriptionPtr ptr = new CMVideoFormatDescriptionPtr();
        OSStatus status = CMVideoFormatDescription.createFromBigEndianImageDescriptionData0(null, imageDescriptionData, imageDescriptionSize, imageDescriptionStringEncoding, imageDescriptionFlavor, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMVideoFormatDescription)ptr.get();
    }

    public static CMVideoFormatDescription createFromBigEndianImageDescriptionBlockBuffer(CMBlockBuffer imageDescriptionBlockBuffer, int imageDescriptionStringEncoding, String imageDescriptionFlavor) throws OSStatusException {
        CMVideoFormatDescriptionPtr ptr = new CMVideoFormatDescriptionPtr();
        OSStatus status = CMVideoFormatDescription.createFromBigEndianImageDescriptionBlockBuffer0(null, imageDescriptionBlockBuffer, imageDescriptionStringEncoding, imageDescriptionFlavor, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMVideoFormatDescription)ptr.get();
    }

    public static CMBlockBuffer copyAsBigEndianImageDescriptionBlockBuffer(CFAllocator allocator, CMVideoFormatDescription videoFormatDescription, int imageDescriptionStringEncoding, String imageDescriptionFlavor) throws OSStatusException {
        CMBlockBuffer.CMBlockBufferPtr ptr = new CMBlockBuffer.CMBlockBufferPtr();
        OSStatus status = CMVideoFormatDescription.copyAsBigEndianImageDescriptionBlockBuffer0(null, videoFormatDescription, imageDescriptionStringEncoding, imageDescriptionFlavor, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMBlockBuffer)ptr.get();
    }

    @GlobalValue(symbol="kCMFormatDescriptionFieldDetail_TemporalTopFirst", optional=true)
    public static native CFString FieldDetailTemporalTopFirst();

    @GlobalValue(symbol="kCMFormatDescriptionFieldDetail_TemporalBottomFirst", optional=true)
    public static native CFString FieldDetailTemporalBottomFirst();

    @GlobalValue(symbol="kCMFormatDescriptionFieldDetail_SpatialFirstLineEarly", optional=true)
    public static native CFString FieldDetailSpatialFirstLineEarly();

    @GlobalValue(symbol="kCMFormatDescriptionFieldDetail_SpatialFirstLineLate", optional=true)
    public static native CFString FieldDetailSpatialFirstLineLate();

    @GlobalValue(symbol="kCMFormatDescriptionColorPrimaries_ITU_R_709_2", optional=true)
    public static native CFString ColorPrimaries_ITU_R_709_2();

    @GlobalValue(symbol="kCMFormatDescriptionColorPrimaries_EBU_3213", optional=true)
    public static native CFString ColorPrimaries_EBU_3213();

    @GlobalValue(symbol="kCMFormatDescriptionColorPrimaries_SMPTE_C", optional=true)
    public static native CFString ColorPrimaries_SMPTE_C();

    @GlobalValue(symbol="kCMFormatDescriptionColorPrimaries_DCI_P3", optional=true)
    public static native CFString ColorPrimaries_DCI_P3();

    @GlobalValue(symbol="kCMFormatDescriptionColorPrimaries_P3_D65", optional=true)
    public static native CFString ColorPrimaries_P3_D65();

    @GlobalValue(symbol="kCMFormatDescriptionColorPrimaries_ITU_R_2020", optional=true)
    public static native CFString ColorPrimaries_ITU_R_2020();

    @GlobalValue(symbol="kCMFormatDescriptionColorPrimaries_P22", optional=true)
    public static native CFString ColorPrimaries_P22();

    @GlobalValue(symbol="kCMFormatDescriptionTransferFunction_ITU_R_709_2", optional=true)
    public static native CFString TransferFunction_ITU_R_709_2();

    @GlobalValue(symbol="kCMFormatDescriptionTransferFunction_SMPTE_240M_1995", optional=true)
    public static native CFString TransferFunction_SMPTE_240M_1995();

    @GlobalValue(symbol="kCMFormatDescriptionTransferFunction_UseGamma", optional=true)
    public static native CFString TransferFunction_UseGamma();

    @GlobalValue(symbol="kCMFormatDescriptionTransferFunction_ITU_R_2020", optional=true)
    public static native CFString TransferFunction_ITU_R_2020();

    @GlobalValue(symbol="kCMFormatDescriptionTransferFunction_SMPTE_ST_428_1", optional=true)
    public static native CFString TransferFunction_SMPTE_ST_428_1();

    @GlobalValue(symbol="kCMFormatDescriptionTransferFunction_SMPTE_ST_2084_PQ", optional=true)
    public static native CFString TransferFunction_SMPTE_ST_2084_PQ();

    @GlobalValue(symbol="kCMFormatDescriptionTransferFunction_ITU_R_2100_HLG", optional=true)
    public static native CFString TransferFunction_ITU_R_2100_HLG();

    @GlobalValue(symbol="kCMFormatDescriptionTransferFunction_Linear", optional=true)
    public static native CFString TransferFunction_Linear();

    @GlobalValue(symbol="kCMFormatDescriptionYCbCrMatrix_ITU_R_709_2", optional=true)
    public static native CFString YCbCrMatrix_ITU_R_709_2();

    @GlobalValue(symbol="kCMFormatDescriptionYCbCrMatrix_ITU_R_601_4", optional=true)
    public static native CFString YCbCrMatrix_ITU_R_601_4();

    @GlobalValue(symbol="kCMFormatDescriptionYCbCrMatrix_SMPTE_240M_1995", optional=true)
    public static native CFString YCbCrMatrix_SMPTE_240M_1995();

    @GlobalValue(symbol="kCMFormatDescriptionYCbCrMatrix_ITU_R_2020", optional=true)
    public static native CFString YCbCrMatrix_ITU_R_2020();

    @GlobalValue(symbol="kCMFormatDescriptionChromaLocation_Left", optional=true)
    public static native CFString ChromaLocationLeft();

    @GlobalValue(symbol="kCMFormatDescriptionChromaLocation_Center", optional=true)
    public static native CFString ChromaLocationCenter();

    @GlobalValue(symbol="kCMFormatDescriptionChromaLocation_TopLeft", optional=true)
    public static native CFString ChromaLocationTopLeft();

    @GlobalValue(symbol="kCMFormatDescriptionChromaLocation_Top", optional=true)
    public static native CFString ChromaLocationTop();

    @GlobalValue(symbol="kCMFormatDescriptionChromaLocation_BottomLeft", optional=true)
    public static native CFString ChromaLocationBottomLeft();

    @GlobalValue(symbol="kCMFormatDescriptionChromaLocation_Bottom", optional=true)
    public static native CFString ChromaLocationBottom();

    @GlobalValue(symbol="kCMFormatDescriptionChromaLocation_DV420", optional=true)
    public static native CFString ChromaLocationDV420();

    @GlobalValue(symbol="kCMSampleBufferLensStabilizationInfo_Active", optional=true)
    public static native CFString LensStabilizationInfoActive();

    @GlobalValue(symbol="kCMSampleBufferLensStabilizationInfo_OutOfRange", optional=true)
    public static native CFString LensStabilizationInfoOutOfRange();

    @GlobalValue(symbol="kCMSampleBufferLensStabilizationInfo_Unavailable", optional=true)
    public static native CFString LensStabilizationInfoUnavailable();

    @GlobalValue(symbol="kCMSampleBufferLensStabilizationInfo_Off", optional=true)
    public static native CFString LensStabilizationInfoOff();

    @Bridge(symbol="CMVideoFormatDescriptionCreate", optional=true)
    private static native OSStatus create0(CFAllocator var0, CMVideoCodecType var1, int var2, int var3, CMVideoFormatDescriptionExtension var4, CMVideoFormatDescriptionPtr var5);

    @Bridge(symbol="CMVideoFormatDescriptionCreateForImageBuffer", optional=true)
    private static native OSStatus create0(CFAllocator var0, CVImageBuffer var1, CMVideoFormatDescriptionPtr var2);

    @Bridge(symbol="CMVideoFormatDescriptionCreateFromHEVCParameterSets", optional=true)
    private static native OSStatus create0(CFAllocator var0, @MachineSizedUInt long var1, BytePtr.BytePtrPtr var3, MachineSizedUIntPtr var4, int var5, CMVideoFormatDescriptionExtension var6, CMFormatDescription.CMFormatDescriptionPtr var7);

    @Bridge(symbol="CMVideoFormatDescriptionGetHEVCParameterSetAtIndex", optional=true)
    public static native OSStatus getHEVCParameterSetAtIndex(CMFormatDescription var0, @MachineSizedUInt long var1, BytePtr.BytePtrPtr var3, MachineSizedUIntPtr var4, MachineSizedUIntPtr var5, IntPtr var6);

    @Bridge(symbol="CMVideoFormatDescriptionGetDimensions", optional=true)
    @ByVal
    public native CMVideoDimensions getDimensions();

    @Bridge(symbol="CMVideoFormatDescriptionGetPresentationDimensions", optional=true)
    @ByVal
    @WeaklyLinked
    public native CGSize getPresentationDimensions(boolean var1, boolean var2);

    @Bridge(symbol="CMVideoFormatDescriptionGetCleanAperture", optional=true)
    @ByVal
    @WeaklyLinked
    public native CGRect getCleanAperture(boolean var1);

    @Bridge(symbol="CMVideoFormatDescriptionGetExtensionKeysCommonWithImageBuffers", optional=true)
    @Marshaler(value=CFArray.AsStringListMarshaler.class)
    public static native List<String> getExtensionKeysCommonWithImageBuffers();

    @Bridge(symbol="CMVideoFormatDescriptionMatchesImageBuffer", optional=true)
    public native boolean matchesImageBuffer(CVImageBuffer var1);

    @Bridge(symbol="CMVideoFormatDescriptionCreateFromBigEndianImageDescriptionData", optional=true)
    private static native OSStatus createFromBigEndianImageDescriptionData0(CFAllocator var0, BytePtr var1, @MachineSizedUInt long var2, int var4, String var5, CMVideoFormatDescriptionPtr var6);

    @Bridge(symbol="CMVideoFormatDescriptionCreateFromBigEndianImageDescriptionBlockBuffer", optional=true)
    private static native OSStatus createFromBigEndianImageDescriptionBlockBuffer0(CFAllocator var0, CMBlockBuffer var1, int var2, String var3, CMVideoFormatDescriptionPtr var4);

    @Bridge(symbol="CMVideoFormatDescriptionCopyAsBigEndianImageDescriptionBlockBuffer", optional=true)
    private static native OSStatus copyAsBigEndianImageDescriptionBlockBuffer0(CFAllocator var0, CMVideoFormatDescription var1, int var2, String var3, CMBlockBuffer.CMBlockBufferPtr var4);

    static {
        Bro.bind(CMVideoFormatDescription.class);
    }

    public static class CMVideoFormatDescriptionPtr
    extends Ptr<CMVideoFormatDescription, CMVideoFormatDescriptionPtr> {
    }
}

