/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreml;

import org.robovm.apple.coreml.MLFeatureType;
import org.robovm.apple.coreml.MLMultiArray;
import org.robovm.apple.coreml.MLSequence;
import org.robovm.apple.corevideo.CVPixelBuffer;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreML")
@NativeClass
public class MLFeatureValue
extends NSObject {
    public MLFeatureValue() {
    }

    protected MLFeatureValue(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MLFeatureValue(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public MLFeatureValue(long value) {
        super(null, MLFeatureValue.create(value));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(double value) {
        super(null, MLFeatureValue.create(value));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(String value) {
        super(null, MLFeatureValue.create(value));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(MLMultiArray value) {
        super(null, MLFeatureValue.create(value));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(CVPixelBuffer value) {
        super(null, MLFeatureValue.create(value));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(MLSequence sequence) {
        super(null, MLFeatureValue.create(sequence));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(MLFeatureType type) {
        super(null, MLFeatureValue.create(type));
        MLFeatureValue.retain(this.getHandle());
    }

    public MLFeatureValue(NSDictionary<?, NSNumber> value) throws NSErrorException {
        this(value, new NSError.NSErrorPtr());
    }

    private MLFeatureValue(NSDictionary<?, NSNumber> value, NSError.NSErrorPtr ptr) throws NSErrorException {
        super(null, MLFeatureValue.create(value, ptr));
        MLFeatureValue.retain(this.getHandle());
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
    }

    @Property(selector="type")
    public native MLFeatureType getType();

    @Property(selector="isUndefined")
    public native boolean isUndefined();

    @Property(selector="int64Value")
    public native long getInt64Value();

    @Property(selector="doubleValue")
    public native double getDoubleValue();

    @Property(selector="stringValue")
    public native String getStringValue();

    @Property(selector="multiArrayValue")
    public native MLMultiArray getMultiArrayValue();

    @Property(selector="dictionaryValue")
    public native NSDictionary<?, NSNumber> getDictionaryValue();

    @Property(selector="imageBufferValue")
    public native CVPixelBuffer getImageBufferValue();

    @Property(selector="sequenceValue")
    public native MLSequence getSequenceValue();

    @Method(selector="isEqualToFeatureValue:")
    public native boolean isEqualToFeatureValue(MLFeatureValue var1);

    @Method(selector="featureValueWithInt64:")
    @Pointer
    protected static native long create(long var0);

    @Method(selector="featureValueWithDouble:")
    @Pointer
    protected static native long create(double var0);

    @Method(selector="featureValueWithString:")
    @Pointer
    protected static native long create(String var0);

    @Method(selector="featureValueWithMultiArray:")
    @Pointer
    protected static native long create(MLMultiArray var0);

    @Method(selector="featureValueWithPixelBuffer:")
    @Pointer
    protected static native long create(CVPixelBuffer var0);

    @Method(selector="featureValueWithSequence:")
    @Pointer
    protected static native long create(MLSequence var0);

    @Method(selector="undefinedFeatureValueWithType:")
    @Pointer
    protected static native long create(MLFeatureType var0);

    @Method(selector="featureValueWithDictionary:error:")
    @Pointer
    protected static native long create(NSDictionary<?, NSNumber> var0, NSError.NSErrorPtr var1);

    static {
        ObjCRuntime.bind(MLFeatureValue.class);
    }

    public static class MLFeatureValuePtr
    extends Ptr<MLFeatureValue, MLFeatureValuePtr> {
    }
}

