/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corevideo;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.corevideo.CVBufferAttributes;
import org.robovm.apple.corevideo.CVImageBufferAttribute;
import org.robovm.apple.corevideo.CVImageBufferChromaLocation;
import org.robovm.apple.corevideo.CVImageBufferChromaSubsampling;
import org.robovm.apple.corevideo.CVImageBufferCleanAperture;
import org.robovm.apple.corevideo.CVImageBufferColorPrimaries;
import org.robovm.apple.corevideo.CVImageBufferDisplayDimensions;
import org.robovm.apple.corevideo.CVImageBufferFieldDetail;
import org.robovm.apple.corevideo.CVImageBufferPixelAspectRatio;
import org.robovm.apple.corevideo.CVImageBufferTransferFunction;
import org.robovm.apple.corevideo.CVImageBufferYCbCrMatrix;
import org.robovm.apple.foundation.NSData;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreVideo")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CVImageBufferAttributes
extends CVBufferAttributes {
    CVImageBufferAttributes(CFDictionary data) {
        super(data);
    }

    public CVImageBufferAttributes() {
    }

    public boolean has(CVImageBufferAttribute key) {
        return this.data.containsKey((NativeObject)key.value());
    }

    public <T extends NativeObject> T get(CVImageBufferAttribute key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get((NativeObject)key.value(), type);
        }
        return null;
    }

    public CVImageBufferAttributes set(CVImageBufferAttribute key, NativeObject value) {
        this.data.put((NativeObject)key.value(), value);
        return this;
    }

    public CGColorSpace getCGColorSpace() {
        if (this.has(CVImageBufferAttribute.CGColorSpace)) {
            CGColorSpace val = this.get(CVImageBufferAttribute.CGColorSpace, CGColorSpace.class);
            return val;
        }
        return null;
    }

    public CVImageBufferAttributes setCGColorSpace(CGColorSpace cGColorSpace) {
        this.set(CVImageBufferAttribute.CGColorSpace, (NativeObject)cGColorSpace);
        return this;
    }

    public CVImageBufferCleanAperture getCleanAperture() {
        if (this.has(CVImageBufferAttribute.CleanAperture)) {
            CFDictionary val = this.get(CVImageBufferAttribute.CleanAperture, CFDictionary.class);
            return new CVImageBufferCleanAperture(val);
        }
        return null;
    }

    public CVImageBufferAttributes setCleanAperture(CVImageBufferCleanAperture cleanAperture) {
        this.set(CVImageBufferAttribute.CleanAperture, (NativeObject)cleanAperture.getDictionary());
        return this;
    }

    public CVImageBufferCleanAperture getPreferredCleanAperture() {
        if (this.has(CVImageBufferAttribute.PreferredCleanAperture)) {
            CFDictionary val = this.get(CVImageBufferAttribute.PreferredCleanAperture, CFDictionary.class);
            return new CVImageBufferCleanAperture(val);
        }
        return null;
    }

    public CVImageBufferAttributes setPreferredCleanAperture(CVImageBufferCleanAperture preferredCleanAperture) {
        this.set(CVImageBufferAttribute.PreferredCleanAperture, (NativeObject)preferredCleanAperture.getDictionary());
        return this;
    }

    public int getFieldCount() {
        if (this.has(CVImageBufferAttribute.FieldCount)) {
            CFNumber val = this.get(CVImageBufferAttribute.FieldCount, CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public CVImageBufferAttributes setFieldCount(int fieldCount) {
        this.set(CVImageBufferAttribute.FieldCount, (NativeObject)CFNumber.valueOf(fieldCount));
        return this;
    }

    public CVImageBufferFieldDetail getFieldDetail() {
        if (this.has(CVImageBufferAttribute.FieldDetail)) {
            CFString val = this.get(CVImageBufferAttribute.FieldDetail, CFString.class);
            return CVImageBufferFieldDetail.valueOf(val);
        }
        return null;
    }

    public CVImageBufferAttributes setFieldDetail(CVImageBufferFieldDetail fieldDetail) {
        this.set(CVImageBufferAttribute.FieldDetail, (NativeObject)fieldDetail.value());
        return this;
    }

    public CVImageBufferPixelAspectRatio getPixelAspectRatio() {
        if (this.has(CVImageBufferAttribute.PixelAspectRatio)) {
            CFDictionary val = this.get(CVImageBufferAttribute.PixelAspectRatio, CFDictionary.class);
            return new CVImageBufferPixelAspectRatio(val);
        }
        return null;
    }

    public CVImageBufferAttributes setPixelAspectRatio(CVImageBufferPixelAspectRatio pixelAspectRatio) {
        this.set(CVImageBufferAttribute.PixelAspectRatio, (NativeObject)pixelAspectRatio.getDictionary());
        return this;
    }

    public CVImageBufferDisplayDimensions getDisplayDimensions() {
        if (this.has(CVImageBufferAttribute.DisplayDimensions)) {
            CFDictionary val = this.get(CVImageBufferAttribute.DisplayDimensions, CFDictionary.class);
            return new CVImageBufferDisplayDimensions(val);
        }
        return null;
    }

    public CVImageBufferAttributes setDisplayDimensions(CVImageBufferDisplayDimensions displayDimensions) {
        this.set(CVImageBufferAttribute.DisplayDimensions, (NativeObject)displayDimensions.getDictionary());
        return this;
    }

    public double getGammaLevel() {
        if (this.has(CVImageBufferAttribute.GammaLevel)) {
            CFNumber val = this.get(CVImageBufferAttribute.GammaLevel, CFNumber.class);
            return val.doubleValue();
        }
        return 0.0;
    }

    public CVImageBufferAttributes setGammaLevel(double gammaLevel) {
        this.set(CVImageBufferAttribute.GammaLevel, (NativeObject)CFNumber.valueOf(gammaLevel));
        return this;
    }

    public NSData getICCProfile() {
        if (this.has(CVImageBufferAttribute.ICCProfile)) {
            NSData val = this.get(CVImageBufferAttribute.ICCProfile, NSData.class);
            return val;
        }
        return null;
    }

    public CVImageBufferAttributes setICCProfile(NSData iCCProfile) {
        this.set(CVImageBufferAttribute.ICCProfile, (NativeObject)iCCProfile);
        return this;
    }

    public CVImageBufferYCbCrMatrix getYCbCrMatrix() {
        if (this.has(CVImageBufferAttribute.YCbCrMatrix)) {
            CFString val = this.get(CVImageBufferAttribute.YCbCrMatrix, CFString.class);
            return CVImageBufferYCbCrMatrix.valueOf(val);
        }
        return null;
    }

    public CVImageBufferAttributes setYCbCrMatrix(CVImageBufferYCbCrMatrix yCbCrMatrix) {
        this.set(CVImageBufferAttribute.YCbCrMatrix, (NativeObject)yCbCrMatrix.value());
        return this;
    }

    public CVImageBufferColorPrimaries getColorPrimaries() {
        if (this.has(CVImageBufferAttribute.ColorPrimaries)) {
            CFString val = this.get(CVImageBufferAttribute.ColorPrimaries, CFString.class);
            return CVImageBufferColorPrimaries.valueOf(val);
        }
        return null;
    }

    public CVImageBufferAttributes setColorPrimaries(CVImageBufferColorPrimaries colorPrimaries) {
        this.set(CVImageBufferAttribute.ColorPrimaries, (NativeObject)colorPrimaries.value());
        return this;
    }

    public CVImageBufferTransferFunction getTransferFunction() {
        if (this.has(CVImageBufferAttribute.TransferFunction)) {
            CFString val = this.get(CVImageBufferAttribute.TransferFunction, CFString.class);
            return CVImageBufferTransferFunction.valueOf(val);
        }
        return null;
    }

    public CVImageBufferAttributes setTransferFunction(CVImageBufferTransferFunction transferFunction) {
        this.set(CVImageBufferAttribute.TransferFunction, (NativeObject)transferFunction.value());
        return this;
    }

    public CVImageBufferChromaLocation getChromaLocationTopField() {
        if (this.has(CVImageBufferAttribute.ChromaLocationTopField)) {
            CFString val = this.get(CVImageBufferAttribute.ChromaLocationTopField, CFString.class);
            return CVImageBufferChromaLocation.valueOf(val);
        }
        return null;
    }

    public CVImageBufferAttributes setChromaLocationTopField(CVImageBufferChromaLocation chromaLocationTopField) {
        this.set(CVImageBufferAttribute.ChromaLocationTopField, (NativeObject)chromaLocationTopField.value());
        return this;
    }

    public CVImageBufferChromaLocation getChromaLocationBottomField() {
        if (this.has(CVImageBufferAttribute.ChromaLocationBottomField)) {
            CFString val = this.get(CVImageBufferAttribute.ChromaLocationBottomField, CFString.class);
            return CVImageBufferChromaLocation.valueOf(val);
        }
        return null;
    }

    public CVImageBufferAttributes setChromaLocationBottomField(CVImageBufferChromaLocation chromaLocationBottomField) {
        this.set(CVImageBufferAttribute.ChromaLocationBottomField, (NativeObject)chromaLocationBottomField.value());
        return this;
    }

    public CVImageBufferChromaSubsampling getChromaSubsampling() {
        if (this.has(CVImageBufferAttribute.ChromaSubsampling)) {
            CFString val = this.get(CVImageBufferAttribute.ChromaSubsampling, CFString.class);
            return CVImageBufferChromaSubsampling.valueOf(val);
        }
        return null;
    }

    public CVImageBufferAttributes setChromaSubsampling(CVImageBufferChromaSubsampling chromaSubsampling) {
        this.set(CVImageBufferAttribute.ChromaSubsampling, (NativeObject)chromaSubsampling.value());
        return this;
    }

    public boolean isAlphaChannelOpaque() {
        if (this.has(CVImageBufferAttribute.AlphaChannelIsOpaque)) {
            CFBoolean val = this.get(CVImageBufferAttribute.AlphaChannelIsOpaque, CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVImageBufferAttributes setAlphaChannelOpaque(boolean alphaChannelOpaque) {
        this.set(CVImageBufferAttribute.AlphaChannelIsOpaque, (NativeObject)CFBoolean.valueOf(alphaChannelOpaque));
        return this;
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CVImageBufferAttributes> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CVImageBufferAttributes> list = new ArrayList<CVImageBufferAttributes>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CVImageBufferAttributes(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CVImageBufferAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CVImageBufferAttributes i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CVImageBufferAttributes toObject(Class<CVImageBufferAttributes> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CVImageBufferAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(CVImageBufferAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

