/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCalendarIdentifier;
import org.robovm.apple.foundation.NSCalendarOptions;
import org.robovm.apple.foundation.NSCalendarUnit;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSDateComponents;
import org.robovm.apple.foundation.NSLocale;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSTimeZone;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSCalendar
extends NSObject
implements NSSecureCoding {
    protected NSCalendar() {
    }

    protected NSCalendar(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSCalendar(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithCalendarIdentifier:")
    public NSCalendar(NSCalendarIdentifier ident) {
        super(null);
        this.initObject(this.init(ident));
    }

    @Method(selector="initWithCoder:")
    public NSCalendar(NSCoder decoder) {
        super(null);
        this.initObject(this.init(decoder));
    }

    @Property(selector="currentCalendar")
    public static native NSCalendar getCurrentCalendar();

    @Property(selector="autoupdatingCurrentCalendar")
    public static native NSCalendar getAutoupdatingCurrentCalendar();

    @Property(selector="calendarIdentifier")
    public native NSCalendarIdentifier getCalendarIdentifier();

    @Property(selector="locale")
    public native NSLocale getLocale();

    @Property(selector="setLocale:")
    public native void setLocale(NSLocale var1);

    @Property(selector="timeZone")
    public native NSTimeZone getTimeZone();

    @Property(selector="setTimeZone:")
    public native void setTimeZone(NSTimeZone var1);

    @Property(selector="firstWeekday")
    @MachineSizedUInt
    public native long getFirstWeekday();

    @Property(selector="setFirstWeekday:")
    public native void setFirstWeekday(@MachineSizedUInt long var1);

    @Property(selector="minimumDaysInFirstWeek")
    @MachineSizedUInt
    public native long getMinimumDaysInFirstWeek();

    @Property(selector="setMinimumDaysInFirstWeek:")
    public native void setMinimumDaysInFirstWeek(@MachineSizedUInt long var1);

    @Property(selector="eraSymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getEraSymbols();

    @Property(selector="longEraSymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getLongEraSymbols();

    @Property(selector="monthSymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getMonthSymbols();

    @Property(selector="shortMonthSymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getShortMonthSymbols();

    @Property(selector="veryShortMonthSymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getVeryShortMonthSymbols();

    @Property(selector="standaloneMonthSymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getStandaloneMonthSymbols();

    @Property(selector="shortStandaloneMonthSymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getShortStandaloneMonthSymbols();

    @Property(selector="veryShortStandaloneMonthSymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getVeryShortStandaloneMonthSymbols();

    @Property(selector="weekdaySymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getWeekdaySymbols();

    @Property(selector="shortWeekdaySymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getShortWeekdaySymbols();

    @Property(selector="veryShortWeekdaySymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getVeryShortWeekdaySymbols();

    @Property(selector="standaloneWeekdaySymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getStandaloneWeekdaySymbols();

    @Property(selector="shortStandaloneWeekdaySymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getShortStandaloneWeekdaySymbols();

    @Property(selector="veryShortStandaloneWeekdaySymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getVeryShortStandaloneWeekdaySymbols();

    @Property(selector="quarterSymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getQuarterSymbols();

    @Property(selector="shortQuarterSymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getShortQuarterSymbols();

    @Property(selector="standaloneQuarterSymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getStandaloneQuarterSymbols();

    @Property(selector="shortStandaloneQuarterSymbols")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getShortStandaloneQuarterSymbols();

    @Property(selector="AMSymbol")
    public native String getAMSymbol();

    @Property(selector="PMSymbol")
    public native String getPMSymbol();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    public NSDate getStartTime(NSCalendarUnit unit, NSDate date) {
        NSDate.NSDatePtr ptr = new NSDate.NSDatePtr();
        if (this.getRange(unit, ptr, new DoublePtr(), date)) {
            return (NSDate)ptr.get();
        }
        return null;
    }

    public double getDuration(NSCalendarUnit unit, NSDate date) {
        DoublePtr ptr = new DoublePtr();
        if (this.getRange(unit, new NSDate.NSDatePtr(), ptr, date)) {
            return ptr.get();
        }
        return 0.0;
    }

    @GlobalValue(symbol="NSCalendarDayChangedNotification", optional=true)
    public static native NSString DayChangedNotification();

    @Method(selector="initWithCalendarIdentifier:")
    @Pointer
    protected native long init(NSCalendarIdentifier var1);

    @Method(selector="minimumRangeOfUnit:")
    @ByVal
    public native NSRange getMinimumRange(NSCalendarUnit var1);

    @Method(selector="maximumRangeOfUnit:")
    @ByVal
    public native NSRange getMaximumRange(NSCalendarUnit var1);

    @Method(selector="rangeOfUnit:inUnit:forDate:")
    @ByVal
    public native NSRange getRange(NSCalendarUnit var1, NSCalendarUnit var2, NSDate var3);

    @Method(selector="ordinalityOfUnit:inUnit:forDate:")
    @MachineSizedUInt
    public native long getOrdinality(NSCalendarUnit var1, NSCalendarUnit var2, NSDate var3);

    @Method(selector="rangeOfUnit:startDate:interval:forDate:")
    protected native boolean getRange(NSCalendarUnit var1, NSDate.NSDatePtr var2, DoublePtr var3, NSDate var4);

    @Method(selector="dateFromComponents:")
    public native NSDate newDateFromComponents(NSDateComponents var1);

    @Method(selector="components:fromDate:")
    public native NSDateComponents getComponents(NSCalendarUnit var1, NSDate var2);

    @Method(selector="dateByAddingComponents:toDate:options:")
    public native NSDate newDateByAddingComponents(NSDateComponents var1, NSDate var2, NSCalendarOptions var3);

    @Method(selector="components:fromDate:toDate:options:")
    public native NSDateComponents getComponents(NSCalendarUnit var1, NSDate var2, NSDate var3, NSCalendarOptions var4);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        ObjCRuntime.bind(NSCalendar.class);
    }

    public static class NSCalendarPtr
    extends Ptr<NSCalendar, NSCalendarPtr> {
    }

    public static class Notifications {
        public static NSObject observeDayChanged(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSCalendar.DayChangedNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

