/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSExtensions;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSMutableOrderedSet;
import org.robovm.apple.foundation.NSMutableSet;
import org.robovm.apple.foundation.NSObject;
import org.robovm.objc.annotation.Method;
import org.robovm.rt.bro.annotation.Marshaler;

public class NSKeyValueCoder
extends NSExtensions {
    private NSObject object;

    public NSKeyValueCoder(NSObject object) {
        this.object = object;
    }

    public NSObject getValue(String keyPath) {
        return NSKeyValueCoder.getValueForKeyPath(this.object, keyPath);
    }

    @Method(selector="valueForKeyPath:")
    private static native NSObject getValueForKeyPath(NSObject var0, String var1);

    public void setValue(String keyPath, NSObject value) {
        NSKeyValueCoder.setValueForKeyPath(this.object, value, keyPath);
    }

    @Method(selector="setValue:forKeyPath:")
    private static native void setValueForKeyPath(NSObject var0, NSObject var1, String var2);

    public boolean validateValue(String keyPath, NSObject value) throws NSErrorException {
        NSError.NSErrorPtr err = new NSError.NSErrorPtr();
        boolean result = NSKeyValueCoder.validateValueForKeyPath(this.object, value, keyPath, err);
        if (err.get() != null) {
            throw new NSErrorException((NSError)err.get());
        }
        return result;
    }

    @Method(selector="validateValue:forKeyPath:error:")
    private static native boolean validateValueForKeyPath(NSObject var0, NSObject var1, String var2, NSError.NSErrorPtr var3);

    public NSMutableArray<?> getMutableArrayValue(String keyPath) {
        return NSKeyValueCoder.getMutableArrayValueForKeyPath(this.object, keyPath);
    }

    @Method(selector="mutableArrayValueForKeyPath:")
    private static native NSMutableArray<?> getMutableArrayValueForKeyPath(NSObject var0, String var1);

    public NSMutableSet<?> getMutableSetValue(String keyPath) {
        return NSKeyValueCoder.getMutableSetValueForKeyPath(this.object, keyPath);
    }

    @Method(selector="mutableSetValueForKeyPath:")
    private static native NSMutableSet<?> getMutableSetValueForKeyPath(NSObject var0, String var1);

    public NSMutableOrderedSet<?> getMutableOrderedSetValue(String keyPath) {
        return NSKeyValueCoder.getMutableOrderedSetValueForKeyPath(this.object, keyPath);
    }

    @Method(selector="mutableOrderedSetValueForKeyPath:")
    private static native NSMutableOrderedSet<?> getMutableOrderedSetValueForKeyPath(NSObject var0, String var1);

    public NSObject getValueForUndefinedKey(String key) {
        return NSKeyValueCoder.getValueForUndefinedKey(this.object, key);
    }

    @Method(selector="valueForUndefinedKey:")
    private static native NSObject getValueForUndefinedKey(NSObject var0, String var1);

    public void setValueForUndefinedKey(String key, NSObject value) {
        NSKeyValueCoder.setValueForUndefinedKey(this.object, value, key);
    }

    @Method(selector="setValue:forUndefinedKey:")
    private static native void setValueForUndefinedKey(NSObject var0, NSObject var1, String var2);

    public void setNullValue(String key) {
        NSKeyValueCoder.setNullValueForKey(this.object, key);
    }

    @Method(selector="setNilValueForKey:")
    private static native void setNullValueForKey(NSObject var0, String var1);

    public Map<String, NSObject> getValues(String ... keys) {
        return this.getValues(Arrays.asList(keys));
    }

    public Map<String, NSObject> getValues(List<String> keys) {
        return NSKeyValueCoder.getDictionaryWithValuesForKeys(this.object, keys);
    }

    @Method(selector="dictionaryWithValuesForKeys:")
    @Marshaler(value=NSDictionary.AsStringMapMarshaler.class)
    private static native Map<String, NSObject> getDictionaryWithValuesForKeys(NSObject var0, @Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    public void setValues(Map<String, NSObject> values) {
        NSKeyValueCoder.setValuesForKeys(this.object, values);
    }

    @Method(selector="setValuesForKeysWithDictionary:")
    private static native void setValuesForKeys(NSObject var0, @Marshaler(value=NSDictionary.AsStringMapMarshaler.class) Map<String, NSObject> var1);

    @Method(selector="valueForKey:")
    private static native NSObject getValueForKey(NSObject var0, String var1);

    @Method(selector="setValue:forKey:")
    private static native void setValueForKey(NSObject var0, NSObject var1, String var2);

    @Method(selector="validateValue:forKey:error:")
    private static native boolean validateValueForKey(NSObject var0, NSObject var1, String var2, NSError.NSErrorPtr var3);

    @Method(selector="mutableArrayValueForKey:")
    private static native NSMutableArray<?> getMutableArrayValueForKey(NSObject var0, String var1);

    @Method(selector="mutableOrderedSetValueForKey:")
    private static native NSMutableOrderedSet<?> getMutableOrderedSetValueForKey(NSObject var0, String var1);

    @Method(selector="mutableSetValueForKey:")
    private static native NSMutableSet<?> getMutableSetValueForKey(NSObject var0, String var1);
}

