/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSEnumerator;
import org.robovm.apple.foundation.NSFastEnumeration;
import org.robovm.apple.foundation.NSMapTableOptions;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSMapTable<K extends NSObject, V extends NSObject>
extends NSObject
implements NSSecureCoding,
NSFastEnumeration,
Map<K, V> {
    public NSMapTable() {
    }

    protected NSMapTable(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSMapTable(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithKeyOptions:valueOptions:capacity:")
    public NSMapTable(NSMapTableOptions keyOptions, NSMapTableOptions valueOptions, @MachineSizedUInt long initialCapacity) {
        super(null);
        this.initObject(this.init(keyOptions, valueOptions, initialCapacity));
    }

    @Method(selector="initWithCoder:")
    public NSMapTable(NSCoder decoder) {
        super(null);
        this.initObject(this.init(decoder));
    }

    @Property(selector="count")
    @MachineSizedUInt
    protected native long getCount();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    private static void checkNull(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException("null keys or values are not allowed in NSMapTable. Use NSNull instead.");
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (!(value instanceof NSObject)) {
            return false;
        }
        NSArray<V> values = this.getObjectEnumerator().getAllObjects();
        int count = (int)values.getCount();
        for (int i = 0; i < count; ++i) {
            V o = values.getObjectAt(i);
            if (!((NSObject)o).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(this);
    }

    @Override
    public V get(Object key) {
        if (!(key instanceof NSObject)) {
            return null;
        }
        return (V)this.getObject((NSObject)key);
    }

    @Override
    public boolean isEmpty() {
        return this.getCount() == 0L;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet(this);
    }

    @Override
    public int size() {
        return (int)this.getCount();
    }

    @Override
    public Collection<V> values() {
        return this.getObjectEnumerator().getAllObjects();
    }

    @Override
    public void clear() {
        this.removeAllObjects();
    }

    @Override
    public V remove(Object key) {
        if (!(key instanceof NSObject)) {
            return null;
        }
        Object oldValue = this.get(key);
        this.removeObject((NSObject)key);
        return (V)oldValue;
    }

    @Override
    public V put(K key, V value) {
        NSMapTable.checkNull(key, value);
        Object oldValue = this.get(key);
        this.setObject((NSObject)value, (NSObject)key);
        return (V)oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put((K)((NSObject)entry.getKey()), (V)((NSObject)entry.getValue()));
        }
    }

    public NSMapTable(Map<K, V> m) {
        this.putAll(m);
    }

    public NSMapTable(Map<K, V> m, NSMapTableOptions keyOptions, NSMapTableOptions valueOptions, @MachineSizedUInt long initialCapacity) {
        super(null);
        this.initObject(this.init(keyOptions, valueOptions, initialCapacity));
        this.putAll(m);
    }

    @Method(selector="initWithKeyOptions:valueOptions:capacity:")
    @Pointer
    protected native long init(NSMapTableOptions var1, NSMapTableOptions var2, @MachineSizedUInt long var3);

    @Method(selector="objectForKey:")
    protected native NSObject getObject(NSObject var1);

    @Method(selector="removeObjectForKey:")
    protected native void removeObject(NSObject var1);

    @Method(selector="setObject:forKey:")
    protected native void setObject(NSObject var1, NSObject var2);

    @Method(selector="keyEnumerator")
    protected native NSEnumerator<K> getKeyEnumerator();

    @Method(selector="objectEnumerator")
    protected native NSEnumerator<V> getObjectEnumerator();

    @Method(selector="removeAllObjects")
    protected native void removeAllObjects();

    @Method(selector="dictionaryRepresentation")
    public native NSDictionary<K, V> asDictionary();

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        ObjCRuntime.bind(NSMapTable.class);
    }

    static class EntrySet<K extends NSObject, V extends NSObject>
    extends AbstractSet<Map.Entry<K, V>> {
        private final NSMapTable<K, V> map;

        EntrySet(NSMapTable<K, V> map) {
            this.map = map;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator<K> keysIt = this.map.keySet().iterator();
            return new Iterator<Map.Entry<K, V>>(){
                private Map.Entry<K, V> entry = null;

                @Override
                public boolean hasNext() {
                    return keysIt.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    NSObject key = (NSObject)keysIt.next();
                    Object value = EntrySet.this.map.get(key);
                    if (value == null) {
                        throw new ConcurrentModificationException();
                    }
                    this.entry = new Entry<NSObject, Object>(EntrySet.this.map, key, value);
                    return this.entry;
                }

                @Override
                public void remove() {
                    if (this.entry == null) {
                        throw new IllegalStateException();
                    }
                    Object value = EntrySet.this.map.get(this.entry.getKey());
                    if (this.entry.getValue() != value) {
                        throw new ConcurrentModificationException();
                    }
                    keysIt.remove();
                    this.entry = null;
                }
            };
        }

        @Override
        public int size() {
            return (int)this.map.getCount();
        }
    }

    static class Entry<K extends NSObject, V extends NSObject>
    implements Map.Entry<K, V> {
        private final NSMapTable<K, V> map;
        private final K key;
        private final V value;

        Entry(NSMapTable<K, V> map, K key, V value) {
            this.map = map;
            this.key = key;
            this.value = value;
        }

        @Override
        public V setValue(V v) {
            if (this.value != this.map.get(this.key)) {
                throw new ConcurrentModificationException();
            }
            return this.map.put(this.key, v);
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return (this.key == null ? entry.getKey() == null : ((NSObject)this.key).equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : ((NSObject)this.value).equals(entry.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((NSObject)this.key).hashCode() ^ ((NSObject)this.value).hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    static class KeySet<K extends NSObject>
    extends AbstractSet<K> {
        private final NSMapTable<K, ? extends NSObject> map;

        KeySet(NSMapTable<K, ? extends NSObject> map) {
            this.map = map;
        }

        @Override
        public Iterator<K> iterator() {
            return new NSEnumerator.Iterator<K>(this.map.getKeyEnumerator()){

                @Override
                void remove(int index, K o) {
                    KeySet.this.map.removeObject((NSObject)o);
                }
            };
        }

        @Override
        public int size() {
            return (int)this.map.getCount();
        }
    }

    public static class NSMapTablePtr<K extends NSObject, V extends NSObject>
    extends Ptr<NSMapTable<K, V>, NSMapTablePtr<K, V>> {
    }
}

