/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.io.File;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSNull;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSMutableArray<T extends NSObject>
extends NSArray<T> {
    public NSMutableArray() {
    }

    protected NSMutableArray(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSMutableArray(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithCapacity:")
    public NSMutableArray(@MachineSizedUInt long numItems) {
        super((NSObject.SkipInit)null);
        this.initObject(this.init(numItems));
    }

    public NSMutableArray(Collection<T> c) {
        super(c);
    }

    public NSMutableArray(T ... objects) {
        super(objects);
    }

    @Override
    protected AbstractList<T> createAdapter() {
        return new ListAdapter(this);
    }

    private void checkIndex(int index) {
        int size = (int)this.getCount();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("index = " + index + ", size = " + size);
        }
    }

    @Override
    public boolean add(boolean value) {
        return this.add0(NSNumber.valueOf(value));
    }

    @Override
    public void add(int index, boolean value) {
        this.add0(index, NSNumber.valueOf(value));
    }

    @Override
    public boolean add(Number value) {
        return this.add0(NSNumber.valueOf(value));
    }

    @Override
    public void add(int index, Number value) {
        this.add0(index, NSNumber.valueOf(value));
    }

    @Override
    public boolean add(String value) {
        return this.add0(value != null ? new NSString(value) : null);
    }

    @Override
    public void add(int index, String value) {
        this.add0(index, value != null ? new NSString(value) : null);
    }

    private boolean add0(NSObject element) {
        this.add0(this.size(), element);
        return true;
    }

    private void add0(int index, NSObject element) {
        NSMutableArray.checkNull(element);
        if (index < 0 || (long)index > this.getCount()) {
            this.checkIndex(index);
        }
        if (element == null) {
            element = NSNull.getNull();
        }
        this.insertObject(element, index);
    }

    @Override
    public Object set(int index, boolean element) {
        NSMutableArray.checkNull(element);
        this.checkIndex(index);
        Object old = this.getObjectAt(index);
        this.replaceObject(index, NSNumber.valueOf(element));
        if (old instanceof NSNumber) {
            old = ((NSNumber)old).booleanValue();
        }
        return old;
    }

    @Override
    public Object set(int index, Number element) {
        return this.set0(index, NSNumber.valueOf(element));
    }

    @Override
    public Object set(int index, String element) {
        return this.set0(index, new NSString(element));
    }

    private Object set0(int index, NSObject element) {
        NSMutableArray.checkNull(element);
        this.checkIndex(index);
        Object old = this.getObjectAt(index);
        this.replaceObject(index, element);
        if (old instanceof NSString) {
            old = old.toString();
        } else if (old instanceof NSNumber) {
            old = ((NSNumber)old).doubleValue();
        }
        return old;
    }

    @Override
    public boolean remove(boolean element) {
        return this.remove(NSNumber.valueOf(element));
    }

    @Override
    public boolean remove(Number element) {
        return this.remove(NSNumber.valueOf(element));
    }

    @Override
    public boolean remove(String element) {
        return this.remove(new NSString(element));
    }

    public static NSMutableArray<NSString> fromStrings(String ... strings) {
        int length = strings.length;
        NSObject[] nsStrings = new NSString[length];
        for (int i = 0; i < length; ++i) {
            nsStrings[i] = new NSString(strings[i]);
        }
        return new NSMutableArray(nsStrings);
    }

    public static NSMutableArray<NSString> fromStrings(List<String> strings) {
        int size = strings.size();
        NSObject[] nsStrings = new NSString[size];
        for (int i = 0; i < size; ++i) {
            nsStrings[i] = new NSString(strings.get(i));
        }
        return new NSMutableArray(nsStrings);
    }

    public static NSArray<?> read(File file) {
        return NSMutableArray.read(file.getAbsolutePath());
    }

    @Method(selector="arrayWithContentsOfFile:")
    protected static native NSArray<? extends NSObject> read(String var0);

    @Method(selector="arrayWithContentsOfURL:")
    public static native NSArray<? extends NSObject> read(NSURL var0);

    @Method(selector="insertObject:atIndex:")
    protected native void insertObject(NSObject var1, @MachineSizedUInt long var2);

    @Method(selector="removeObjectAtIndex:")
    protected native void removeObject(@MachineSizedUInt long var1);

    @Method(selector="replaceObjectAtIndex:withObject:")
    protected native void replaceObject(@MachineSizedUInt long var1, NSObject var3);

    @Method(selector="initWithCapacity:")
    @Pointer
    protected native long init(@MachineSizedUInt long var1);

    @Method(selector="removeAllObjects")
    protected native void removeAllObjects();

    static {
        ObjCRuntime.bind(NSMutableArray.class);
    }

    static class ListAdapter<U extends NSObject>
    extends NSArray.ListAdapter<U> {
        ListAdapter(NSArray<U> array) {
            super(array);
        }

        @Override
        public void clear() {
            ((NSMutableArray)this.array).removeAllObjects();
        }

        @Override
        public U set(int index, U element) {
            NSArray.checkNull(element);
            this.checkIndex(index);
            Object old = this.array.getObjectAt(index);
            ((NSMutableArray)this.array).replaceObject(index, (NSObject)element);
            return (U)old;
        }

        @Override
        public void add(int index, U element) {
            NSArray.checkNull(element);
            if (index < 0 || (long)index > this.array.getCount()) {
                this.checkIndex(index);
            }
            ((NSMutableArray)this.array).insertObject((NSObject)element, index);
        }

        @Override
        public U remove(int index) {
            this.checkIndex(index);
            Object old = this.array.getObjectAt(index);
            ((NSMutableArray)this.array).removeObject(index);
            return (U)old;
        }
    }

    public static class NSMutableArrayPtr<T extends NSObject>
    extends Ptr<NSMutableArrayPtr<T>, NSMutableArrayPtr<T>> {
    }
}

