/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import org.robovm.apple.foundation.NSEnumerator;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSet;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSMutableSet<T extends NSObject>
extends NSSet<T> {
    public NSMutableSet() {
    }

    protected NSMutableSet(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSMutableSet(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithCapacity:")
    public NSMutableSet(@MachineSizedUInt long numItems) {
        super((NSObject.SkipInit)null);
        this.initObject(this.init(numItems));
    }

    public NSMutableSet(Collection<T> c) {
        super(c);
    }

    public NSMutableSet(T ... objects) {
        super(objects);
    }

    @Override
    protected AbstractSet<T> createAdapter() {
        return new SetAdapter(this);
    }

    @Method(selector="addObject:")
    protected native void addObject(NSObject var1);

    @Method(selector="removeObject:")
    protected native void removeObject(NSObject var1);

    @Method(selector="initWithCapacity:")
    @Pointer
    protected native long init(@MachineSizedUInt long var1);

    @Method(selector="removeAllObjects")
    protected native void removeAllObjects();

    static {
        ObjCRuntime.bind(NSMutableSet.class);
    }

    static class SetAdapter<U extends NSObject>
    extends NSSet.SetAdapter<U> {
        SetAdapter(NSSet<U> set) {
            super(set);
        }

        @Override
        public Iterator<U> iterator() {
            return new NSEnumerator.Iterator<U>(this.set.objectEnumerator()){

                @Override
                void remove(int index, U o) {
                    ((NSMutableSet)SetAdapter.this.set).removeObject((NSObject)o);
                }
            };
        }

        @Override
        public boolean add(U e) {
            NSSet.checkNull(e);
            boolean replaced = this.contains(e);
            ((NSMutableSet)this.set).addObject((NSObject)e);
            return replaced;
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                ((NSMutableSet)this.set).removeObject((NSObject)o);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            ((NSMutableSet)this.set).removeAllObjects();
        }
    }

    public static class NSMutableSetPtr<T extends NSObject>
    extends Ptr<NSMutableSet<T>, NSMutableSetPtr<T>> {
    }
}

