/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSEnumerator;
import org.robovm.apple.foundation.NSFastEnumeration;
import org.robovm.apple.foundation.NSIndexSet;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.foundation.NSSet;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="Foundation")
@NativeClass
public class NSOrderedSet<T extends NSObject>
extends NSObject
implements NSFastEnumeration,
Set<T>,
List<T> {
    private AbstractSet<T> setAdapter = this.createSetAdapter();
    private AbstractList<T> listAdapter = this.createListAdapter();

    public NSOrderedSet() {
    }

    protected NSOrderedSet(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSOrderedSet(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSOrderedSet(Collection<T> c) {
        super(null);
        if (c instanceof NSArray) {
            this.initObject(this.init((NSArray)c));
        } else if (c instanceof NSSet) {
            this.initObject(this.init((NSOrderedSet)c));
        } else {
            NSObject[] objects = c.toArray(new NSObject[c.size()]);
            this.initWithObjects(objects);
        }
    }

    public NSOrderedSet(T ... objects) {
        super(null);
        this.initWithObjects((NSObject[])objects);
    }

    @Property(selector="count")
    @MachineSizedUInt
    protected native long getCount();

    @Override
    @Property(selector="firstObject")
    public native T getFirst();

    @Override
    @Property(selector="lastObject")
    public native T getLast();

    @Property(selector="reversedOrderedSet")
    public native NSOrderedSet<T> getReversedOrderedSet();

    @Property(selector="array")
    public native NSArray<T> getArray();

    @Property(selector="set")
    public native NSSet<T> getSet();

    protected static void checkNull(Object o) {
        if (o == null) {
            throw new NullPointerException("null values are not allowed in NSOrderedSet. Use NSNull instead.");
        }
    }

    private void initWithObjects(NSObject[] objects) {
        VoidPtr.VoidPtrPtr ptr = (VoidPtr.VoidPtrPtr)Struct.allocate(VoidPtr.VoidPtrPtr.class, (int)objects.length);
        for (int i = 0; i < objects.length; ++i) {
            NSOrderedSet.checkNull(objects[i]);
            ptr.set(objects[i].getHandle());
            ptr = (VoidPtr.VoidPtrPtr)ptr.next();
        }
        ptr = (VoidPtr.VoidPtrPtr)ptr.previous((long)objects.length);
        this.initObject(this.init(ptr.getHandle(), objects.length));
    }

    protected AbstractSet<T> createSetAdapter() {
        return new SetAdapter(this);
    }

    protected AbstractList<T> createListAdapter() {
        return new ListAdapter(this);
    }

    @Override
    protected void afterMarshaled(int flags) {
        if (this.setAdapter == null) {
            this.setAdapter = this.createSetAdapter();
        }
        if (this.listAdapter == null) {
            this.listAdapter = this.createListAdapter();
        }
        super.afterMarshaled(flags);
    }

    @Override
    public boolean remove(Object o) {
        return this.setAdapter.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.setAdapter.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.setAdapter.retainAll(c);
    }

    @Override
    public void add(int index, T element) {
        this.listAdapter.add(index, element);
    }

    @Override
    public boolean add(T e) {
        return this.listAdapter.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.listAdapter.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.listAdapter.addAll(index, c);
    }

    @Override
    public void clear() {
        this.listAdapter.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.setAdapter.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.setAdapter.containsAll(c);
    }

    @Override
    public T get(int index) {
        return (T)((NSObject)this.listAdapter.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.listAdapter.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.listAdapter.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.listAdapter.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.listAdapter.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listAdapter.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.listAdapter.listIterator(index);
    }

    @Override
    public T remove(int index) {
        return (T)((NSObject)this.listAdapter.remove(index));
    }

    @Override
    public T set(int index, T element) {
        return (T)((NSObject)this.listAdapter.set(index, element));
    }

    @Override
    public int size() {
        return this.listAdapter.size();
    }

    @Override
    public NSOrderedSet<T> subList(int start, int end) {
        if (start >= 0 && end <= this.size()) {
            if (start <= end) {
                return new NSOrderedSet<T>(this.getObjectsAt(new NSIndexSet(new NSRange(start, end - start))));
            }
            throw new IllegalArgumentException();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object[] toArray() {
        return this.listAdapter.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.listAdapter.toArray(a);
    }

    @Method(selector="objectAtIndex:")
    protected native T getObjectAt(@MachineSizedUInt long var1);

    @Method(selector="indexOfObject:")
    @MachineSizedUInt
    protected native long indexOfObject(NSObject var1);

    @Method(selector="initWithObjects:count:")
    @Pointer
    protected native long init(@Pointer long var1, @MachineSizedUInt long var3);

    @Method(selector="objectsAtIndexes:")
    protected native NSArray<T> getObjectsAt(NSIndexSet var1);

    @Method(selector="containsObject:")
    protected native boolean containsObject(NSObject var1);

    @Method(selector="objectEnumerator")
    protected native NSEnumerator<T> objectEnumerator();

    @Method(selector="initWithOrderedSet:")
    @Pointer
    protected native long init(NSOrderedSet<?> var1);

    @Method(selector="initWithArray:")
    @Pointer
    protected native long init(NSArray<?> var1);

    static {
        ObjCRuntime.bind(NSOrderedSet.class);
    }

    static class ListAdapter<U extends NSObject>
    extends AbstractList<U> {
        protected final NSOrderedSet<U> set;

        ListAdapter(NSOrderedSet<U> array) {
            this.set = array;
        }

        @Override
        public U get(int index) {
            this.checkIndex(index);
            return this.set.getObjectAt(index);
        }

        protected void checkIndex(int index) {
            int size = (int)this.set.getCount();
            if (index < 0 || index >= size) {
                throw new IndexOutOfBoundsException("index = " + index + ", size = " + size);
            }
        }

        @Override
        public int size() {
            return (int)this.set.getCount();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof NSObject) {
                return this.set.containsObject((NSObject)o);
            }
            return false;
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof NSObject) {
                return (int)this.set.indexOfObject((NSObject)o);
            }
            return -1;
        }
    }

    static class SetAdapter<U extends NSObject>
    extends AbstractSet<U> {
        protected final NSOrderedSet<U> set;

        SetAdapter(NSOrderedSet<U> set) {
            this.set = set;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof NSObject) {
                return this.set.containsObject((NSObject)o);
            }
            return false;
        }

        @Override
        public Iterator<U> iterator() {
            return new NSEnumerator.Iterator<U>(this.set.objectEnumerator());
        }

        @Override
        public int size() {
            return (int)this.set.getCount();
        }
    }

    public static class NSOrderedSetPtr<T extends NSObject>
    extends Ptr<NSOrderedSet<T>, NSOrderedSetPtr<T>> {
    }
}

