/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.foundation.NSURLFileProperty;
import org.robovm.apple.foundation.NSURLFileResourceType;
import org.robovm.apple.foundation.NSURLFileSystemProperty;
import org.robovm.apple.foundation.NSURLThumbnail;
import org.robovm.apple.foundation.NSURLUbiquitousItemDownloadingStatus;
import org.robovm.apple.foundation.NSURLUbiquitousItemProperty;
import org.robovm.apple.foundation.NSURLVolumeProperty;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="Foundation")
public class NSURLProperties {
    private NSDictionary<NSString, NSObject> data;

    protected NSURLProperties(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSURLProperties() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public NSObject get(String property) {
        return this.data.get(new NSString(property));
    }

    public NSObject get(NSURLFileSystemProperty property) {
        return this.data.get(property.value());
    }

    public NSObject get(NSURLFileProperty property) {
        return this.data.get(property.value());
    }

    public NSObject get(NSURLVolumeProperty property) {
        return this.data.get(property.value());
    }

    public NSObject get(NSURLUbiquitousItemProperty property) {
        return this.data.get(property.value());
    }

    public boolean contains(String property) {
        return this.data.containsKey(new NSString(property));
    }

    public boolean contains(NSURLFileSystemProperty property) {
        return this.data.containsKey(property.value());
    }

    public boolean contains(NSURLFileProperty property) {
        return this.data.containsKey(property.value());
    }

    public boolean contains(NSURLVolumeProperty property) {
        return this.data.containsKey(property.value());
    }

    public boolean contains(NSURLUbiquitousItemProperty property) {
        return this.data.containsKey(property.value());
    }

    public NSURLProperties put(String property, NSObject value) {
        this.data.put(new NSString(property), value);
        return this;
    }

    public NSURLProperties put(NSURLFileSystemProperty property, NSObject value) {
        this.data.put((NSString)((NSObject)property.value()), value);
        return this;
    }

    public NSURLProperties put(NSURLFileProperty property, NSObject value) {
        this.data.put((NSString)((NSObject)property.value()), value);
        return this;
    }

    public NSURLProperties put(NSURLVolumeProperty property, NSObject value) {
        this.data.put((NSString)((NSObject)property.value()), value);
        return this;
    }

    public NSURLProperties put(NSURLUbiquitousItemProperty property, NSObject value) {
        this.data.put((NSString)((NSObject)property.value()), value);
        return this;
    }

    public String getName() {
        if (this.contains(NSURLFileSystemProperty.Name)) {
            NSString val = (NSString)this.get(NSURLFileSystemProperty.Name);
            return val.toString();
        }
        return null;
    }

    public NSURLProperties setName(String name) {
        this.put(NSURLFileSystemProperty.Name, (NSObject)new NSString(name));
        return this;
    }

    public String getLocalizedName() {
        if (this.contains(NSURLFileSystemProperty.LocalizedName)) {
            NSString val = (NSString)this.get(NSURLFileSystemProperty.LocalizedName);
            return val.toString();
        }
        return null;
    }

    public boolean isRegularFile() {
        if (this.contains(NSURLFileSystemProperty.IsRegularFile)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.IsRegularFile);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isDirectory() {
        if (this.contains(NSURLFileSystemProperty.IsDirectory)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.IsDirectory);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isSymbolicLink() {
        if (this.contains(NSURLFileSystemProperty.IsSymbolicLink)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.IsSymbolicLink);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isVolume() {
        if (this.contains(NSURLFileSystemProperty.IsVolume)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.IsVolume);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isPackage() {
        if (this.contains(NSURLFileSystemProperty.IsPackage)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.IsPackage);
            return val.booleanValue();
        }
        return false;
    }

    public NSURLProperties setPackage(boolean isPackage) {
        this.put(NSURLFileSystemProperty.IsPackage, (NSObject)NSNumber.valueOf(isPackage));
        return this;
    }

    public boolean isSystemImmutable() {
        if (this.contains(NSURLFileSystemProperty.IsSystemImmutable)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.IsSystemImmutable);
            return val.booleanValue();
        }
        return false;
    }

    public NSURLProperties setSystemImmutable(boolean immutable) {
        this.put(NSURLFileSystemProperty.IsSystemImmutable, (NSObject)NSNumber.valueOf(immutable));
        return this;
    }

    public boolean isUserImmutable() {
        if (this.contains(NSURLFileSystemProperty.IsUserImmutable)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.IsUserImmutable);
            return val.booleanValue();
        }
        return false;
    }

    public NSURLProperties setUserImmutable(boolean immutable) {
        this.put(NSURLFileSystemProperty.IsUserImmutable, (NSObject)NSNumber.valueOf(immutable));
        return this;
    }

    public boolean isHidden() {
        if (this.contains(NSURLFileSystemProperty.IsHidden)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.IsHidden);
            return val.booleanValue();
        }
        return false;
    }

    public NSURLProperties setHidden(boolean hidden) {
        this.put(NSURLFileSystemProperty.IsHidden, (NSObject)NSNumber.valueOf(hidden));
        return this;
    }

    public boolean hasHiddenExtension() {
        if (this.contains(NSURLFileSystemProperty.HasHiddenExtension)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.HasHiddenExtension);
            return val.booleanValue();
        }
        return false;
    }

    public NSURLProperties setHasHiddenExtension(boolean hiddenExtension) {
        this.put(NSURLFileSystemProperty.HasHiddenExtension, (NSObject)NSNumber.valueOf(hiddenExtension));
        return this;
    }

    public NSDate getCreationDate() {
        if (this.contains(NSURLFileSystemProperty.CreationDate)) {
            NSDate val = (NSDate)this.get(NSURLFileSystemProperty.CreationDate);
            return val;
        }
        return null;
    }

    public NSURLProperties setCreationDate(NSDate date) {
        this.put(NSURLFileSystemProperty.CreationDate, (NSObject)date);
        return this;
    }

    public NSDate getContentAccessDate() {
        if (this.contains(NSURLFileSystemProperty.ContentAccessDate)) {
            NSDate val = (NSDate)this.get(NSURLFileSystemProperty.ContentAccessDate);
            return val;
        }
        return null;
    }

    public NSDate getContentModificationDate() {
        if (this.contains(NSURLFileSystemProperty.ContentModificationDate)) {
            NSDate val = (NSDate)this.get(NSURLFileSystemProperty.ContentModificationDate);
            return val;
        }
        return null;
    }

    public NSURLProperties setContentModificationDate(NSDate date) {
        this.put(NSURLFileSystemProperty.ContentModificationDate, (NSObject)date);
        return this;
    }

    public NSDate getAttributeModificationDate() {
        if (this.contains(NSURLFileSystemProperty.AttributeModificationDate)) {
            NSDate val = (NSDate)this.get(NSURLFileSystemProperty.AttributeModificationDate);
            return val;
        }
        return null;
    }

    public NSURLProperties setAtttributeModificationDate(NSDate date) {
        this.put(NSURLFileSystemProperty.AttributeModificationDate, (NSObject)date);
        return this;
    }

    public long getLinkCount() {
        if (this.contains(NSURLFileSystemProperty.LinkCount)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.LinkCount);
            return val.longValue();
        }
        return 0L;
    }

    public NSURL getParentDirectoryURL() {
        if (this.contains(NSURLFileSystemProperty.ParentDirectoryURL)) {
            NSURL val = (NSURL)this.get(NSURLFileSystemProperty.ParentDirectoryURL);
            return val;
        }
        return null;
    }

    public NSURL getVolumeURL() {
        if (this.contains(NSURLFileSystemProperty.VolumeURL)) {
            NSURL val = (NSURL)this.get(NSURLFileSystemProperty.VolumeURL);
            return val;
        }
        return null;
    }

    public String getTypeIdentifier() {
        if (this.contains(NSURLFileSystemProperty.TypeIdentifier)) {
            NSString val = (NSString)this.get(NSURLFileSystemProperty.TypeIdentifier);
            return val.toString();
        }
        return null;
    }

    public String getLocalizedTypeDescription() {
        if (this.contains(NSURLFileSystemProperty.LocalizedTypeDescription)) {
            NSString val = (NSString)this.get(NSURLFileSystemProperty.LocalizedTypeDescription);
            return val.toString();
        }
        return null;
    }

    public long getLabelNumber() {
        if (this.contains(NSURLFileSystemProperty.LabelNumber)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.LabelNumber);
            return val.longValue();
        }
        return 0L;
    }

    public NSObject getFileResourceIdentifier() {
        if (this.contains(NSURLFileSystemProperty.FileResourceIdentifier)) {
            NSObject val = this.get(NSURLFileSystemProperty.FileResourceIdentifier);
            return val;
        }
        return null;
    }

    public NSObject getVolumeIdentifier() {
        if (this.contains(NSURLFileSystemProperty.VolumeIdentifier)) {
            NSObject val = this.get(NSURLFileSystemProperty.VolumeIdentifier);
            return val;
        }
        return null;
    }

    public boolean isReadable() {
        if (this.contains(NSURLFileSystemProperty.IsReadable)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.IsReadable);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isWritable() {
        if (this.contains(NSURLFileSystemProperty.IsWritable)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.IsWritable);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isExecutable() {
        if (this.contains(NSURLFileSystemProperty.IsExecutable)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.IsExecutable);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isExcludedFromBackup() {
        if (this.contains(NSURLFileSystemProperty.IsExcludedFromBackup)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.IsExcludedFromBackup);
            return val.booleanValue();
        }
        return false;
    }

    public NSURLProperties setExcludedFromBackground(boolean excludeFromBackground) {
        this.put(NSURLFileSystemProperty.IsExcludedFromBackup, (NSObject)NSNumber.valueOf(excludeFromBackground));
        return this;
    }

    public String getPath() {
        if (this.contains(NSURLFileSystemProperty.Path)) {
            NSString val = (NSString)this.get(NSURLFileSystemProperty.Path);
            return val.toString();
        }
        return null;
    }

    public boolean isMountTrigger() {
        if (this.contains(NSURLFileSystemProperty.IsMountTrigger)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.IsMountTrigger);
            return val.booleanValue();
        }
        return false;
    }

    public NSObject getGenerationIdentifier() {
        if (this.contains(NSURLFileSystemProperty.GenerationIdentifier)) {
            NSObject val = this.get(NSURLFileSystemProperty.GenerationIdentifier);
            return val;
        }
        return null;
    }

    public long getDocumentIdentifier() {
        if (this.contains(NSURLFileSystemProperty.DocumentIdentifier)) {
            NSNumber val = (NSNumber)this.get(NSURLFileSystemProperty.DocumentIdentifier);
            return val.longValue();
        }
        return 0L;
    }

    public NSDate getAddedToDirectoryDate() {
        if (this.contains(NSURLFileSystemProperty.AddedToDirectoryDate)) {
            NSDate val = (NSDate)this.get(NSURLFileSystemProperty.AddedToDirectoryDate);
            return val;
        }
        return null;
    }

    public NSURLFileResourceType getFileResourceType() {
        if (this.contains(NSURLFileSystemProperty.FileResourceType)) {
            NSString val = (NSString)this.get(NSURLFileSystemProperty.FileResourceType);
            return NSURLFileResourceType.valueOf(val);
        }
        return null;
    }

    public NSURLThumbnail getThumbnail() {
        if (this.contains(NSURLFileSystemProperty.ThumbnailDictionary)) {
            NSDictionary val = (NSDictionary)this.get(NSURLFileSystemProperty.ThumbnailDictionary);
            return new NSURLThumbnail(val);
        }
        return null;
    }

    public long getFileSize() {
        if (this.contains(NSURLFileProperty.FileSize)) {
            NSNumber val = (NSNumber)this.get(NSURLFileProperty.FileSize);
            return val.longValue();
        }
        return 0L;
    }

    public long getAllocatedSize() {
        if (this.contains(NSURLFileProperty.FileAllocatedSize)) {
            NSNumber val = (NSNumber)this.get(NSURLFileProperty.FileAllocatedSize);
            return val.longValue();
        }
        return 0L;
    }

    public long getTotalFileSize() {
        if (this.contains(NSURLFileProperty.TotalFileSize)) {
            NSNumber val = (NSNumber)this.get(NSURLFileProperty.TotalFileSize);
            return val.longValue();
        }
        return 0L;
    }

    public long getTotalAllocatedSize() {
        if (this.contains(NSURLFileProperty.TotalFileAllocatedSize)) {
            NSNumber val = (NSNumber)this.get(NSURLFileProperty.TotalFileAllocatedSize);
            return val.longValue();
        }
        return 0L;
    }

    public boolean isAliasFile() {
        if (this.contains(NSURLFileProperty.IsAliasFile)) {
            NSNumber val = (NSNumber)this.get(NSURLFileProperty.IsAliasFile);
            return val.booleanValue();
        }
        return false;
    }

    public String getVolumeLocalizedFormatDescription() {
        if (this.contains(NSURLVolumeProperty.LocalizedFormatDescription)) {
            NSString val = (NSString)this.get(NSURLVolumeProperty.LocalizedFormatDescription);
            return val.toString();
        }
        return null;
    }

    public long getVolumeTotalCapacity() {
        if (this.contains(NSURLVolumeProperty.TotalCapacity)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.TotalCapacity);
            return val.longValue();
        }
        return 0L;
    }

    public long getVolumeAvailableCapacity() {
        if (this.contains(NSURLVolumeProperty.AvailableCapacity)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.AvailableCapacity);
            return val.longValue();
        }
        return 0L;
    }

    public long getVolumeResourceCount() {
        if (this.contains(NSURLVolumeProperty.ResourceCount)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.ResourceCount);
            return val.longValue();
        }
        return 0L;
    }

    public boolean volumeSupportsPersistentIDs() {
        if (this.contains(NSURLVolumeProperty.SupportsPersistentIDs)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.SupportsPersistentIDs);
            return val.booleanValue();
        }
        return false;
    }

    public boolean volumeSupportsSymbolicLinks() {
        if (this.contains(NSURLVolumeProperty.SupportsSymbolicLinks)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.SupportsSymbolicLinks);
            return val.booleanValue();
        }
        return false;
    }

    public boolean volumeSupportsHardLinks() {
        if (this.contains(NSURLVolumeProperty.SupportsHardLinks)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.SupportsHardLinks);
            return val.booleanValue();
        }
        return false;
    }

    public boolean volumeSupportsJournaling() {
        if (this.contains(NSURLVolumeProperty.SupportsJournaling)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.SupportsJournaling);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isVolumeJournaling() {
        if (this.contains(NSURLVolumeProperty.IsJournaling)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.IsJournaling);
            return val.booleanValue();
        }
        return false;
    }

    public boolean volumeSupportsSparseFiles() {
        if (this.contains(NSURLVolumeProperty.SupportsSparseFiles)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.SupportsSparseFiles);
            return val.booleanValue();
        }
        return false;
    }

    public boolean volumeSupportsZeroRuns() {
        if (this.contains(NSURLVolumeProperty.SupportsZeroRuns)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.SupportsZeroRuns);
            return val.booleanValue();
        }
        return false;
    }

    public boolean volumeSupportsCaseSensitiveNames() {
        if (this.contains(NSURLVolumeProperty.SupportsCaseSensitiveNames)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.SupportsCaseSensitiveNames);
            return val.booleanValue();
        }
        return false;
    }

    public boolean volumeSupportsCasePreservedNames() {
        if (this.contains(NSURLVolumeProperty.SupportsCasePreservedNames)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.SupportsCasePreservedNames);
            return val.booleanValue();
        }
        return false;
    }

    public boolean volumeSupportsRootDirectoryDates() {
        if (this.contains(NSURLVolumeProperty.SupportsRootDirectoryDates)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.SupportsRootDirectoryDates);
            return val.booleanValue();
        }
        return false;
    }

    public boolean volumeSupportsVolumeSizes() {
        if (this.contains(NSURLVolumeProperty.SupportsVolumeSizes)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.SupportsVolumeSizes);
            return val.booleanValue();
        }
        return false;
    }

    public boolean volumeSupportsRenaming() {
        if (this.contains(NSURLVolumeProperty.SupportsRenaming)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.SupportsRenaming);
            return val.booleanValue();
        }
        return false;
    }

    public boolean volumeSupportsAdvisoryFileLocking() {
        if (this.contains(NSURLVolumeProperty.SupportsAdvisoryFileLocking)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.SupportsAdvisoryFileLocking);
            return val.booleanValue();
        }
        return false;
    }

    public boolean volumeSupportsExtendedSecurity() {
        if (this.contains(NSURLVolumeProperty.SupportsExtendedSecurity)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.SupportsExtendedSecurity);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isVolumeBrowsable() {
        if (this.contains(NSURLVolumeProperty.IsBrowsable)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.IsBrowsable);
            return val.booleanValue();
        }
        return false;
    }

    public long getVolumeMaximueFileSize() {
        if (this.contains(NSURLVolumeProperty.MaximumFileSize)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.MaximumFileSize);
            return val.longValue();
        }
        return 0L;
    }

    public boolean isVolumeEjectable() {
        if (this.contains(NSURLVolumeProperty.IsEjectable)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.IsEjectable);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isVolumeRemovable() {
        if (this.contains(NSURLVolumeProperty.IsRemovable)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.IsRemovable);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isVolumeInternal() {
        if (this.contains(NSURLVolumeProperty.IsInternal)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.IsInternal);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isVolumeAutomounted() {
        if (this.contains(NSURLVolumeProperty.IsAutomounted)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.IsAutomounted);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isVolumeLocal() {
        if (this.contains(NSURLVolumeProperty.IsLocal)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.IsLocal);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isVolumeReadOnly() {
        if (this.contains(NSURLVolumeProperty.IsReadOnly)) {
            NSNumber val = (NSNumber)this.get(NSURLVolumeProperty.IsReadOnly);
            return val.booleanValue();
        }
        return false;
    }

    public NSDate getVolumeCreationDate() {
        if (this.contains(NSURLVolumeProperty.CreationDate)) {
            NSDate val = (NSDate)this.get(NSURLVolumeProperty.CreationDate);
            return val;
        }
        return null;
    }

    public NSURL getVolumeURLForRemounting() {
        if (this.contains(NSURLVolumeProperty.URLForRemounting)) {
            NSURL val = (NSURL)this.get(NSURLVolumeProperty.URLForRemounting);
            return val;
        }
        return null;
    }

    public String getVolumeUUIDString() {
        if (this.contains(NSURLVolumeProperty.UUIDString)) {
            NSString val = (NSString)this.get(NSURLVolumeProperty.UUIDString);
            return val.toString();
        }
        return null;
    }

    public String getVolumeName() {
        if (this.contains(NSURLVolumeProperty.Name)) {
            NSString val = (NSString)this.get(NSURLVolumeProperty.Name);
            return val.toString();
        }
        return null;
    }

    public NSURLProperties setVolumeName(String name) {
        this.put(NSURLVolumeProperty.Name, (NSObject)new NSString(name));
        return this;
    }

    public String getVolumeLocalizedName() {
        if (this.contains(NSURLVolumeProperty.LocalizedName)) {
            NSString val = (NSString)this.get(NSURLVolumeProperty.LocalizedName);
            return val.toString();
        }
        return null;
    }

    public boolean isUbiquitousItem() {
        if (this.contains(NSURLUbiquitousItemProperty.IsUbiquitousItem)) {
            NSNumber val = (NSNumber)this.get(NSURLUbiquitousItemProperty.IsUbiquitousItem);
            return val.booleanValue();
        }
        return false;
    }

    public boolean hasUnresolvedConflicts() {
        if (this.contains(NSURLUbiquitousItemProperty.HasUnresolvedConflicts)) {
            NSNumber val = (NSNumber)this.get(NSURLUbiquitousItemProperty.HasUnresolvedConflicts);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isDownloading() {
        if (this.contains(NSURLUbiquitousItemProperty.IsDownloading)) {
            NSNumber val = (NSNumber)this.get(NSURLUbiquitousItemProperty.IsDownloading);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isUploaded() {
        if (this.contains(NSURLUbiquitousItemProperty.IsUploaded)) {
            NSNumber val = (NSNumber)this.get(NSURLUbiquitousItemProperty.IsUploaded);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isUploading() {
        if (this.contains(NSURLUbiquitousItemProperty.IsUploading)) {
            NSNumber val = (NSNumber)this.get(NSURLUbiquitousItemProperty.IsUploading);
            return val.booleanValue();
        }
        return false;
    }

    public NSURLUbiquitousItemDownloadingStatus getDownloadingStatus() {
        if (this.contains(NSURLUbiquitousItemProperty.DownloadingStatus)) {
            NSString val = (NSString)this.get(NSURLUbiquitousItemProperty.DownloadingStatus);
            return NSURLUbiquitousItemDownloadingStatus.valueOf(val);
        }
        return null;
    }

    public NSError getDownloadingError() {
        if (this.contains(NSURLUbiquitousItemProperty.DownloadingError)) {
            NSError val = (NSError)this.get(NSURLUbiquitousItemProperty.DownloadingError);
            return val;
        }
        return null;
    }

    public NSError getUploadingError() {
        if (this.contains(NSURLUbiquitousItemProperty.UploadingError)) {
            NSError val = (NSError)this.get(NSURLUbiquitousItemProperty.UploadingError);
            return val;
        }
        return null;
    }

    public boolean isDownloadRequested() {
        if (this.contains(NSURLUbiquitousItemProperty.DownloadRequested)) {
            NSNumber val = (NSNumber)this.get(NSURLUbiquitousItemProperty.DownloadRequested);
            return val.booleanValue();
        }
        return false;
    }

    public String getContainerDisplayName() {
        if (this.contains(NSURLUbiquitousItemProperty.ContainerDisplayName)) {
            NSString val = (NSString)this.get(NSURLUbiquitousItemProperty.ContainerDisplayName);
            return val.toString();
        }
        return null;
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSURLProperties.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSURLProperties toObject(Class<NSURLProperties> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSURLProperties(o);
        }

        @MarshalsPointer
        public static long toNative(NSURLProperties o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

