/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.healthkit;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSDateComponents;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSPredicate;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.healthkit.HKAuthorizationRequestStatus;
import org.robovm.apple.healthkit.HKAuthorizationStatus;
import org.robovm.apple.healthkit.HKBiologicalSexObject;
import org.robovm.apple.healthkit.HKBloodTypeObject;
import org.robovm.apple.healthkit.HKFitzpatrickSkinTypeObject;
import org.robovm.apple.healthkit.HKObject;
import org.robovm.apple.healthkit.HKObjectType;
import org.robovm.apple.healthkit.HKQuantity;
import org.robovm.apple.healthkit.HKQuantityType;
import org.robovm.apple.healthkit.HKQuery;
import org.robovm.apple.healthkit.HKSample;
import org.robovm.apple.healthkit.HKSampleType;
import org.robovm.apple.healthkit.HKUnit;
import org.robovm.apple.healthkit.HKUpdateFrequency;
import org.robovm.apple.healthkit.HKWheelchairUseObject;
import org.robovm.apple.healthkit.HKWorkout;
import org.robovm.apple.healthkit.HKWorkoutConfiguration;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.objc.block.VoidBlock3;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="HealthKit")
@NativeClass
public class HKHealthStore
extends NSObject {
    public HKHealthStore() {
    }

    protected HKHealthStore(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected HKHealthStore(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @GlobalValue(symbol="HKUserPreferencesDidChangeNotification", optional=true)
    public static native NSString UserPreferencesDidChangeNotification();

    @Method(selector="supportsHealthRecords")
    public native boolean supportsHealthRecords();

    @Method(selector="authorizationStatusForType:")
    public native HKAuthorizationStatus getAuthorizationStatusForType(HKObjectType var1);

    @Method(selector="requestAuthorizationToShareTypes:readTypes:completion:")
    public native void requestAuthorizationToTypes(NSSet<HKSampleType> var1, NSSet<HKObjectType> var2, @Block VoidBlock2<Boolean, NSError> var3);

    @Method(selector="getRequestStatusForAuthorizationToShareTypes:readTypes:completion:")
    public native void getRequestStatus(NSSet<HKSampleType> var1, NSSet<?> var2, @Block VoidBlock2<HKAuthorizationRequestStatus, NSError> var3);

    @Method(selector="handleAuthorizationForExtensionWithCompletion:")
    public native void handleAuthorizationForExtension(@Block VoidBlock2<Boolean, NSError> var1);

    @Method(selector="earliestPermittedSampleDate")
    public native NSDate earliestPermittedSampleDate();

    @Method(selector="saveObject:withCompletion:")
    public native void saveObject(HKObject var1, @Block VoidBlock2<Boolean, NSError> var2);

    @Method(selector="saveObjects:withCompletion:")
    public native void saveObjects(NSArray<HKObject> var1, @Block VoidBlock2<Boolean, NSError> var2);

    @Method(selector="deleteObject:withCompletion:")
    public native void deleteObject(HKObject var1, @Block VoidBlock2<Boolean, NSError> var2);

    @Method(selector="deleteObjects:withCompletion:")
    public native void deleteObjects(NSArray<HKObject> var1, @Block VoidBlock2<Boolean, NSError> var2);

    @Method(selector="deleteObjectsOfType:predicate:withCompletion:")
    public native void deleteObjectsOfType(HKObjectType var1, NSPredicate var2, @Block(value="(,@MachineSizedUInt,)") VoidBlock3<Boolean, Long, NSError> var3);

    @Method(selector="executeQuery:")
    public native void executeQuery(HKQuery var1);

    @Method(selector="stopQuery:")
    public native void stopQuery(HKQuery var1);

    @Deprecated
    @Method(selector="splitTotalEnergy:startDate:endDate:resultsHandler:")
    public native void splitTotalEnergy(HKQuantity var1, NSDate var2, NSDate var3, @Block VoidBlock3<HKQuantity, HKQuantity, NSError> var4);

    @Deprecated
    public NSDate getDateOfBirth() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSDate result = this.getDateOfBirth(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Deprecated
    @Method(selector="dateOfBirthWithError:")
    private native NSDate getDateOfBirth(NSError.NSErrorPtr var1);

    public NSDateComponents getDateOfBirthComponents() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSDateComponents result = this.getDateOfBirthComponents(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="dateOfBirthComponentsWithError:")
    private native NSDateComponents getDateOfBirthComponents(NSError.NSErrorPtr var1);

    public HKBiologicalSexObject getBiologicalSex() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        HKBiologicalSexObject result = this.getBiologicalSex(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="biologicalSexWithError:")
    private native HKBiologicalSexObject getBiologicalSex(NSError.NSErrorPtr var1);

    public HKBloodTypeObject getBloodType() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        HKBloodTypeObject result = this.getBloodType(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="bloodTypeWithError:")
    private native HKBloodTypeObject getBloodType(NSError.NSErrorPtr var1);

    public HKFitzpatrickSkinTypeObject getFitzpatrickSkinType() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        HKFitzpatrickSkinTypeObject result = this.getFitzpatrickSkinType(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="fitzpatrickSkinTypeWithError:")
    private native HKFitzpatrickSkinTypeObject getFitzpatrickSkinType(NSError.NSErrorPtr var1);

    public HKWheelchairUseObject getWheelchairUse() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        HKWheelchairUseObject result = this.getWheelchairUse(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="wheelchairUseWithError:")
    private native HKWheelchairUseObject getWheelchairUse(NSError.NSErrorPtr var1);

    @Method(selector="isHealthDataAvailable")
    public static native boolean isHealthDataAvailable();

    @Method(selector="addSamples:toWorkout:completion:")
    public native void addSamplesToWorkout(NSArray<HKSample> var1, HKWorkout var2, @Block VoidBlock2<Boolean, NSError> var3);

    @Method(selector="startWatchAppWithWorkoutConfiguration:completion:")
    public native void startWatchApp(HKWorkoutConfiguration var1, @Block VoidBlock2<Boolean, NSError> var2);

    @Method(selector="enableBackgroundDeliveryForType:frequency:withCompletion:")
    public native void enableBackgroundDeliveryForType(HKObjectType var1, HKUpdateFrequency var2, @Block VoidBlock2<Boolean, NSError> var3);

    @Method(selector="disableBackgroundDeliveryForType:withCompletion:")
    public native void disableBackgroundDeliveryForType(HKObjectType var1, @Block VoidBlock2<Boolean, NSError> var2);

    @Method(selector="disableAllBackgroundDeliveryWithCompletion:")
    public native void disableAllBackgroundDelivery(@Block VoidBlock2<Boolean, NSError> var1);

    @Method(selector="preferredUnitsForQuantityTypes:completion:")
    public native void getPreferredUnitsForQuantityTypes(NSSet<HKQuantityType> var1, @Block VoidBlock2<NSDictionary<HKQuantityType, HKUnit>, NSError> var2);

    static {
        ObjCRuntime.bind(HKHealthStore.class);
    }

    public static class HKHealthStorePtr
    extends Ptr<HKHealthStore, HKHealthStorePtr> {
    }

    public static class Notifications {
        public static NSObject observeUserPreferencesDidChange(HKHealthStore object, final VoidBlock1<HKHealthStore> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(HKHealthStore.UserPreferencesDidChangeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((HKHealthStore)a.getObject()));
                }
            });
        }
    }
}

