/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metal;

import org.robovm.apple.dispatch.DispatchData;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSBundle;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.iosurface.IOSurface;
import org.robovm.apple.metal.MTLArgumentBuffersTier;
import org.robovm.apple.metal.MTLArgumentDescriptor;
import org.robovm.apple.metal.MTLArgumentEncoder;
import org.robovm.apple.metal.MTLBuffer;
import org.robovm.apple.metal.MTLCommandQueue;
import org.robovm.apple.metal.MTLCompileOptions;
import org.robovm.apple.metal.MTLComputePipelineDescriptor;
import org.robovm.apple.metal.MTLComputePipelineReflection;
import org.robovm.apple.metal.MTLComputePipelineState;
import org.robovm.apple.metal.MTLDepthStencilDescriptor;
import org.robovm.apple.metal.MTLDepthStencilState;
import org.robovm.apple.metal.MTLEvent;
import org.robovm.apple.metal.MTLFeatureSet;
import org.robovm.apple.metal.MTLFence;
import org.robovm.apple.metal.MTLFunction;
import org.robovm.apple.metal.MTLHeap;
import org.robovm.apple.metal.MTLHeapDescriptor;
import org.robovm.apple.metal.MTLIndirectCommandBuffer;
import org.robovm.apple.metal.MTLIndirectCommandBufferDescriptor;
import org.robovm.apple.metal.MTLLibrary;
import org.robovm.apple.metal.MTLPipelineOption;
import org.robovm.apple.metal.MTLPixelFormat;
import org.robovm.apple.metal.MTLReadWriteTextureTier;
import org.robovm.apple.metal.MTLRenderPipelineDescriptor;
import org.robovm.apple.metal.MTLRenderPipelineReflection;
import org.robovm.apple.metal.MTLRenderPipelineState;
import org.robovm.apple.metal.MTLResourceOptions;
import org.robovm.apple.metal.MTLSamplePosition;
import org.robovm.apple.metal.MTLSamplerDescriptor;
import org.robovm.apple.metal.MTLSamplerState;
import org.robovm.apple.metal.MTLSharedEvent;
import org.robovm.apple.metal.MTLSharedEventHandle;
import org.robovm.apple.metal.MTLSize;
import org.robovm.apple.metal.MTLSizeAndAlign;
import org.robovm.apple.metal.MTLTexture;
import org.robovm.apple.metal.MTLTextureDescriptor;
import org.robovm.apple.metal.MTLTileRenderPipelineDescriptor;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeProtocolProxy;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.objc.block.VoidBlock3;
import org.robovm.rt.VM;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Metal")
@NativeProtocolProxy
public final class MTLDevice
extends NSObject
implements NSObjectProtocol {
    @Property(selector="name")
    public native String getName();

    @Property(selector="registryID")
    public native long getRegistryID();

    @Property(selector="maxThreadsPerThreadgroup")
    @ByVal
    public native MTLSize getMaxThreadsPerThreadgroup();

    @Property(selector="readWriteTextureSupport")
    public native MTLReadWriteTextureTier getReadWriteTextureSupport();

    @Property(selector="argumentBuffersSupport")
    public native MTLArgumentBuffersTier getArgumentBuffersSupport();

    @Property(selector="areRasterOrderGroupsSupported")
    public native boolean isRasterOrderGroupsSupported();

    @Property(selector="currentAllocatedSize")
    @MachineSizedUInt
    public native long getCurrentAllocatedSize();

    @Property(selector="maxThreadgroupMemoryLength")
    @MachineSizedUInt
    public native long getMaxThreadgroupMemoryLength();

    @Property(selector="maxArgumentBufferSamplerCount")
    @MachineSizedUInt
    public native long getMaxArgumentBufferSamplerCount();

    @Property(selector="areProgrammableSamplePositionsSupported")
    public native boolean isProgrammableSamplePositionsSupported();

    @Property(selector="maxBufferLength")
    @MachineSizedUInt
    public native long getMaxBufferLength();

    public MTLBuffer newBuffer(byte[] bytes, MTLResourceOptions options) {
        return this.newBuffer(VM.getArrayValuesAddress((Object)bytes), bytes.length, options);
    }

    public MTLBuffer newBuffer(byte[] bytes, MTLResourceOptions options, final VoidBlock1<byte[]> deallocator) {
        return this.newBuffer(VM.getArrayValuesAddress((Object)bytes), bytes.length, options, new VoidBlock2<Long, Long>(){

            public void invoke(Long a, Long b) {
                byte[] bytes = VM.newByteArray((long)a, (int)b.intValue());
                deallocator.invoke((Object)bytes);
            }
        });
    }

    public MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor descriptor, MTLPipelineOption options) throws NSErrorException {
        return this.newRenderPipelineState(descriptor, options, (MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr)null);
    }

    public MTLComputePipelineState newComputePipelineState(MTLFunction computeFunction, MTLPipelineOption options) throws NSErrorException {
        return this.newComputePipelineState(computeFunction, options, (MTLComputePipelineReflection.MTLComputePipelineReflectionPtr)null);
    }

    @Bridge(symbol="MTLCreateSystemDefaultDevice", optional=true)
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public static native MTLDevice getSystemDefaultDevice();

    @Method(selector="newCommandQueue")
    public native MTLCommandQueue newCommandQueue();

    @Method(selector="newCommandQueueWithMaxCommandBufferCount:")
    public native MTLCommandQueue newCommandQueue(@MachineSizedUInt long var1);

    @Method(selector="heapTextureSizeAndAlignWithDescriptor:")
    @ByVal
    public native MTLSizeAndAlign heapTextureSizeAndAlign(MTLTextureDescriptor var1);

    @Method(selector="heapBufferSizeAndAlignWithLength:options:")
    @ByVal
    public native MTLSizeAndAlign heapBufferSizeAndAlignWithLength(@MachineSizedUInt long var1, MTLResourceOptions var3);

    @Method(selector="newHeapWithDescriptor:")
    public native MTLHeap newHeap(MTLHeapDescriptor var1);

    @Method(selector="newBufferWithLength:options:")
    public native MTLBuffer newBuffer(@MachineSizedUInt long var1, MTLResourceOptions var3);

    @Method(selector="newBufferWithBytes:length:options:")
    protected native MTLBuffer newBuffer(@Pointer long var1, @MachineSizedUInt long var3, MTLResourceOptions var5);

    @Method(selector="newBufferWithBytesNoCopy:length:options:deallocator:")
    protected native MTLBuffer newBuffer(@Pointer long var1, @MachineSizedUInt long var3, MTLResourceOptions var5, @Block(value="(@Pointer,@MachineSizedUInt)") VoidBlock2<Long, Long> var6);

    @Method(selector="newDepthStencilStateWithDescriptor:")
    public native MTLDepthStencilState newDepthStencilState(MTLDepthStencilDescriptor var1);

    @Method(selector="newTextureWithDescriptor:")
    public native MTLTexture newTexture(MTLTextureDescriptor var1);

    @Method(selector="newTextureWithDescriptor:iosurface:plane:")
    public native MTLTexture newTexture(MTLTextureDescriptor var1, IOSurface var2, @MachineSizedUInt long var3);

    @Method(selector="newSamplerStateWithDescriptor:")
    public native MTLSamplerState newSamplerState(MTLSamplerDescriptor var1);

    @Method(selector="newDefaultLibrary")
    public native MTLLibrary newDefaultLibrary();

    public MTLLibrary newDefaultLibrary(NSBundle bundle) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLLibrary result = this.newDefaultLibrary(bundle, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newDefaultLibraryWithBundle:error:")
    private native MTLLibrary newDefaultLibrary(NSBundle var1, NSError.NSErrorPtr var2);

    public MTLLibrary newLibraryWithFile(String filepath) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLLibrary result = this.newLibraryWithFile(filepath, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newLibraryWithFile:error:")
    private native MTLLibrary newLibraryWithFile(String var1, NSError.NSErrorPtr var2);

    public MTLLibrary newLibrary(NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLLibrary result = this.newLibrary(url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newLibraryWithURL:error:")
    private native MTLLibrary newLibrary(NSURL var1, NSError.NSErrorPtr var2);

    @WeaklyLinked
    public MTLLibrary newLibraryWithData(DispatchData data) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLLibrary result = this.newLibraryWithData(data, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newLibraryWithData:error:")
    @WeaklyLinked
    private native MTLLibrary newLibraryWithData(DispatchData var1, NSError.NSErrorPtr var2);

    public MTLLibrary newLibraryWithSource(String source, MTLCompileOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLLibrary result = this.newLibraryWithSource(source, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newLibraryWithSource:options:error:")
    private native MTLLibrary newLibraryWithSource(String var1, MTLCompileOptions var2, NSError.NSErrorPtr var3);

    @Method(selector="newLibraryWithSource:options:completionHandler:")
    public native void newLibraryWithSource(String var1, MTLCompileOptions var2, @Block VoidBlock2<MTLLibrary, NSError> var3);

    public MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor descriptor) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLRenderPipelineState result = this.newRenderPipelineState(descriptor, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newRenderPipelineStateWithDescriptor:error:")
    private native MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor var1, NSError.NSErrorPtr var2);

    public MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor descriptor, MTLPipelineOption options, MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr reflection) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLRenderPipelineState result = this.newRenderPipelineState(descriptor, options, reflection, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newRenderPipelineStateWithDescriptor:options:reflection:error:")
    private native MTLRenderPipelineState newRenderPipelineState(MTLRenderPipelineDescriptor var1, MTLPipelineOption var2, MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr var3, NSError.NSErrorPtr var4);

    @Method(selector="newRenderPipelineStateWithDescriptor:completionHandler:")
    public native void newRenderPipelineState(MTLRenderPipelineDescriptor var1, @Block VoidBlock2<MTLRenderPipelineState, NSError> var2);

    @Method(selector="newRenderPipelineStateWithDescriptor:options:completionHandler:")
    public native void newRenderPipelineState(MTLRenderPipelineDescriptor var1, MTLPipelineOption var2, @Block VoidBlock3<MTLRenderPipelineState, MTLRenderPipelineReflection, NSError> var3);

    public MTLComputePipelineState newComputePipelineState(MTLFunction computeFunction) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLComputePipelineState result = this.newComputePipelineState(computeFunction, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newComputePipelineStateWithFunction:error:")
    private native MTLComputePipelineState newComputePipelineState(MTLFunction var1, NSError.NSErrorPtr var2);

    public MTLComputePipelineState newComputePipelineState(MTLFunction computeFunction, MTLPipelineOption options, MTLComputePipelineReflection.MTLComputePipelineReflectionPtr reflection) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLComputePipelineState result = this.newComputePipelineState(computeFunction, options, reflection, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newComputePipelineStateWithFunction:options:reflection:error:")
    private native MTLComputePipelineState newComputePipelineState(MTLFunction var1, MTLPipelineOption var2, MTLComputePipelineReflection.MTLComputePipelineReflectionPtr var3, NSError.NSErrorPtr var4);

    @Method(selector="newComputePipelineStateWithFunction:completionHandler:")
    public native void newComputePipelineState(MTLFunction var1, @Block VoidBlock2<MTLComputePipelineState, NSError> var2);

    @Method(selector="newComputePipelineStateWithFunction:options:completionHandler:")
    public native void newComputePipelineState(MTLFunction var1, MTLPipelineOption var2, @Block VoidBlock3<MTLComputePipelineState, MTLComputePipelineReflection, NSError> var3);

    public MTLComputePipelineState newComputePipelineState(MTLComputePipelineDescriptor descriptor, MTLPipelineOption options, MTLComputePipelineReflection.MTLComputePipelineReflectionPtr reflection) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLComputePipelineState result = this.newComputePipelineState(descriptor, options, reflection, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newComputePipelineStateWithDescriptor:options:reflection:error:")
    private native MTLComputePipelineState newComputePipelineState(MTLComputePipelineDescriptor var1, MTLPipelineOption var2, MTLComputePipelineReflection.MTLComputePipelineReflectionPtr var3, NSError.NSErrorPtr var4);

    @Method(selector="newComputePipelineStateWithDescriptor:options:completionHandler:")
    public native void newComputePipelineState(MTLComputePipelineDescriptor var1, MTLPipelineOption var2, @Block VoidBlock3<MTLComputePipelineState, MTLComputePipelineReflection, NSError> var3);

    @Method(selector="newFence")
    public native MTLFence newFence();

    @Method(selector="supportsFeatureSet:")
    public native boolean supportsFeatureSet(MTLFeatureSet var1);

    @Method(selector="supportsTextureSampleCount:")
    public native boolean supportsTextureSampleCount(@MachineSizedUInt long var1);

    @Method(selector="minimumLinearTextureAlignmentForPixelFormat:")
    @MachineSizedUInt
    public native long minimumLinearTextureAlignmentForPixelFormat(MTLPixelFormat var1);

    @Method(selector="minimumTextureBufferAlignmentForPixelFormat:")
    @MachineSizedUInt
    public native long minimumTextureBufferAlignmentForPixelFormat(MTLPixelFormat var1);

    public MTLRenderPipelineState newRenderPipelineState(MTLTileRenderPipelineDescriptor descriptor, MTLPipelineOption options, MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr reflection) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        MTLRenderPipelineState result = this.newRenderPipelineState(descriptor, options, reflection, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newRenderPipelineStateWithTileDescriptor:options:reflection:error:")
    private native MTLRenderPipelineState newRenderPipelineState(MTLTileRenderPipelineDescriptor var1, MTLPipelineOption var2, MTLRenderPipelineReflection.MTLRenderPipelineReflectionPtr var3, NSError.NSErrorPtr var4);

    @Method(selector="newRenderPipelineStateWithTileDescriptor:options:completionHandler:")
    public native void newRenderPipelineState(MTLTileRenderPipelineDescriptor var1, MTLPipelineOption var2, @Block VoidBlock3<MTLRenderPipelineState, MTLRenderPipelineReflection, NSError> var3);

    @Method(selector="getDefaultSamplePositions:count:")
    public native void getDefaultSamplePositions(MTLSamplePosition var1, @MachineSizedUInt long var2);

    @Method(selector="newArgumentEncoderWithArguments:")
    public native MTLArgumentEncoder newArgumentEncoder(NSArray<MTLArgumentDescriptor> var1);

    @Method(selector="newIndirectCommandBufferWithDescriptor:maxCommandCount:options:")
    public native MTLIndirectCommandBuffer newIndirectCommand(MTLIndirectCommandBufferDescriptor var1, @MachineSizedUInt long var2, MTLResourceOptions var4);

    @Method(selector="newEvent")
    public native MTLEvent newEvent();

    @Method(selector="newSharedEvent")
    public native MTLSharedEvent newSharedEvent();

    @Method(selector="newSharedEventWithHandle:")
    public native MTLSharedEvent newSharedEvent(MTLSharedEventHandle var1);

    static {
        ObjCRuntime.bind(MTLDevice.class);
    }

    public static class MTLDevicePtr
    extends Ptr<MTLDevice, MTLDevicePtr> {
    }
}

