/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metal;

import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.iosurface.IOSurface;
import org.robovm.apple.metal.MTLBuffer;
import org.robovm.apple.metal.MTLCPUCacheMode;
import org.robovm.apple.metal.MTLDevice;
import org.robovm.apple.metal.MTLHeap;
import org.robovm.apple.metal.MTLPixelFormat;
import org.robovm.apple.metal.MTLPurgeableState;
import org.robovm.apple.metal.MTLRegion;
import org.robovm.apple.metal.MTLResource;
import org.robovm.apple.metal.MTLStorageMode;
import org.robovm.apple.metal.MTLTextureType;
import org.robovm.apple.metal.MTLTextureUsage;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeProtocolProxy;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.VM;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Metal")
@NativeProtocolProxy
public final class MTLTexture
extends NSObject
implements MTLResource {
    @Deprecated
    @Property(selector="rootResource")
    public native MTLResource getRootResource();

    @Property(selector="parentTexture")
    public native MTLTexture getParentTexture();

    @Property(selector="parentRelativeLevel")
    @MachineSizedUInt
    public native long getParentRelativeLevel();

    @Property(selector="parentRelativeSlice")
    @MachineSizedUInt
    public native long getParentRelativeSlice();

    @Property(selector="buffer")
    public native MTLBuffer getBuffer();

    @Property(selector="bufferOffset")
    @MachineSizedUInt
    public native long getBufferOffset();

    @Property(selector="bufferBytesPerRow")
    @MachineSizedUInt
    public native long getBufferBytesPerRow();

    @Property(selector="iosurface")
    public native IOSurface getIosurface();

    @Property(selector="iosurfacePlane")
    @MachineSizedUInt
    public native long getIosurfacePlane();

    @Property(selector="textureType")
    public native MTLTextureType getTextureType();

    @Property(selector="pixelFormat")
    public native MTLPixelFormat getPixelFormat();

    @Property(selector="width")
    @MachineSizedUInt
    public native long getWidth();

    @Property(selector="height")
    @MachineSizedUInt
    public native long getHeight();

    @Property(selector="depth")
    @MachineSizedUInt
    public native long getDepth();

    @Property(selector="mipmapLevelCount")
    @MachineSizedUInt
    public native long getMipmapLevelCount();

    @Property(selector="sampleCount")
    @MachineSizedUInt
    public native long getSampleCount();

    @Property(selector="arrayLength")
    @MachineSizedUInt
    public native long getArrayLength();

    @Property(selector="usage")
    public native MTLTextureUsage getUsage();

    @Property(selector="isFramebufferOnly")
    public native boolean isFramebufferOnly();

    @Property(selector="allowGPUOptimizedContents")
    public native boolean isAllowGPUOptimizedContents();

    @Override
    @Property(selector="label")
    public native String getLabel();

    @Override
    @Property(selector="setLabel:")
    public native void setLabel(String var1);

    @Override
    @Property(selector="device")
    public native MTLDevice getDevice();

    @Override
    @Property(selector="cpuCacheMode")
    public native MTLCPUCacheMode getCpuCacheMode();

    @Override
    @Property(selector="storageMode")
    public native MTLStorageMode getStorageMode();

    @Override
    @Property(selector="heap")
    public native MTLHeap getHeap();

    @Override
    @Property(selector="allocatedSize")
    @MachineSizedUInt
    public native long getAllocatedSize();

    public byte[] getBytes(int length, @MachineSizedUInt long bytesPerRow, @MachineSizedUInt long bytesPerImage, @ByVal MTLRegion region, @MachineSizedUInt long level, @MachineSizedUInt long slice) {
        byte[] bytes = new byte[length];
        this.getBytes(VM.getArrayValuesAddress((Object)bytes), bytesPerRow, bytesPerImage, region, level, slice);
        return bytes;
    }

    public void replaceRegion(@ByVal MTLRegion region, @MachineSizedUInt long level, @MachineSizedUInt long slice, byte[] pixelBytes, @MachineSizedUInt long bytesPerRow, @MachineSizedUInt long bytesPerImage) {
        this.replaceRegion(region, level, slice, VM.getArrayValuesAddress((Object)pixelBytes), bytesPerRow, bytesPerImage);
    }

    public byte[] getBytes(int length, @MachineSizedUInt long bytesPerRow, @ByVal MTLRegion region, @MachineSizedUInt long level) {
        byte[] bytes = new byte[length];
        this.getBytes(VM.getArrayValuesAddress((Object)bytes), bytesPerRow, region, level);
        return bytes;
    }

    public void replaceRegion(@ByVal MTLRegion region, @MachineSizedUInt long level, byte[] pixelBytes, @MachineSizedUInt long bytesPerRow) {
        this.replaceRegion(region, level, VM.getArrayValuesAddress((Object)pixelBytes), bytesPerRow);
    }

    @Method(selector="getBytes:bytesPerRow:bytesPerImage:fromRegion:mipmapLevel:slice:")
    protected native void getBytes(@Pointer long var1, @MachineSizedUInt long var3, @MachineSizedUInt long var5, @ByVal MTLRegion var7, @MachineSizedUInt long var8, @MachineSizedUInt long var10);

    @Method(selector="replaceRegion:mipmapLevel:slice:withBytes:bytesPerRow:bytesPerImage:")
    protected native void replaceRegion(@ByVal MTLRegion var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, @Pointer long var6, @MachineSizedUInt long var8, @MachineSizedUInt long var10);

    @Method(selector="getBytes:bytesPerRow:fromRegion:mipmapLevel:")
    protected native void getBytes(@Pointer long var1, @MachineSizedUInt long var3, @ByVal MTLRegion var5, @MachineSizedUInt long var6);

    @Method(selector="replaceRegion:mipmapLevel:withBytes:bytesPerRow:")
    protected native void replaceRegion(@ByVal MTLRegion var1, @MachineSizedUInt long var2, @Pointer long var4, @MachineSizedUInt long var6);

    @Method(selector="newTextureViewWithPixelFormat:")
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public native MTLTexture newTextureView(MTLPixelFormat var1);

    @Method(selector="newTextureViewWithPixelFormat:textureType:levels:slices:")
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public native MTLTexture newTextureView(MTLPixelFormat var1, MTLTextureType var2, @ByVal NSRange var3, @ByVal NSRange var4);

    @Override
    @Method(selector="setPurgeableState:")
    public native MTLPurgeableState setPurgeableState(MTLPurgeableState var1);

    @Override
    @Method(selector="makeAliasable")
    public native void makeAliasable();

    @Override
    @Method(selector="isAliasable")
    public native boolean isAliasable();

    static {
        ObjCRuntime.bind(MTLTexture.class);
    }

    public static class MTLTexturePtr
    extends Ptr<MTLTexture, MTLTexturePtr> {
    }
}

