/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metalkit;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.metal.MTLDevice;
import org.robovm.apple.metalkit.MTKMeshBuffer;
import org.robovm.apple.metalkit.MTKSubmesh;
import org.robovm.apple.modelio.MDLAsset;
import org.robovm.apple.modelio.MDLMesh;
import org.robovm.apple.modelio.MDLVertexDescriptor;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MetalKit")
@NativeClass
public class MTKMesh
extends NSObject {
    protected MTKMesh() {
    }

    protected MTKMesh(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MTKMesh(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithMesh:device:error:")
    public MTKMesh(MDLMesh mesh, MTLDevice device) throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(mesh, device, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    @Property(selector="vertexBuffers")
    public native NSArray<MTKMeshBuffer> getVertexBuffers();

    @Property(selector="vertexDescriptor")
    public native MDLVertexDescriptor getVertexDescriptor();

    @Property(selector="submeshes")
    public native NSArray<MTKSubmesh> getSubmeshes();

    @Property(selector="vertexCount")
    @MachineSizedUInt
    public native long getVertexCount();

    @Property(selector="name")
    public native String getName();

    @Property(selector="setName:")
    public native void setName(String var1);

    @Method(selector="initWithMesh:device:error:")
    @Pointer
    private native long init(MDLMesh var1, MTLDevice var2, NSError.NSErrorPtr var3);

    public static NSArray<MTKMesh> newMeshes(MDLAsset asset, MTLDevice device, NSArray.NSArrayPtr<?> sourceMeshes) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSArray<MTKMesh> result = MTKMesh.newMeshes(asset, device, sourceMeshes, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="newMeshesFromAsset:device:sourceMeshes:error:")
    private static native NSArray<MTKMesh> newMeshes(MDLAsset var0, MTLDevice var1, NSArray.NSArrayPtr<?> var2, NSError.NSErrorPtr var3);

    static {
        ObjCRuntime.bind(MTKMesh.class);
    }

    public static class MTKMeshPtr
    extends Ptr<MTKMesh, MTKMeshPtr> {
    }
}

