/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.scenekit;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.foundation.NSValue;
import org.robovm.apple.scenekit.SCNMaterialProperty;
import org.robovm.apple.scenekit.SCNMatrix4;
import org.robovm.apple.scenekit.SCNNode;
import org.robovm.apple.scenekit.SCNParticleSystem;
import org.robovm.apple.scenekit.SCNPhysicsWorld;
import org.robovm.apple.scenekit.SCNSceneAttribute;
import org.robovm.apple.scenekit.SCNSceneExportDelegate;
import org.robovm.apple.scenekit.SCNSceneSourceOptions;
import org.robovm.apple.scenekit.SCNVector3;
import org.robovm.apple.uikit.UIColor;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock3;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="SceneKit")
@NativeClass
public class SCNScene
extends NSObject
implements NSSecureCoding {
    public SCNScene() {
    }

    protected SCNScene(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected SCNScene(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithCoder:")
    public SCNScene(NSCoder decoder) {
        super(null);
        this.initObject(this.init(decoder));
    }

    @Property(selector="rootNode")
    public native SCNNode getRootNode();

    @Property(selector="physicsWorld")
    public native SCNPhysicsWorld getPhysicsWorld();

    @Property(selector="background")
    public native SCNMaterialProperty getBackground();

    @Property(selector="lightingEnvironment")
    public native SCNMaterialProperty getLightingEnvironment();

    @Property(selector="fogStartDistance")
    @MachineSizedFloat
    public native double getFogStartDistance();

    @Property(selector="setFogStartDistance:")
    public native void setFogStartDistance(@MachineSizedFloat double var1);

    @Property(selector="fogEndDistance")
    @MachineSizedFloat
    public native double getFogEndDistance();

    @Property(selector="setFogEndDistance:")
    public native void setFogEndDistance(@MachineSizedFloat double var1);

    @Property(selector="fogDensityExponent")
    @MachineSizedFloat
    public native double getFogDensityExponent();

    @Property(selector="setFogDensityExponent:")
    public native void setFogDensityExponent(@MachineSizedFloat double var1);

    @Property(selector="fogColor")
    public native UIColor getFogColor();

    @Property(selector="setFogColor:")
    public native void setFogColor(UIColor var1);

    @Property(selector="isPaused")
    public native boolean isPaused();

    @Property(selector="setPaused:")
    public native void setPaused(boolean var1);

    @Property(selector="particleSystems")
    public native NSArray<SCNParticleSystem> getParticleSystems();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    public void setAttribute(SCNSceneAttribute key, NSObject attribute) {
        this.setAttribute(attribute, key);
    }

    public double getStartTime() {
        NSNumber val = (NSNumber)this.getAttribute(SCNSceneAttribute.StartTime);
        if (val != null) {
            return val.doubleValue();
        }
        return 0.0;
    }

    public SCNScene setStartTime(double startTime) {
        this.setAttribute(NSNumber.valueOf(startTime), SCNSceneAttribute.StartTime);
        return this;
    }

    public double getEndTime() {
        NSNumber val = (NSNumber)this.getAttribute(SCNSceneAttribute.EndTime);
        if (val != null) {
            return val.doubleValue();
        }
        return 0.0;
    }

    public SCNScene setEndTime(double endTime) {
        this.setAttribute(NSNumber.valueOf(endTime), SCNSceneAttribute.EndTime);
        return this;
    }

    public double getFrameRate() {
        NSNumber val = (NSNumber)this.getAttribute(SCNSceneAttribute.FrameRate);
        if (val != null) {
            return val.doubleValue();
        }
        return 0.0;
    }

    public SCNScene setFrameRate(double frameRate) {
        this.setAttribute(NSNumber.valueOf(frameRate), SCNSceneAttribute.FrameRate);
        return this;
    }

    public SCNVector3 getUpAxis() {
        NSValue val = (NSValue)this.getAttribute(SCNSceneAttribute.UpAxis);
        if (val != null) {
            return val.SCNVector3Value();
        }
        return null;
    }

    public SCNScene setUpAxis(SCNVector3 upAxis) {
        this.setAttribute(NSValue.valueOf(upAxis), SCNSceneAttribute.UpAxis);
        return this;
    }

    @Method(selector="attributeForKey:")
    public native NSObject getAttribute(SCNSceneAttribute var1);

    @Method(selector="setAttribute:forKey:")
    protected native void setAttribute(NSObject var1, SCNSceneAttribute var2);

    @Method(selector="writeToURL:options:delegate:progressHandler:")
    public native boolean writeToURL(NSURL var1, NSDictionary<NSString, ?> var2, SCNSceneExportDelegate var3, @Block VoidBlock3<Float, NSError, BooleanPtr> var4);

    @Method(selector="scene")
    public static native SCNScene create();

    @Method(selector="sceneNamed:")
    public static native SCNScene create(String var0);

    @Method(selector="sceneNamed:inDirectory:options:")
    public static native SCNScene create(String var0, String var1, SCNSceneSourceOptions var2);

    public static SCNScene create(NSURL url, SCNSceneSourceOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        SCNScene result = SCNScene.create(url, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="sceneWithURL:options:error:")
    private static native SCNScene create(NSURL var0, SCNSceneSourceOptions var1, NSError.NSErrorPtr var2);

    @Method(selector="addParticleSystem:withTransform:")
    public native void addParticleSystem(SCNParticleSystem var1, @ByVal SCNMatrix4 var2);

    @Method(selector="removeAllParticleSystems")
    public native void removeAllParticleSystems();

    @Method(selector="removeParticleSystem:")
    public native void removeParticleSystem(SCNParticleSystem var1);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        ObjCRuntime.bind(SCNScene.class);
    }

    public static class SCNScenePtr
    extends Ptr<SCNScene, SCNScenePtr> {
    }
}

