/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.uikit.UIEvent;
import org.robovm.apple.uikit.UIGestureRecognizerDelegate;
import org.robovm.apple.uikit.UIGestureRecognizerState;
import org.robovm.apple.uikit.UIPress;
import org.robovm.apple.uikit.UIPressType;
import org.robovm.apple.uikit.UIPressesEvent;
import org.robovm.apple.uikit.UITouch;
import org.robovm.apple.uikit.UITouchType;
import org.robovm.apple.uikit.UIView;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="UIKit")
@NativeClass
public class UIGestureRecognizer
extends NSObject {
    private static final Selector handleGesture;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ListenerWrapper> getListeners(boolean create) {
        Class<UIGestureRecognizer> clazz = UIGestureRecognizer.class;
        synchronized (UIGestureRecognizer.class) {
            LinkedList listeners = (LinkedList)this.getAssociatedObject(UIGestureRecognizer.class.getName() + ".listeners");
            if (listeners == null && create) {
                listeners = new LinkedList();
                this.setAssociatedObject(UIGestureRecognizer.class.getName() + ".listeners", listeners);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return listeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(OnGestureListener listener) {
        List<ListenerWrapper> listeners;
        ListenerWrapper wrapper = new ListenerWrapper(listener);
        List<ListenerWrapper> list = listeners = this.getListeners(true);
        synchronized (list) {
            listeners.add(wrapper);
        }
        this.addTarget(wrapper, handleGesture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(OnGestureListener listener) {
        List<ListenerWrapper> listeners = this.getListeners(false);
        if (listeners == null) {
            return;
        }
        List<ListenerWrapper> list = listeners;
        synchronized (list) {
            Iterator<ListenerWrapper> it = listeners.iterator();
            while (it.hasNext()) {
                ListenerWrapper wrapper = it.next();
                if (wrapper.listener != listener) continue;
                this.removeTarget(wrapper, handleGesture);
                it.remove();
                break;
            }
        }
    }

    public UIGestureRecognizer(OnGestureListener listener) {
        if (listener != null) {
            this.addListener(listener);
        }
    }

    public UIGestureRecognizer() {
    }

    protected UIGestureRecognizer(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected UIGestureRecognizer(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithTarget:action:")
    public UIGestureRecognizer(NSObject target, Selector action) {
        super(null);
        this.initObject(this.init(target, action));
    }

    @Property(selector="state")
    public native UIGestureRecognizerState getState();

    @Property(selector="delegate")
    public native UIGestureRecognizerDelegate getDelegate();

    @Property(selector="setDelegate:", strongRef=true)
    public native void setDelegate(UIGestureRecognizerDelegate var1);

    @Property(selector="isEnabled")
    public native boolean isEnabled();

    @Property(selector="setEnabled:")
    public native void setEnabled(boolean var1);

    @Property(selector="view")
    public native UIView getView();

    @Property(selector="cancelsTouchesInView")
    public native boolean cancelsTouchesInView();

    @Property(selector="setCancelsTouchesInView:")
    public native void setCancelsTouchesInView(boolean var1);

    @Property(selector="delaysTouchesBegan")
    public native boolean delaysTouchesBegan();

    @Property(selector="setDelaysTouchesBegan:")
    public native void setDelaysTouchesBegan(boolean var1);

    @Property(selector="delaysTouchesEnded")
    public native boolean delaysTouchesEnded();

    @Property(selector="setDelaysTouchesEnded:")
    public native void setDelaysTouchesEnded(boolean var1);

    @Property(selector="allowedTouchTypes")
    @Marshaler(value=UITouchType.AsListMarshaler.class)
    public native List<UITouchType> getAllowedTouchTypes();

    @Property(selector="setAllowedTouchTypes:")
    public native void setAllowedTouchTypes(@Marshaler(value=UITouchType.AsListMarshaler.class) List<UITouchType> var1);

    @Property(selector="allowedPressTypes")
    @Marshaler(value=UIPressType.AsListMarshaler.class)
    public native List<UIPressType> getAllowedPressTypes();

    @Property(selector="setAllowedPressTypes:")
    public native void setAllowedPressTypes(@Marshaler(value=UIPressType.AsListMarshaler.class) List<UIPressType> var1);

    @Property(selector="requiresExclusiveTouchType")
    public native boolean requiresExclusiveTouchType();

    @Property(selector="setRequiresExclusiveTouchType:")
    public native void setRequiresExclusiveTouchType(boolean var1);

    @Property(selector="numberOfTouches")
    @MachineSizedUInt
    public native long getNumberOfTouches();

    @Property(selector="name")
    public native String getName();

    @Property(selector="setName:")
    public native void setName(String var1);

    @Property(selector="setState:")
    public native void setState(UIGestureRecognizerState var1);

    @Method(selector="initWithTarget:action:")
    @Pointer
    protected native long init(NSObject var1, Selector var2);

    @Method(selector="addTarget:action:")
    public native void addTarget(NSObject var1, Selector var2);

    @Method(selector="removeTarget:action:")
    public native void removeTarget(NSObject var1, Selector var2);

    @Method(selector="requireGestureRecognizerToFail:")
    public native void requireGestureRecognizerToFail(UIGestureRecognizer var1);

    @Method(selector="locationInView:")
    @ByVal
    public native CGPoint getLocationInView(UIView var1);

    @Method(selector="locationOfTouch:inView:")
    @ByVal
    public native CGPoint getLocationOfTouch(@MachineSizedUInt long var1, UIView var3);

    @Method(selector="ignoreTouch:forEvent:")
    protected native void ignoreTouch(UITouch var1, UIEvent var2);

    @Method(selector="ignorePress:forEvent:")
    protected native void ignorePress(UIPress var1, UIPressesEvent var2);

    @Method(selector="reset")
    public native void reset();

    @Method(selector="canPreventGestureRecognizer:")
    public native boolean canPreventGestureRecognizer(UIGestureRecognizer var1);

    @Method(selector="canBePreventedByGestureRecognizer:")
    public native boolean canBePreventedByGestureRecognizer(UIGestureRecognizer var1);

    @Method(selector="shouldRequireFailureOfGestureRecognizer:")
    public native boolean shouldRequireFailureOfGestureRecognizer(UIGestureRecognizer var1);

    @Method(selector="shouldBeRequiredToFailByGestureRecognizer:")
    public native boolean shouldBeRequiredToFailByGestureRecognizer(UIGestureRecognizer var1);

    @Method(selector="touchesBegan:withEvent:")
    protected native void touchesBegan(NSSet<UITouch> var1, UIEvent var2);

    @Method(selector="touchesMoved:withEvent:")
    protected native void touchesMoved(NSSet<UITouch> var1, UIEvent var2);

    @Method(selector="touchesEnded:withEvent:")
    protected native void touchesEnded(NSSet<UITouch> var1, UIEvent var2);

    @Method(selector="touchesCancelled:withEvent:")
    protected native void touchesCancelled(NSSet<UITouch> var1, UIEvent var2);

    @Method(selector="touchesEstimatedPropertiesUpdated:")
    public native void touchesEstimatedPropertiesUpdated(NSSet<UITouch> var1);

    @Method(selector="pressesBegan:withEvent:")
    protected native void pressesBegan(NSSet<UIPress> var1, UIPressesEvent var2);

    @Method(selector="pressesChanged:withEvent:")
    protected native void pressesChanged(NSSet<UIPress> var1, UIPressesEvent var2);

    @Method(selector="pressesEnded:withEvent:")
    protected native void pressesEnded(NSSet<UIPress> var1, UIPressesEvent var2);

    @Method(selector="pressesCancelled:withEvent:")
    protected native void pressesCancelled(NSSet<UIPress> var1, UIPressesEvent var2);

    static {
        ObjCRuntime.bind(UIGestureRecognizer.class);
        handleGesture = Selector.register((String)"handleGesture:");
    }

    private static class ListenerWrapper
    extends NSObject {
        private final OnGestureListener listener;

        private ListenerWrapper(OnGestureListener listener) {
            this.listener = listener;
        }

        @Method(selector="handleGesture:")
        private void handleGesture(UIGestureRecognizer gestureRecognizer) {
            this.listener.onGesture(gestureRecognizer);
        }
    }

    public static interface OnGestureListener {
        public void onGesture(UIGestureRecognizer var1);
    }

    public static class UIGestureRecognizerPtr
    extends Ptr<UIGestureRecognizer, UIGestureRecognizerPtr> {
    }
}

