/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.HashSet;
import java.util.Set;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.Functions;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.CpuArch;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Label;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.Unreachable;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.trampoline.Trampoline;
import soot.SootClass;
import soot.SootMethod;

public abstract class AbstractMethodCompiler {
    protected Config config;
    protected Clazz clazz;
    protected SootClass sootClass;
    protected String className;
    protected SootMethod sootMethod;
    protected Set<Trampoline> trampolines;
    protected Set<String> catches;

    public AbstractMethodCompiler(Config config) {
        this.config = config;
    }

    public void reset(Clazz clazz) {
        this.clazz = clazz;
        this.sootClass = clazz.getSootClass();
        this.className = Types.getInternalName(this.sootClass);
    }

    public Set<Trampoline> getTrampolines() {
        return this.trampolines;
    }

    public Set<String> getCatches() {
        return this.catches;
    }

    public final Function compile(ModuleBuilder moduleBuilder, SootMethod method) {
        this.sootMethod = method;
        this.trampolines = new HashSet<Trampoline>();
        this.catches = new HashSet<String>();
        Function f = this.doCompile(moduleBuilder, method);
        if (method.isSynchronized()) {
            this.compileSynchronizedWrapper(moduleBuilder, method);
        }
        return f;
    }

    protected abstract Function doCompile(ModuleBuilder var1, SootMethod var2);

    protected Function createMethodFunction(SootMethod method) {
        return FunctionBuilder.method(method, this.config.getOs().getFamily() != OS.Family.darwin || this.config.getArch().getCpuArch() != CpuArch.x86);
    }

    private void compileSynchronizedWrapper(ModuleBuilder moduleBuilder, SootMethod method) {
        String targetName = Symbols.methodSymbol(method);
        Function syncFn = FunctionBuilder.synchronizedWrapper(method);
        moduleBuilder.addFunction(syncFn);
        FunctionType functionType = syncFn.getType();
        FunctionRef target = new FunctionRef(targetName, functionType);
        Value monitor = null;
        if (method.isStatic()) {
            FunctionRef fn = FunctionBuilder.ldcInternal(this.sootMethod.getDeclaringClass()).ref();
            monitor = Functions.call(syncFn, (Value)fn, syncFn.getParameterRef(0));
        } else {
            monitor = syncFn.getParameterRef(1);
        }
        Functions.call(syncFn, (Value)Functions.MONITORENTER, syncFn.getParameterRef(0), monitor);
        BasicBlockRef bbSuccess = syncFn.newBasicBlockRef(new Label("success"));
        BasicBlockRef bbFailure = syncFn.newBasicBlockRef(new Label("failure"));
        Functions.trycatchAllEnter(syncFn, bbSuccess, bbFailure);
        syncFn.newBasicBlock(bbSuccess.getLabel());
        Value result = Functions.call(syncFn, (Value)target, syncFn.getParameterRefs());
        Functions.trycatchLeave(syncFn);
        Functions.call(syncFn, (Value)Functions.MONITOREXIT, syncFn.getParameterRef(0), monitor);
        syncFn.add(new Ret(result));
        syncFn.newBasicBlock(bbFailure.getLabel());
        Functions.trycatchLeave(syncFn);
        Functions.call(syncFn, (Value)Functions.MONITOREXIT, syncFn.getParameterRef(0), monitor);
        Functions.call(syncFn, (Value)Functions.BC_THROW_IF_EXCEPTION_OCCURRED, syncFn.getParameterRef(0));
        syncFn.add(new Unreachable());
    }
}

