/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.clazz;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.robovm.compiler.clazz.AbstractPath;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.Clazzes;

public class Java9RuntimePath
extends AbstractPath {
    private final Map<String, JrtFilePathClass> knownClasses = new HashMap<String, JrtFilePathClass>();
    private final Path jrtModulesPath = FileSystems.getFileSystem(URI.create("jrt:/")).getPath("/modules", new String[0]);

    Java9RuntimePath(File file, Clazzes clazzes, int index, boolean inBootclasspath) {
        super(file, clazzes, index, inBootclasspath);
    }

    @Override
    protected Set<Clazz> doListClasses() {
        TreeSet<Clazz> s = new TreeSet<Clazz>();
        try (DirectoryStream<Path> modulesStream = Files.newDirectoryStream(this.jrtModulesPath);){
            for (Path module : modulesStream) {
                Files.walk(module, new FileVisitOption[0]).forEach(cls -> {
                    if (Files.isRegularFile(cls, new LinkOption[0]) && cls.toString().endsWith(".class")) {
                        String fileName = module.relativize((Path)cls).toString();
                        JrtFilePathClass path = new JrtFilePathClass(fileName, (Path)cls);
                        s.add(path);
                        this.knownClasses.put(fileName, path);
                    }
                });
            }
        }
        catch (FileSystemNotFoundException ex) {
            System.out.println("Could not read my modules (perhaps not Java 9?).");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return s;
    }

    @Override
    public boolean hasChangedSince(long timestamp) {
        try {
            long lastModified = Files.getLastModifiedTime(this.jrtModulesPath, new LinkOption[0]).toMillis();
            return lastModified > timestamp;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean contains(String file) {
        return this.knownClasses.containsKey(file);
    }

    @Override
    public InputStream open(String file) throws IOException {
        return Files.newInputStream(this.knownClasses.get(file).entry, new OpenOption[0]);
    }

    private class JrtFilePathClass
    extends Clazz {
        private final Path entry;

        JrtFilePathClass(String name, Path entry) {
            super(Java9RuntimePath.this.clazzes, name, Java9RuntimePath.this);
            this.entry = entry;
        }

        @Override
        public byte[] getBytes() throws IOException {
            return Files.readAllBytes(this.entry);
        }

        @Override
        public long lastModified() {
            try {
                return Files.getLastModifiedTime(this.entry, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

