/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.robovm.compiler.DependencyGraph;
import org.robovm.compiler.ITable;
import org.robovm.compiler.MarshalerLookup;
import org.robovm.compiler.VTable;
import org.robovm.compiler.Version;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.Clazzes;
import org.robovm.compiler.clazz.Path;
import org.robovm.compiler.config.AbstractQualified;
import org.robovm.compiler.config.AppExtension;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.CpuArch;
import org.robovm.compiler.config.Environment;
import org.robovm.compiler.config.ForceLinkMethodsConfig;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.config.PlatformVariant;
import org.robovm.compiler.config.Qualified;
import org.robovm.compiler.config.Resource;
import org.robovm.compiler.config.StripArchivesConfig;
import org.robovm.compiler.config.SwiftSupport;
import org.robovm.compiler.config.WatchKitApp;
import org.robovm.compiler.config.tools.Tools;
import org.robovm.compiler.llvm.DataLayout;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.plugin.CompilerPlugin;
import org.robovm.compiler.plugin.LaunchPlugin;
import org.robovm.compiler.plugin.Plugin;
import org.robovm.compiler.plugin.PluginArgument;
import org.robovm.compiler.plugin.TargetPlugin;
import org.robovm.compiler.plugin.annotation.AnnotationImplPlugin;
import org.robovm.compiler.plugin.debug.DebugInformationPlugin;
import org.robovm.compiler.plugin.debug.DebuggerLaunchPlugin;
import org.robovm.compiler.plugin.desugar.ByteBufferJava9ApiPlugin;
import org.robovm.compiler.plugin.desugar.StringConcatRewriterPlugin;
import org.robovm.compiler.plugin.lambda.LambdaPlugin;
import org.robovm.compiler.plugin.objc.InterfaceBuilderClassesPlugin;
import org.robovm.compiler.plugin.objc.ObjCBlockPlugin;
import org.robovm.compiler.plugin.objc.ObjCMemberPlugin;
import org.robovm.compiler.plugin.objc.ObjCProtocolProxyPlugin;
import org.robovm.compiler.plugin.objc.ObjCProtocolToObjCObjectPlugin;
import org.robovm.compiler.target.ConsoleTarget;
import org.robovm.compiler.target.Target;
import org.robovm.compiler.target.framework.FrameworkTarget;
import org.robovm.compiler.target.ios.IOSTarget;
import org.robovm.compiler.target.ios.ProvisioningProfile;
import org.robovm.compiler.target.ios.SigningIdentity;
import org.robovm.compiler.util.DigestUtil;
import org.robovm.compiler.util.InfoPList;
import org.robovm.compiler.util.io.RamDiskTools;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.convert.Registry;
import org.simpleframework.xml.convert.RegistryStrategy;
import org.simpleframework.xml.core.Persist;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.filter.Filter;
import org.simpleframework.xml.filter.PlatformFilter;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.RegistryMatcher;
import org.simpleframework.xml.transform.Transform;

@Root
public class Config {
    private static final int MAX_FILE_NAME_LENGTH = 255;
    @Element(required=false)
    private File installDir = null;
    @Element(required=false)
    private String executableName = null;
    @Element(required=false)
    private String imageName = null;
    @Element(required=false)
    private Boolean skipRuntimeLib = null;
    @Element(required=false)
    private File mainJar;
    @Element(required=false)
    private String mainClass;
    @Element(required=false)
    private Cacerts cacerts = null;
    @Element(required=false)
    private OS os = null;
    @ElementList(required=false, inline=true)
    private ArrayList<Arch> archs = null;
    @ElementList(required=false, entry="root")
    private ArrayList<String> roots;
    @ElementList(required=false, entry="pattern")
    private ArrayList<String> forceLinkClasses;
    @ElementList(required=false, entry="entry")
    private ArrayList<ForceLinkMethodsConfig> forceLinkMethods;
    @ElementList(required=false, entry="lib")
    private ArrayList<Lib> libs;
    @ElementList(required=false, entry="symbol")
    private ArrayList<String> exportedSymbols;
    @ElementList(required=false, entry="symbol")
    private ArrayList<String> unhideSymbols;
    @ElementList(required=false, entry="framework")
    private ArrayList<String> frameworks;
    @ElementList(required=false, entry="framework")
    private ArrayList<String> weakFrameworks;
    @ElementList(required=false, entry="path")
    private ArrayList<QualifiedFile> frameworkPaths;
    @ElementList(required=false, entry="extension")
    private ArrayList<AppExtension> appExtensions;
    @ElementList(required=false, entry="path")
    private ArrayList<QualifiedFile> appExtensionPaths;
    @Element(required=false)
    private SwiftSupport swiftSupport = null;
    @ElementList(required=false, entry="resource")
    private ArrayList<Resource> resources;
    @ElementList(required=false, entry="classpathentry")
    private ArrayList<File> bootclasspath;
    @ElementList(required=false, entry="classpathentry")
    private ArrayList<File> classpath;
    @ElementList(required=false, entry="argument")
    private ArrayList<String> pluginArguments;
    @Element(required=false, name="target")
    private String targetType;
    @Element(required=false, name="stripArchives")
    private StripArchivesConfig stripArchivesConfig;
    @Element(required=false, name="treeShaker")
    private TreeShakerMode treeShakerMode;
    @Element(required=false, name="smartSkipRebuild")
    private Boolean smartSkipRebuild;
    @Element(required=false)
    private String iosSdkVersion;
    @Element(required=false, name="iosInfoPList")
    private File iosInfoPListFile = null;
    @Element(required=false, name="infoPList")
    private File infoPListFile = null;
    @Element(required=false)
    private File iosEntitlementsPList;
    @Element(required=false)
    private WatchKitApp watchKitApp;
    @Element(required=false)
    private Tools tools;
    @Element(required=false)
    private Boolean enableBitcode;
    private SigningIdentity iosSignIdentity;
    private ProvisioningProfile iosProvisioningProfile;
    private String iosDeviceType;
    private InfoPList infoPList;
    private boolean iosSkipSigning = false;
    private Properties properties = new Properties();
    private Home home = null;
    private File tmpDir;
    private File cacheDir = new File(System.getProperty("user.home"), ".robovm/cache");
    private File ccBinPath = null;
    private boolean clean = false;
    private boolean debug = false;
    private boolean useDebugLibs = false;
    private boolean skipLinking = false;
    private boolean skipInstall = false;
    private boolean dumpIntermediates = false;
    private boolean manuallyPreparedForLaunch = false;
    private int threads = Runtime.getRuntime().availableProcessors();
    private Logger logger = Logger.NULL_LOGGER;
    private final transient UUID buildUuid;
    private transient List<Plugin> plugins = new ArrayList<Plugin>();
    private transient Target target = null;
    private transient File osArchDepLibDir;
    private transient File osArchCacheDir;
    private transient Clazzes clazzes;
    private transient VTable.Cache vtableCache;
    private transient ITable.Cache itableCache;
    private transient List<Path> resourcesPaths = new ArrayList<Path>();
    private transient DataLayout dataLayout;
    private transient MarshalerLookup marshalerLookup;
    private transient Config configBeforeBuild;
    private transient DependencyGraph dependencyGraph;
    private transient Arch sliceArch;
    private transient StripArchivesConfig.StripArchivesBuilder stripArchivesBuilder;

    protected Config(UUID uuid) {
        this.buildUuid = uuid;
        this.plugins.addAll(0, Arrays.asList(new InterfaceBuilderClassesPlugin(), new ObjCProtocolProxyPlugin(), new ObjCProtocolToObjCObjectPlugin(), new ObjCMemberPlugin(), new ObjCBlockPlugin(), new AnnotationImplPlugin(), new StringConcatRewriterPlugin(), new ByteBufferJava9ApiPlugin(), new LambdaPlugin(), new DebugInformationPlugin(), new DebuggerLaunchPlugin()));
        this.loadPluginsFromClassPath();
    }

    public Builder builder() throws IOException {
        return new Builder(Config.clone(this.configBeforeBuild));
    }

    public UUID getBuildUuid() {
        return this.buildUuid;
    }

    public Home getHome() {
        return this.home;
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public String getExecutableName() {
        return this.executableName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public File getExecutablePath() {
        return new File(this.installDir, this.getExecutableName());
    }

    public File getImagePath() {
        return this.getExecutablePath();
    }

    public File getCacheDir() {
        return this.osArchCacheDir;
    }

    public File getCcBinPath() {
        return this.ccBinPath;
    }

    public OS getOs() {
        return this.os;
    }

    public Arch getArch() {
        return this.sliceArch;
    }

    public List<Arch> getArchs() {
        return this.archs == null ? Collections.emptyList() : Collections.unmodifiableList(this.archs);
    }

    public String getTriple() {
        return this.getTriple(this.os.getMinVersion());
    }

    public String getTriple(String minVersion) {
        return this.sliceArch.getCpuArch().getLlvmName() + "-" + this.os.getVendor() + "-" + this.os.getLlvmName() + minVersion + this.sliceArch.getEnv().asLlvmSuffix("-");
    }

    public String getClangTriple() {
        return this.getClangTriple(this.os.getMinVersion());
    }

    public String getClangTriple(String minVersion) {
        return this.sliceArch.getCpuArch().getClangName() + "-" + this.os.getVendor() + "-" + this.os.getLlvmName() + minVersion + this.sliceArch.getEnv().asLlvmSuffix("-");
    }

    public DataLayout getDataLayout() {
        return this.dataLayout;
    }

    public boolean isClean() {
        return this.clean;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isUseDebugLibs() {
        return this.useDebugLibs;
    }

    public boolean isDumpIntermediates() {
        return this.dumpIntermediates;
    }

    public boolean isManuallyPreparedForLaunch() {
        return this.manuallyPreparedForLaunch;
    }

    public boolean isSkipRuntimeLib() {
        return this.skipRuntimeLib != null && this.skipRuntimeLib != false;
    }

    public boolean isSkipLinking() {
        return this.skipLinking;
    }

    public boolean isSkipInstall() {
        return this.skipInstall;
    }

    public int getThreads() {
        return this.threads;
    }

    public File getMainJar() {
        return this.mainJar;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public Cacerts getCacerts() {
        return this.cacerts == null ? Cacerts.full : this.cacerts;
    }

    public List<Path> getResourcesPaths() {
        return this.resourcesPaths;
    }

    public void addResourcesPath(Path path) {
        this.resourcesPaths.add(path);
    }

    public StripArchivesConfig getStripArchivesConfig() {
        return this.stripArchivesConfig == null ? StripArchivesConfig.DEFAULT : this.stripArchivesConfig;
    }

    public DependencyGraph getDependencyGraph() {
        return this.dependencyGraph;
    }

    public File getTmpDir() {
        if (this.tmpDir == null) {
            try {
                this.tmpDir = File.createTempFile("robovm", ".tmp");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.tmpDir.delete();
            this.tmpDir.mkdirs();
        }
        return this.tmpDir;
    }

    public List<String> getForceLinkClasses() {
        return this.forceLinkClasses == null ? Collections.emptyList() : Collections.unmodifiableList(this.forceLinkClasses);
    }

    public List<ForceLinkMethodsConfig> getForceLinkMethods() {
        return this.forceLinkMethods == null ? Collections.emptyList() : Collections.unmodifiableList(this.forceLinkMethods);
    }

    public List<String> getExportedSymbols() {
        return this.exportedSymbols == null ? Collections.emptyList() : Collections.unmodifiableList(this.exportedSymbols);
    }

    public List<String> getUnhideSymbols() {
        return this.unhideSymbols == null ? Collections.emptyList() : Collections.unmodifiableList(this.unhideSymbols);
    }

    public List<Lib> getLibs() {
        return this.libs == null ? Collections.emptyList() : this.libs.stream().filter(this::isQualified).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<String> getFrameworks() {
        return this.frameworks == null ? Collections.emptyList() : Collections.unmodifiableList(this.frameworks);
    }

    public List<String> getWeakFrameworks() {
        return this.weakFrameworks == null ? Collections.emptyList() : Collections.unmodifiableList(this.weakFrameworks);
    }

    public List<File> getFrameworkPaths() {
        return this.frameworkPaths == null ? Collections.emptyList() : this.frameworkPaths.stream().filter(this::isQualified).map(f -> f.entry).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<AppExtension> getAppExtensions() {
        return this.appExtensions == null ? Collections.emptyList() : Collections.unmodifiableList(this.appExtensions);
    }

    public List<File> getAppExtensionPaths() {
        return this.appExtensionPaths == null ? Collections.emptyList() : this.appExtensionPaths.stream().filter(this::isQualified).map(e -> e.entry).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public SwiftSupport getSwiftSupport() {
        return this.swiftSupport;
    }

    public boolean hasSwiftSupport() {
        return this.swiftSupport != null;
    }

    public List<File> getSwiftLibPaths() {
        return this.swiftSupport == null ? Collections.emptyList() : this.swiftSupport.getSwiftLibPaths().stream().filter(this::isQualified).map(f -> f.entry).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<Resource> getResources() {
        return this.resources == null ? Collections.emptyList() : Collections.unmodifiableList(this.resources);
    }

    public File getOsArchDepLibDir() {
        return this.osArchDepLibDir;
    }

    public Clazzes getClazzes() {
        return this.clazzes;
    }

    public VTable.Cache getVTableCache() {
        return this.vtableCache;
    }

    public ITable.Cache getITableCache() {
        return this.itableCache;
    }

    public MarshalerLookup getMarshalerLookup() {
        return this.marshalerLookup;
    }

    public List<CompilerPlugin> getCompilerPlugins() {
        ArrayList<CompilerPlugin> compilerPlugins = new ArrayList<CompilerPlugin>();
        for (Plugin plugin : this.plugins) {
            if (!(plugin instanceof CompilerPlugin)) continue;
            compilerPlugins.add((CompilerPlugin)plugin);
        }
        return compilerPlugins;
    }

    public List<LaunchPlugin> getLaunchPlugins() {
        ArrayList<LaunchPlugin> launchPlugins = new ArrayList<LaunchPlugin>();
        for (Plugin plugin : this.plugins) {
            if (!(plugin instanceof LaunchPlugin)) continue;
            launchPlugins.add((LaunchPlugin)plugin);
        }
        return launchPlugins;
    }

    public List<TargetPlugin> getTargetPlugins() {
        ArrayList<TargetPlugin> targetPlugins = new ArrayList<TargetPlugin>();
        for (Plugin plugin : this.plugins) {
            if (!(plugin instanceof TargetPlugin)) continue;
            targetPlugins.add((TargetPlugin)plugin);
        }
        return targetPlugins;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public List<String> getPluginArguments() {
        return this.pluginArguments == null ? Collections.emptyList() : Collections.unmodifiableList(this.pluginArguments);
    }

    public List<File> getBootclasspath() {
        return this.bootclasspath == null ? Collections.emptyList() : Collections.unmodifiableList(this.bootclasspath);
    }

    public List<File> getClasspath() {
        return this.classpath == null ? Collections.emptyList() : Collections.unmodifiableList(this.classpath);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Target getTarget() {
        return this.target;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public TreeShakerMode getTreeShakerMode() {
        return this.treeShakerMode == null ? TreeShakerMode.none : this.treeShakerMode;
    }

    public boolean isSmartSkipRebuild() {
        return this.smartSkipRebuild != null && this.smartSkipRebuild != false;
    }

    public String getIosSdkVersion() {
        return this.iosSdkVersion;
    }

    public String getIosDeviceType() {
        return this.iosDeviceType;
    }

    public InfoPList getIosInfoPList() {
        return this.getInfoPList();
    }

    public InfoPList getInfoPList() {
        if (this.infoPList == null && this.iosInfoPListFile != null) {
            this.infoPList = new InfoPList(this.iosInfoPListFile);
        } else if (this.infoPList == null && this.infoPListFile != null) {
            this.infoPList = new InfoPList(this.infoPListFile);
        }
        return this.infoPList;
    }

    public File getIosEntitlementsPList() {
        return this.iosEntitlementsPList;
    }

    public SigningIdentity getIosSignIdentity() {
        return this.iosSignIdentity;
    }

    public ProvisioningProfile getIosProvisioningProfile() {
        return this.iosProvisioningProfile;
    }

    public boolean isIosSkipSigning() {
        return this.iosSkipSigning;
    }

    public boolean isEnableBitcode() {
        return this.enableBitcode != null && this.enableBitcode != false && this.shouldEmitBitcode();
    }

    public boolean shouldEmitBitcode() {
        return !this.debug && this.os == OS.ios && this.sliceArch.getEnv() == Environment.Native && (this.sliceArch.getCpuArch() == CpuArch.arm64 || this.sliceArch.getCpuArch() == CpuArch.thumbv7);
    }

    public Tools getTools() {
        return this.tools;
    }

    public WatchKitApp getWatchKitApp() {
        return this.watchKitApp;
    }

    private static File makeFileRelativeTo(File dir, File f) {
        if (f.getParentFile() == null) {
            return dir;
        }
        return new File(Config.makeFileRelativeTo(dir, f.getParentFile()), f.getName());
    }

    public String getArchiveName(Path path) {
        if (path.getFile().isFile()) {
            return path.getFile().getName();
        }
        return "classes" + path.getIndex() + ".jar";
    }

    static String getFileName(Clazz clazz, String ext) {
        return Config.getFileName(clazz.getInternalName(), ext, 255);
    }

    static String getFileName(String internalName, String ext, int maxFileNameLength) {
        String packagePath = internalName.substring(0, internalName.lastIndexOf(47) + 1);
        String className = internalName.substring(internalName.lastIndexOf(47) + 1);
        String suffix = ext.startsWith(".") ? ext : "." + ext;
        int length = className.length() + suffix.length();
        if (length > maxFileNameLength) {
            String sha1 = DigestUtil.sha1(className);
            className = className.substring(0, Math.max(0, maxFileNameLength - suffix.length() - sha1.length())) + sha1;
        }
        return packagePath.replace('/', File.separatorChar) + className + suffix;
    }

    public File getLlFile(Clazz clazz) {
        return new File(this.getCacheDir(clazz.getPath()), Config.getFileName(clazz, "class.ll"));
    }

    public File getCFile(Clazz clazz) {
        return new File(this.getCacheDir(clazz.getPath()), Config.getFileName(clazz, "class.c"));
    }

    public File getBcFile(Clazz clazz) {
        return new File(this.getCacheDir(clazz.getPath()), Config.getFileName(clazz, "class.bc"));
    }

    public File getSFile(Clazz clazz) {
        return new File(this.getCacheDir(clazz.getPath()), Config.getFileName(clazz, "class.s"));
    }

    public File getOFile(Clazz clazz) {
        return new File(this.getCacheDir(clazz.getPath()), Config.getFileName(clazz, "class.o"));
    }

    public File getLinesOFile(Clazz clazz) {
        return new File(this.getCacheDir(clazz.getPath()), Config.getFileName(clazz, "class.lines.o"));
    }

    public File getLinesLlFile(Clazz clazz) {
        return new File(this.getCacheDir(clazz.getPath()), Config.getFileName(clazz, "class.lines.ll"));
    }

    public File getDebugInfoOFile(Clazz clazz) {
        return new File(this.getCacheDir(clazz.getPath()), Config.getFileName(clazz, "class.debuginfo.o"));
    }

    public File getDebugInfoLlFile(Clazz clazz) {
        return new File(this.getCacheDir(clazz.getPath()), Config.getFileName(clazz, "class.debuginfo.ll"));
    }

    public File getInfoFile(Clazz clazz) {
        return new File(this.getCacheDir(clazz.getPath()), Config.getFileName(clazz, "class.info"));
    }

    public File getCacheDir(Path path) {
        File srcRoot = path.getFile().getAbsoluteFile().getParentFile();
        String name = path.getFile().getName();
        try {
            return new File(Config.makeFileRelativeTo(this.osArchCacheDir, srcRoot.getCanonicalFile()), name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File getGeneratedClassDir(Path path) {
        File pathCacheDir = this.getCacheDir(path);
        return new File(pathCacheDir.getParentFile(), pathCacheDir.getName() + ".generated");
    }

    protected boolean isQualified(Qualified qualified) {
        if (qualified.filterPlatforms() != null && !Arrays.asList(qualified.filterPlatforms()).contains((Object)this.os)) {
            return false;
        }
        if (qualified.filterArch() != null && !Arrays.asList(qualified.filterArch()).contains(this.sliceArch)) {
            return false;
        }
        if (qualified.filterPlatformVariants() != null) {
            PlatformVariant variant = this.sliceArch.getEnv() == Environment.Native ? PlatformVariant.device : PlatformVariant.simulator;
            return Arrays.asList(qualified.filterPlatformVariants()).contains((Object)variant);
        }
        return true;
    }

    private static Map<Object, Object> getManifestAttributes(File jarFile) throws IOException {
        try (JarFile jf = new JarFile(jarFile);){
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(jf.getManifest().getMainAttributes());
            return hashMap;
        }
    }

    private static String getImplementationVersion(File jarFile) throws IOException {
        return (String)Config.getManifestAttributes(jarFile).get(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    private static String getMainClass(File jarFile) throws IOException {
        return (String)Config.getManifestAttributes(jarFile).get(Attributes.Name.MAIN_CLASS);
    }

    private File extractIfNeeded(Path path) throws IOException {
        if (path.getFile().isFile()) {
            File pathCacheDir = this.getCacheDir(path);
            File target = new File(pathCacheDir.getParentFile(), pathCacheDir.getName() + ".extracted");
            if (!target.exists() || path.getFile().lastModified() > target.lastModified()) {
                FileUtils.deleteDirectory((File)target);
                target.mkdirs();
                try (ZipFile zipFile = new ZipFile(path.getFile());){
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().startsWith("META-INF/robovm/") || entry.isDirectory()) continue;
                        File f = new File(target, entry.getName());
                        f.getParentFile().mkdirs();
                        InputStream in = zipFile.getInputStream(entry);
                        try (FileOutputStream out = new FileOutputStream(f);){
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                            if (entry.getTime() == -1L) continue;
                            f.setLastModified(entry.getTime());
                        }
                        finally {
                            if (in == null) continue;
                            in.close();
                        }
                    }
                }
                target.setLastModified(path.getFile().lastModified());
            }
            return target;
        }
        return path.getFile();
    }

    private <T> ArrayList<T> mergeLists(ArrayList<T> from, ArrayList<T> to) {
        if (from == null) {
            return to;
        }
        to = to != null ? to : new ArrayList<T>();
        for (T o : from) {
            if (to.contains(o)) continue;
            to.add(o);
        }
        return to;
    }

    private void mergeConfig(Config from, Config to) {
        to.exportedSymbols = this.mergeLists(from.exportedSymbols, to.exportedSymbols);
        to.unhideSymbols = this.mergeLists(from.unhideSymbols, to.unhideSymbols);
        to.forceLinkClasses = this.mergeLists(from.forceLinkClasses, to.forceLinkClasses);
        to.forceLinkMethods = this.mergeLists(from.forceLinkMethods, to.forceLinkMethods);
        to.frameworkPaths = this.mergeLists(from.frameworkPaths, to.frameworkPaths);
        to.frameworks = this.mergeLists(from.frameworks, to.frameworks);
        to.libs = this.mergeLists(from.libs, to.libs);
        to.resources = this.mergeLists(from.resources, to.resources);
        to.weakFrameworks = this.mergeLists(from.weakFrameworks, to.weakFrameworks);
    }

    private void mergeConfigsFromClasspath() throws IOException {
        List<String> dirs = Arrays.asList("META-INF/robovm/" + (Object)((Object)this.os) + "/" + this.sliceArch, "META-INF/robovm/" + (Object)((Object)this.os));
        Config config = new Config(this.buildUuid);
        block0: for (Path path : this.clazzes.getPaths()) {
            for (String dir : dirs) {
                if (!path.contains(dir + "/robovm.xml")) continue;
                File configXml = new File(new File(this.extractIfNeeded(path), dir), "robovm.xml");
                Builder builder = new Builder();
                builder.read(configXml);
                this.mergeConfig(builder.config, config);
                continue block0;
            }
        }
        this.mergeConfig(this, config);
        this.exportedSymbols = config.exportedSymbols;
        this.unhideSymbols = config.unhideSymbols;
        this.forceLinkClasses = config.forceLinkClasses;
        this.forceLinkMethods = config.forceLinkMethods;
        this.frameworkPaths = config.frameworkPaths;
        this.frameworks = config.frameworks;
        this.libs = config.libs;
        this.resources = config.resources;
        this.weakFrameworks = config.weakFrameworks;
    }

    private static <T> List<T> toList(Iterator<T> it) {
        ArrayList<T> l = new ArrayList<T>();
        while (it.hasNext()) {
            l.add(it.next());
        }
        return l;
    }

    private void loadPluginsFromClassPath() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ServiceLoader<CompilerPlugin> compilerPluginLoader = ServiceLoader.load(CompilerPlugin.class, classLoader);
        ServiceLoader<LaunchPlugin> launchPluginLoader = ServiceLoader.load(LaunchPlugin.class, classLoader);
        ServiceLoader<TargetPlugin> targetPluginLoader = ServiceLoader.load(TargetPlugin.class, classLoader);
        this.plugins.addAll(Config.toList(compilerPluginLoader.iterator()));
        this.plugins.addAll(Config.toList(launchPluginLoader.iterator()));
        this.plugins.addAll(Config.toList(targetPluginLoader.iterator()));
    }

    private static Config clone(Config config) throws IOException {
        Config clone = new Config(config.buildUuid);
        for (Field f : Config.class.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                Object o = f.get(config);
                if (o instanceof Collection && o instanceof Cloneable) {
                    Method m = o.getClass().getMethod("clone", new Class[0]);
                    o = m.invoke(o, new Object[0]);
                }
                f.set(clone, o);
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }
        return clone;
    }

    private Config build() throws IOException {
        ArrayList<File> realBootclasspath;
        this.configBeforeBuild = Config.clone(this);
        if (this.home == null) {
            this.home = Home.find();
        }
        if (this.bootclasspath == null) {
            this.bootclasspath = new ArrayList();
        }
        if (this.classpath == null) {
            this.classpath = new ArrayList();
        }
        if (this.mainJar != null) {
            this.mainClass = Config.getMainClass(this.mainJar);
            this.classpath.add(this.mainJar);
        }
        if (this.executableName == null && this.imageName != null) {
            this.executableName = this.imageName;
        }
        if (!this.skipLinking && this.executableName == null && this.mainClass == null) {
            throw new IllegalArgumentException("No target and no main class specified");
        }
        if (!this.skipLinking && this.classpath.isEmpty()) {
            throw new IllegalArgumentException("No classpath specified");
        }
        if (this.skipLinking) {
            this.skipInstall = true;
        }
        if (this.executableName == null) {
            this.executableName = this.mainClass;
        }
        if (this.imageName == null || !this.imageName.equals(this.executableName)) {
            this.imageName = this.executableName;
        }
        if (this.archs != null) {
            for (int idx = 0; idx < this.archs.size(); ++idx) {
                this.archs.set(idx, this.archs.get(idx).promoteTo(this.os));
            }
        }
        ArrayList<File> arrayList = realBootclasspath = this.bootclasspath == null ? new ArrayList<File>() : this.bootclasspath;
        if (!this.isSkipRuntimeLib()) {
            realBootclasspath = new ArrayList<File>(this.bootclasspath);
            realBootclasspath.add(0, this.home.rtPath);
        }
        this.vtableCache = new VTable.Cache();
        this.itableCache = new ITable.Cache();
        this.marshalerLookup = new MarshalerLookup(this);
        if (!this.skipInstall) {
            if (this.installDir == null) {
                this.installDir = new File(".", this.executableName);
            }
            this.installDir.mkdirs();
        }
        if (this.targetType != null) {
            if ("console".equals(this.targetType)) {
                this.target = new ConsoleTarget();
            } else if ("ios".equals(this.targetType)) {
                this.target = new IOSTarget();
            } else if (FrameworkTarget.matches(this.targetType)) {
                this.target = new FrameworkTarget(this.targetType);
            } else {
                for (TargetPlugin plugin : this.getTargetPlugins()) {
                    if (!plugin.getTarget().getType().equals(this.targetType)) continue;
                    this.target = plugin.getTarget();
                    break;
                }
                if (this.target == null) {
                    throw new IllegalArgumentException("Unsupported target '" + this.targetType + "'");
                }
            }
        } else {
            this.target = this.os == OS.ios ? new IOSTarget() : new ConsoleTarget();
        }
        if (!this.getArchs().isEmpty()) {
            this.sliceArch = this.getArchs().get(0);
        }
        this.target.init(this);
        this.os = this.target.getOs();
        this.sliceArch = this.target.getArch();
        this.dataLayout = new DataLayout(this.getTriple());
        this.osArchDepLibDir = new File(new File(this.home.libVmDir, this.os.toString()), this.sliceArch.toString());
        if (this.treeShakerMode != null && this.treeShakerMode != TreeShakerMode.none && this.os.getFamily() == OS.Family.darwin && this.sliceArch.getCpuArch() == CpuArch.x86) {
            this.logger.warn("Tree shaking is not supported when building for OS X/iOS x86 32-bit due to a bug in Xcode's linker. No tree shaking will be performed. Run in 64-bit mode instead to use tree shaking.", new Object[0]);
            this.treeShakerMode = TreeShakerMode.none;
        }
        this.dependencyGraph = new DependencyGraph(this.getTreeShakerMode());
        RamDiskTools ramDiskTools = new RamDiskTools();
        ramDiskTools.setupRamDisk(this, this.cacheDir, this.tmpDir);
        this.cacheDir = ramDiskTools.getCacheDir();
        this.tmpDir = ramDiskTools.getTmpDir();
        File osDir = new File(this.cacheDir, this.os.toString());
        String archName = this.sliceArch.toString();
        File archDir = new File(osDir, archName);
        this.osArchCacheDir = new File(archDir, this.debug ? "debug" : "release");
        this.osArchCacheDir.mkdirs();
        this.clazzes = new Clazzes(this, realBootclasspath, this.classpath);
        if (this.stripArchivesConfig == null) {
            this.stripArchivesConfig = this.stripArchivesBuilder == null ? StripArchivesConfig.DEFAULT : this.stripArchivesBuilder.build();
        }
        this.mergeConfigsFromClasspath();
        return this;
    }

    public static Config loadRawConfig(File contentRoot) throws IOException {
        Builder builder = new Builder();
        builder.readProjectProperties(contentRoot, false);
        builder.readProjectConfig(contentRoot, false);
        return builder.config;
    }

    public static enum Cacerts {
        full;

    }

    public static enum TreeShakerMode {
        none,
        conservative,
        aggressive;

    }

    public static class Home {
        private File binDir;
        private File libVmDir;
        private File rtPath;
        private Map<Cacerts, File> cacertsPath;
        private boolean dev = false;

        public Home(File homeDir) {
            this(homeDir, true);
        }

        protected Home(File homeDir, boolean validate) {
            if (validate) {
                Home.validate(homeDir);
            }
            this.binDir = new File(homeDir, "bin");
            this.libVmDir = new File(homeDir, "lib/vm");
            this.rtPath = new File(homeDir, "lib/robovm-rt.jar");
            this.cacertsPath = new HashMap<Cacerts, File>();
            this.cacertsPath.put(Cacerts.full, new File(homeDir, "lib/robovm-cacerts-full.jar"));
        }

        private Home(File devDir, File binDir, File libVmDir, File rtPath) {
            this.binDir = binDir;
            this.libVmDir = libVmDir;
            this.rtPath = rtPath;
            this.cacertsPath = new HashMap<Cacerts, File>();
            this.cacertsPath.put(Cacerts.full, new File(devDir, "cacerts/full/target/robovm-cacerts-full-" + Version.getVersion() + ".jar"));
            this.dev = true;
        }

        public boolean isDev() {
            return this.dev;
        }

        public File getBinDir() {
            return this.binDir;
        }

        public File getLibVmDir() {
            return this.libVmDir;
        }

        public File getRtPath() {
            return this.rtPath;
        }

        public File getCacertsPath(Cacerts cacerts) {
            return this.cacertsPath.get((Object)cacerts);
        }

        public static Home find() {
            if (System.getenv("ROBOVM_DEV_ROOT") != null) {
                File dir = new File(System.getenv("ROBOVM_DEV_ROOT"));
                return Home.validateDevRootDir(dir);
            }
            if (System.getProperty("ROBOVM_DEV_ROOT") != null) {
                File dir = new File(System.getProperty("ROBOVM_DEV_ROOT"));
                return Home.validateDevRootDir(dir);
            }
            if (System.getenv("ROBOVM_HOME") != null) {
                File dir = new File(System.getenv("ROBOVM_HOME"));
                return new Home(dir);
            }
            ArrayList<File> candidates = new ArrayList<File>();
            File userHome = new File(System.getProperty("user.home"));
            candidates.add(new File(userHome, "Applications/robovm"));
            candidates.add(new File(userHome, ".robovm/home"));
            candidates.add(new File("/usr/local/lib/robovm"));
            candidates.add(new File("/opt/robovm"));
            candidates.add(new File("/usr/lib/robovm"));
            for (File dir : candidates) {
                if (!dir.exists()) continue;
                return new Home(dir);
            }
            throw new IllegalArgumentException("ROBOVM_HOME not set and no RoboVM installation found in " + candidates);
        }

        public static void validate(File dir) {
            String error = "Path " + dir + " is not a valid RoboVM install directory: ";
            if (!dir.exists()) {
                throw new IllegalArgumentException(error + "no such path");
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException(error + "not a directory");
            }
            File libDir = new File(dir, "lib");
            if (!libDir.exists() || !libDir.isDirectory()) {
                throw new IllegalArgumentException(error + "lib/ missing or invalid");
            }
            File binDir = new File(dir, "bin");
            if (!binDir.exists() || !binDir.isDirectory()) {
                throw new IllegalArgumentException(error + "bin/ missing or invalid");
            }
            File libVmDir = new File(libDir, "vm");
            if (!libVmDir.exists() || !libVmDir.isDirectory()) {
                throw new IllegalArgumentException(error + "lib/vm/ missing or invalid");
            }
            File rtJarFile = new File(libDir, "robovm-rt.jar");
            if (!rtJarFile.exists() || !rtJarFile.isFile()) {
                throw new IllegalArgumentException(error + "lib/robovm-rt.jar missing or invalid");
            }
            try {
                String thisVersion = Version.getVersion();
                String thatVersion = Config.getImplementationVersion(rtJarFile);
                if (thisVersion == null || !thisVersion.equals(thatVersion)) {
                    throw new IllegalArgumentException(error + "version mismatch (expected: " + thisVersion + ", was: " + thatVersion + ")");
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(error + "failed to get version of rt jar", e);
            }
        }

        private static Home validateDevRootDir(File dir) {
            String error = "Path " + dir + " is not a valid RoboVM source tree: ";
            if (!dir.exists()) {
                throw new IllegalArgumentException(error + "no such path");
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException(error + "not a directory");
            }
            File vmBinariesDir = new File(dir, "vm/target/binaries");
            if (!vmBinariesDir.exists() || !vmBinariesDir.isDirectory()) {
                throw new IllegalArgumentException(error + "vm/target/binaries/ missing or invalid");
            }
            File binDir = new File(dir, "bin");
            if (!binDir.exists() || !binDir.isDirectory()) {
                throw new IllegalArgumentException(error + "bin/ missing or invalid");
            }
            String rtJarName = "robovm-rt-" + Version.getVersion() + ".jar";
            File rtJar = new File(dir, "rt/target/" + rtJarName);
            File rtClasses = new File(dir, "rt/target/classes/");
            File rtSource = rtJar;
            if (!rtJar.exists() || rtJar.isDirectory()) {
                if (!rtClasses.exists() || rtClasses.isFile()) {
                    throw new IllegalArgumentException(error + "rt/target/" + rtJarName + " missing or invalid");
                }
                rtSource = rtClasses;
            }
            return new Home(dir, binDir, vmBinariesDir, rtSource);
        }
    }

    public static class Builder {
        protected final Config config;

        Builder(Config config) {
            this.config = config;
        }

        public Builder() {
            this.config = new Config(UUID.randomUUID());
        }

        public Builder os(OS os) {
            this.config.os = os;
            return this;
        }

        public Builder arch(Arch arch) {
            return this.archs(arch);
        }

        public Builder archs(Arch ... archs) {
            return this.archs(Arrays.asList(archs));
        }

        public Builder archs(List<Arch> archs) {
            if (this.config.archs == null) {
                this.config.archs = new ArrayList();
            }
            this.config.archs.clear();
            this.config.archs.addAll(archs);
            return this;
        }

        public Builder clearClasspathEntries() {
            if (this.config.classpath != null) {
                this.config.classpath.clear();
            }
            return this;
        }

        public Builder addClasspathEntry(File f) {
            if (this.config.classpath == null) {
                this.config.classpath = new ArrayList();
            }
            this.config.classpath.add(f);
            return this;
        }

        public Builder clearBootClasspathEntries() {
            if (this.config.bootclasspath != null) {
                this.config.bootclasspath.clear();
            }
            return this;
        }

        public Builder addBootClasspathEntry(File f) {
            if (this.config.bootclasspath == null) {
                this.config.bootclasspath = new ArrayList();
            }
            this.config.bootclasspath.add(f);
            return this;
        }

        public Builder mainJar(File f) {
            this.config.mainJar = f;
            return this;
        }

        public Builder installDir(File installDir) {
            this.config.installDir = installDir;
            return this;
        }

        public Builder executableName(String executableName) {
            this.config.executableName = executableName;
            return this;
        }

        public Builder imageName(String imageName) {
            this.config.imageName = imageName;
            return this;
        }

        public Builder home(Home home) {
            this.config.home = home;
            return this;
        }

        public Builder cacheDir(File cacheDir) {
            this.config.cacheDir = cacheDir;
            return this;
        }

        public Builder clean(boolean b) {
            this.config.clean = b;
            return this;
        }

        public Builder ccBinPath(File ccBinPath) {
            this.config.ccBinPath = ccBinPath;
            return this;
        }

        public Builder debug(boolean b) {
            this.config.debug = b;
            return this;
        }

        public Builder useDebugLibs(boolean b) {
            this.config.useDebugLibs = b;
            return this;
        }

        public Builder dumpIntermediates(boolean b) {
            this.config.dumpIntermediates = b;
            return this;
        }

        public Builder manuallyPreparedForLaunch(boolean b) {
            this.config.manuallyPreparedForLaunch = b;
            return this;
        }

        public Builder skipRuntimeLib(boolean b) {
            this.config.skipRuntimeLib = b;
            return this;
        }

        public Builder skipLinking(boolean b) {
            this.config.skipLinking = b;
            return this;
        }

        public Builder skipInstall(boolean b) {
            this.config.skipInstall = b;
            return this;
        }

        public Builder threads(int threads) {
            this.config.threads = threads;
            return this;
        }

        public Builder mainClass(String mainClass) {
            this.config.mainClass = mainClass;
            return this;
        }

        public Builder tmpDir(File tmpDir) {
            this.config.tmpDir = tmpDir;
            return this;
        }

        public Builder logger(Logger logger) {
            this.config.logger = logger;
            return this;
        }

        public Builder treeShakerMode(TreeShakerMode treeShakerMode) {
            this.config.treeShakerMode = treeShakerMode;
            return this;
        }

        public Builder smartSkipRebuild(boolean smartSkipRebuild) {
            this.config.smartSkipRebuild = smartSkipRebuild;
            return this;
        }

        public Builder clearForceLinkClasses() {
            if (this.config.forceLinkClasses != null) {
                this.config.forceLinkClasses.clear();
            }
            return this;
        }

        public Builder addForceLinkClass(String pattern) {
            if (this.config.forceLinkClasses == null) {
                this.config.forceLinkClasses = new ArrayList();
            }
            this.config.forceLinkClasses.add(pattern);
            return this;
        }

        public Builder clearExportedSymbols() {
            if (this.config.exportedSymbols != null) {
                this.config.exportedSymbols.clear();
            }
            return this;
        }

        public Builder addExportedSymbol(String symbol) {
            if (this.config.exportedSymbols == null) {
                this.config.exportedSymbols = new ArrayList();
            }
            this.config.exportedSymbols.add(symbol);
            return this;
        }

        public Builder clearUnhideSymbols() {
            if (this.config.unhideSymbols != null) {
                this.config.unhideSymbols.clear();
            }
            return this;
        }

        public Builder addUnhideSymbol(String symbol) {
            if (this.config.unhideSymbols == null) {
                this.config.unhideSymbols = new ArrayList();
            }
            this.config.unhideSymbols.add(symbol);
            return this;
        }

        public Builder clearLibs() {
            if (this.config.libs != null) {
                this.config.libs.clear();
            }
            return this;
        }

        public Builder addLib(Lib lib) {
            if (this.config.libs == null) {
                this.config.libs = new ArrayList();
            }
            this.config.libs.add(lib);
            return this;
        }

        public Builder clearFrameworks() {
            if (this.config.frameworks != null) {
                this.config.frameworks.clear();
            }
            return this;
        }

        public Builder addFramework(String framework) {
            if (this.config.frameworks == null) {
                this.config.frameworks = new ArrayList();
            }
            this.config.frameworks.add(framework);
            return this;
        }

        public Builder clearWeakFrameworks() {
            if (this.config.weakFrameworks != null) {
                this.config.weakFrameworks.clear();
            }
            return this;
        }

        public Builder addWeakFramework(String framework) {
            if (this.config.weakFrameworks == null) {
                this.config.weakFrameworks = new ArrayList();
            }
            this.config.weakFrameworks.add(framework);
            return this;
        }

        public Builder clearFrameworkPaths() {
            if (this.config.frameworkPaths != null) {
                this.config.frameworkPaths.clear();
            }
            return this;
        }

        public Builder addFrameworkPath(File frameworkPath) {
            if (this.config.frameworkPaths == null) {
                this.config.frameworkPaths = new ArrayList();
            }
            this.config.frameworkPaths.add(new QualifiedFile(frameworkPath));
            return this;
        }

        public Builder clearExtensions() {
            if (this.config.appExtensions != null) {
                this.config.appExtensions.clear();
            }
            return this;
        }

        public Builder addExtension(String name, String profile) {
            if (this.config.appExtensions == null) {
                this.config.appExtensions = new ArrayList();
            }
            AppExtension extension = new AppExtension();
            extension.name = name;
            extension.profile = profile;
            this.config.appExtensions.add(extension);
            return this;
        }

        public Builder clearExtensionPaths() {
            if (this.config.appExtensionPaths != null) {
                this.config.appExtensionPaths.clear();
            }
            return this;
        }

        public Builder addExtenaionPath(File extensionPath) {
            if (this.config.appExtensionPaths == null) {
                this.config.appExtensionPaths = new ArrayList();
            }
            this.config.appExtensionPaths.add(new QualifiedFile(extensionPath));
            return this;
        }

        public Builder clearResources() {
            if (this.config.resources != null) {
                this.config.resources.clear();
            }
            return this;
        }

        public Builder addResource(Resource resource) {
            if (this.config.resources == null) {
                this.config.resources = new ArrayList();
            }
            this.config.resources.add(resource);
            return this;
        }

        public Builder stripArchivesBuilder(StripArchivesConfig.StripArchivesBuilder stripArchivesBuilder) {
            this.config.stripArchivesBuilder = stripArchivesBuilder;
            return this;
        }

        public Builder targetType(String targetType) {
            this.config.targetType = targetType;
            return this;
        }

        public Builder clearProperties() {
            this.config.properties.clear();
            return this;
        }

        public Builder addProperties(Properties properties) {
            this.config.properties.putAll((Map<?, ?>)properties);
            return this;
        }

        public Builder addProperties(File file) throws IOException {
            Properties props = new Properties();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                props.load(reader);
                this.addProperties(props);
            }
            return this;
        }

        public Builder addProperty(String name, String value) {
            this.config.properties.put(name, value);
            return this;
        }

        public Builder cacerts(Cacerts cacerts) {
            this.config.cacerts = cacerts;
            return this;
        }

        public Builder tools(Tools tools) {
            this.config.tools = tools;
            return this;
        }

        public Builder iosSdkVersion(String sdkVersion) {
            this.config.iosSdkVersion = sdkVersion;
            return this;
        }

        public Builder iosDeviceType(String deviceType) {
            this.config.iosDeviceType = deviceType;
            return this;
        }

        public Builder iosInfoPList(File infoPList) {
            this.config.iosInfoPListFile = infoPList;
            return this;
        }

        public Builder infoPList(File infoPList) {
            this.config.infoPListFile = infoPList;
            return this;
        }

        public Builder iosEntitlementsPList(File entitlementsPList) {
            this.config.iosEntitlementsPList = entitlementsPList;
            return this;
        }

        public Builder iosSignIdentity(SigningIdentity signIdentity) {
            this.config.iosSignIdentity = signIdentity;
            return this;
        }

        public Builder iosProvisioningProfile(ProvisioningProfile iosProvisioningProfile) {
            this.config.iosProvisioningProfile = iosProvisioningProfile;
            return this;
        }

        public Builder iosSkipSigning(boolean b) {
            this.config.iosSkipSigning = b;
            return this;
        }

        public Builder addCompilerPlugin(CompilerPlugin compilerPlugin) {
            this.config.plugins.add(compilerPlugin);
            return this;
        }

        public Builder addLaunchPlugin(LaunchPlugin plugin) {
            this.config.plugins.add(plugin);
            return this;
        }

        public Builder addTargetPlugin(TargetPlugin plugin) {
            this.config.plugins.add(plugin);
            return this;
        }

        public Builder enableBitcode(boolean enableBitcode) {
            this.config.enableBitcode = enableBitcode;
            return this;
        }

        public void addPluginArgument(String argName) {
            if (this.config.pluginArguments == null) {
                this.config.pluginArguments = new ArrayList();
            }
            this.config.pluginArguments.add(argName);
        }

        public Config build() throws IOException {
            for (CompilerPlugin plugin : this.config.getCompilerPlugins()) {
                plugin.beforeConfig(this, this.config);
            }
            return this.config.build();
        }

        public void readProjectProperties(File basedir, boolean isTest) throws IOException {
            File testPropsFile = new File(basedir, "robovm.test.properties");
            File localPropsFile = new File(basedir, "robovm.local.properties");
            File propsFile = new File(basedir, "robovm.properties");
            if (isTest && testPropsFile.exists()) {
                this.config.logger.info("Loading test RoboVM config properties file: " + testPropsFile.getAbsolutePath(), new Object[0]);
                this.addProperties(testPropsFile);
            } else {
                InputStreamReader reader;
                Properties props = new Properties();
                if (propsFile.exists()) {
                    this.config.logger.info("Loading default RoboVM config properties file: " + propsFile.getAbsolutePath(), new Object[0]);
                    reader = new InputStreamReader((InputStream)new FileInputStream(propsFile), StandardCharsets.UTF_8);
                    try {
                        props.load(reader);
                    }
                    finally {
                        ((Reader)reader).close();
                    }
                }
                if (localPropsFile.exists()) {
                    this.config.logger.info("Loading local RoboVM config properties file: " + localPropsFile.getAbsolutePath(), new Object[0]);
                    reader = new InputStreamReader((InputStream)new FileInputStream(localPropsFile), StandardCharsets.UTF_8);
                    try {
                        props.load(reader);
                    }
                    finally {
                        ((Reader)reader).close();
                    }
                }
                if (isTest) {
                    this.modifyPropertyForTest(props, "app.id");
                    this.modifyPropertyForTest(props, "app.name");
                    this.modifyPropertyForTest(props, "app.executable");
                }
                this.addProperties(props);
            }
        }

        private void modifyPropertyForTest(Properties props, String propName) {
            String propValue = props.getProperty(propName);
            if (propValue != null && !propValue.endsWith("Test")) {
                String newPropValue = propValue + "Test";
                this.config.logger.info("Changing %s property from '%s' to '%s'", propName, propValue, newPropValue);
                props.setProperty(propName, newPropValue);
            }
        }

        public void readProjectConfig(File basedir, boolean isTest) throws IOException {
            File testConfigFile = new File(basedir, "robovm.test.xml");
            File configFile = new File(basedir, "robovm.xml");
            if (isTest && testConfigFile.exists()) {
                this.config.logger.info("Loading test RoboVM config file: " + testConfigFile.getAbsolutePath(), new Object[0]);
                this.read(testConfigFile);
            } else if (configFile.exists()) {
                this.config.logger.info("Loading default RoboVM config file: " + configFile.getAbsolutePath(), new Object[0]);
                this.read(configFile);
            }
        }

        public void read(File file) throws IOException {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                this.read(reader, file.getAbsoluteFile().getParentFile());
            }
        }

        public void read(Reader reader, File wd) throws IOException {
            try {
                Serializer serializer = Builder.createSerializer(this.config, wd);
                serializer.read((Object)this.config, reader);
            }
            catch (IOException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (this.config.roots != null && !this.config.roots.isEmpty()) {
                if (this.config.forceLinkClasses == null) {
                    this.config.forceLinkClasses = new ArrayList();
                }
                this.config.forceLinkClasses.addAll(this.config.roots);
                this.config.roots = null;
            }
        }

        public void write(File file) throws IOException {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                this.write(writer, file.getAbsoluteFile().getParentFile());
            }
        }

        public void write(Writer writer, File wd) throws IOException {
            try {
                Serializer serializer = Builder.createSerializer(this.config, wd);
                serializer.write((Object)this.config, writer);
            }
            catch (IOException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public static Serializer createSerializer(Config config, File wd) throws Exception {
            RelativeFileConverter fileConverter = new RelativeFileConverter(wd);
            Persister resourceSerializer = new Persister((Strategy)new RegistryStrategy(new Registry().bind(File.class, (Converter)fileConverter)), (Filter)new PlatformFilter((Map)config.properties), new Format(2));
            Registry registry = new Registry();
            RegistryStrategy registryStrategy = new RegistryStrategy(registry);
            RegistryMatcher matcher = new RegistryMatcher();
            Persister serializer = new Persister((Strategy)registryStrategy, (Filter)new PlatformFilter((Map)config.properties), (Matcher)matcher, new Format(2));
            registry.bind(File.class, (Converter)fileConverter);
            registry.bind(Resource.class, (Converter)new ResourceConverter(fileConverter, (Serializer)resourceSerializer));
            registry.bind(StripArchivesConfig.class, (Converter)new StripArchivesConfigConverter());
            matcher.bind(File.class, (Transform)fileConverter);
            matcher.bind(Arch.class, (Transform)new ArchTransformer());
            matcher.bind(Lib.PathWrap.class, (Transform)new RelativeLibPathTransformer(fileConverter));
            matcher.bind(OS[].class, new EnumArrayConverter(OS.class));
            matcher.bind(Arch[].class, (Transform)new ArchArrayConverter());
            matcher.bind(PlatformVariant[].class, new EnumArrayConverter(PlatformVariant.class));
            return serializer;
        }

        public Map<String, PluginArgument> fetchPluginArguments() {
            TreeMap<String, PluginArgument> args = new TreeMap<String, PluginArgument>();
            for (Plugin plugin : this.config.plugins) {
                for (PluginArgument arg : plugin.getArguments().getArguments()) {
                    args.put(plugin.getArguments().getPrefix() + ":" + arg.getName(), arg);
                }
            }
            return args;
        }

        public List<Plugin> getPlugins() {
            return this.config.getPlugins();
        }
    }

    public static final class QualifiedFile
    extends AbstractQualified {
        @Text
        File entry;

        protected QualifiedFile() {
        }

        public QualifiedFile(File file) {
            this.entry = file;
        }

        public File getEntry() {
            return this.entry;
        }

        @Override
        public String toString() {
            return this.entry + " " + super.toString();
        }
    }

    private static final class StripArchivesConfigConverter
    implements Converter<StripArchivesConfig> {
        private StripArchivesConfigConverter() {
        }

        public StripArchivesConfig read(InputNode node) throws Exception {
            InputNode childNode;
            StripArchivesConfig.StripArchivesBuilder cfgBuilder = new StripArchivesConfig.StripArchivesBuilder();
            while ((childNode = node.getNext()) != null) {
                if ((!childNode.isElement() || childNode.isEmpty() || !childNode.getName().equals("include")) && !childNode.getName().equals("exclude")) continue;
                boolean isInclude = childNode.getName().equals("include");
                cfgBuilder.add(isInclude, childNode.getValue());
            }
            return cfgBuilder.build();
        }

        public void write(OutputNode node, StripArchivesConfig config) throws Exception {
            if (config.getPatterns() != null && !config.getPatterns().isEmpty()) {
                for (StripArchivesConfig.Pattern pattern : config.getPatterns()) {
                    OutputNode child = node.getChild(pattern.isInclude() ? "include" : "exclude");
                    child.setValue(pattern.getPatternAsString());
                    child.commit();
                }
            }
            node.commit();
        }
    }

    private static final class ResourceConverter
    implements Converter<Resource> {
        private final RelativeFileConverter fileConverter;
        private final Serializer serializer;

        public ResourceConverter(RelativeFileConverter fileConverter, Serializer serializer) {
            this.fileConverter = fileConverter;
            this.serializer = serializer;
        }

        public Resource read(InputNode node) throws Exception {
            String value = node.getValue();
            if (value != null && value.trim().length() > 0) {
                return new Resource(this.fileConverter.read(value));
            }
            return (Resource)this.serializer.read(Resource.class, node);
        }

        public void write(OutputNode node, Resource resource) throws Exception {
            File path = resource.getPath();
            if (path != null) {
                this.fileConverter.write(node, path);
            } else {
                node.remove();
                this.serializer.write((Object)resource, node.getParent());
            }
        }
    }

    private static final class RelativeFileConverter
    implements Converter<File>,
    Transform<File> {
        private final String wdPrefix;

        public RelativeFileConverter(File wd) {
            String prefix;
            if (wd.isFile()) {
                wd = wd.getParentFile();
            }
            if ((prefix = wd.getAbsolutePath()).endsWith(File.separator)) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            this.wdPrefix = prefix;
        }

        public File read(String value) {
            if (value == null) {
                return null;
            }
            File file = new File(value);
            if (!file.isAbsolute()) {
                file = new File(this.wdPrefix, value);
            }
            return file;
        }

        public File read(InputNode node) throws Exception {
            return this.read(node.getValue());
        }

        public String write(File value) {
            String path;
            String string = path = value.isAbsolute() ? value.getAbsolutePath() : value.getPath();
            if (value.isAbsolute() && path.startsWith(this.wdPrefix)) {
                path = path.length() == this.wdPrefix.length() ? "" : path.substring(this.wdPrefix.length() + 1);
            }
            return path;
        }

        public void write(OutputNode node, File value) throws Exception {
            String path = this.write(value);
            if (path.isEmpty()) {
                if ("directory".equals(node.getName())) {
                    node.remove();
                } else {
                    node.setValue("");
                }
            } else {
                node.setValue(path);
            }
        }
    }

    private static final class EnumArrayConverter<T extends Enum<T>>
    implements Transform<T[]> {
        private final Class<T> enumClass;

        private EnumArrayConverter(Class<T> enumClass) {
            this.enumClass = enumClass;
        }

        public T[] read(String s) {
            if ((s = s.trim()).isEmpty()) {
                return null;
            }
            String[] tokens = s.split(",");
            Enum[] res = (Enum[])Array.newInstance(this.enumClass, tokens.length);
            for (int idx = 0; idx < tokens.length; ++idx) {
                res[idx] = Enum.valueOf(this.enumClass, tokens[idx].trim());
            }
            return res;
        }

        public String write(T[] ts) {
            return Arrays.stream(ts).map(Enum::name).collect(Collectors.joining());
        }
    }

    private static final class ArchArrayConverter
    implements Transform<Arch[]> {
        private ArchArrayConverter() {
        }

        public Arch[] read(String s) {
            if ((s = s.trim()).isEmpty()) {
                return null;
            }
            String[] tokens = s.split(",");
            Arch[] res = new Arch[tokens.length];
            for (int idx = 0; idx < tokens.length; ++idx) {
                res[idx] = Arch.parse(tokens[idx].trim());
            }
            return res;
        }

        public String write(Arch[] ts) {
            return Arrays.stream(ts).map(Arch::toString).collect(Collectors.joining());
        }
    }

    private static final class ArchTransformer
    implements Transform<Arch> {
        private ArchTransformer() {
        }

        public Arch read(String value) throws Exception {
            if (value == null) {
                return null;
            }
            return Arch.parse(value);
        }

        public String write(Arch s) throws Exception {
            if (s != null) {
                return s.toString();
            }
            return null;
        }
    }

    private static final class RelativeLibPathTransformer
    implements Transform<Lib.PathWrap> {
        private final RelativeFileConverter fileConverter;

        public RelativeLibPathTransformer(RelativeFileConverter fileConverter) {
            this.fileConverter = fileConverter;
        }

        public Lib.PathWrap read(String value) throws Exception {
            File f;
            if (value == null) {
                return null;
            }
            if (value.endsWith(".a") || value.endsWith(".o")) {
                value = this.fileConverter.read(value).getAbsolutePath();
            } else if ((value.endsWith(".dylib") || value.endsWith(".so")) && (f = this.fileConverter.read(value)).isFile()) {
                value = f.getAbsolutePath();
            }
            return new Lib.PathWrap(value);
        }

        public String write(Lib.PathWrap wrap) throws Exception {
            if (wrap != null) {
                String value = wrap.value;
                if (value.endsWith(".a") || value.endsWith(".o")) {
                    return this.fileConverter.write(new File(value));
                }
                return value;
            }
            return null;
        }
    }

    public static final class Lib
    extends AbstractQualified {
        @Text
        PathWrap pathWrap;
        @Attribute(name="force", required=false)
        Boolean force;

        @Persist
        private void nullForceValueBeforeSerialization() {
            if (this.force != null && this.force.booleanValue()) {
                this.force = null;
            }
        }

        protected Lib() {
        }

        public Lib(String value, boolean force) {
            this.pathWrap = new PathWrap(value);
            this.force = force;
        }

        public Lib(String value, boolean force, OS[] platforms, PlatformVariant[] variants, Arch[] arches) {
            this.pathWrap = new PathWrap(value);
            this.force = force;
            this.platforms = platforms;
            this.variants = variants;
            this.arches = arches;
        }

        public String getValue() {
            return this.pathWrap != null ? this.pathWrap.value : null;
        }

        public boolean isForce() {
            return this.force == null || this.force != false;
        }

        @Override
        public String toString() {
            return "Lib [value=" + this.getValue() + ", force=" + this.force + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.force != false ? 1231 : 1237);
            result = 31 * result + (this.pathWrap == null ? 0 : this.pathWrap.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Lib other = (Lib)obj;
            if (this.isForce() != other.isForce()) {
                return false;
            }
            if (this.pathWrap == null) {
                return other.pathWrap == null;
            }
            return this.pathWrap.value.equals(other.pathWrap.value);
        }

        static final class PathWrap {
            String value;

            PathWrap(String v) {
                this.value = v;
            }
        }
    }
}

