/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.config;

import org.robovm.llvm.Target;

public enum OS {
    linux("linux", "unknown", "linux"),
    macosx("macosx", "apple", "10.9"),
    ios("ios", "apple", "8.0");

    private final String llvmName;
    private final String vendor;
    private final String minVersion;

    private OS(String llvmName, String vendor, String minVersion) {
        this.llvmName = llvmName;
        this.vendor = vendor;
        this.minVersion = minVersion;
    }

    public String getLlvmName() {
        return this.llvmName;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public Family getFamily() {
        return this == linux ? Family.linux : Family.darwin;
    }

    public static OS getDefaultOS() {
        String hostTriple = Target.getHostTriple();
        if (hostTriple.contains("linux")) {
            return linux;
        }
        if (hostTriple.contains("darwin") || hostTriple.contains("apple")) {
            return macosx;
        }
        throw new IllegalArgumentException("Unrecognized OS in host triple: " + hostTriple);
    }

    public static enum Family {
        linux,
        darwin;

    }
}

